/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherReference;
import org.apache.xml.security.encryption.EncryptedType;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Log logger = LogFactory.getLog(XMLCipher.class.getName());
    private CipherData _cipherData;
    private int _mode;

    public XMLCipherInput(CipherData cipherData) throws XMLEncryptionException {
        this._cipherData = cipherData;
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType encryptedType) throws XMLEncryptionException {
        this._cipherData = encryptedType == null ? null : encryptedType.getCipherData();
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this._mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String string = null;
        if (this._cipherData.getDataType() == 2) {
            Object object;
            logger.debug("Found a reference type CipherData");
            CipherReference cipherReference = this._cipherData.getCipherReference();
            Attr attr = cipherReference.getURIAsAttr();
            XMLSignatureInput xMLSignatureInput = null;
            try {
                object = ResourceResolver.getInstance(attr, null);
                xMLSignatureInput = ((ResourceResolver)object).resolve(attr, null);
            }
            catch (ResourceResolverException resourceResolverException) {
                throw new XMLEncryptionException("empty", resourceResolverException);
            }
            if (xMLSignatureInput != null) {
                logger.debug("Managed to resolve URI \"" + cipherReference.getURI() + "\"");
            } else {
                logger.debug("Failed to resolve URI \"" + cipherReference.getURI() + "\"");
            }
            object = cipherReference.getTransforms();
            if (object != null) {
                logger.debug("Have transforms in cipher reference");
                try {
                    Transforms transforms = object.getDSTransforms();
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                catch (TransformationException transformationException) {
                    throw new XMLEncryptionException("empty", transformationException);
                }
            }
            try {
                return xMLSignatureInput.getBytes();
            }
            catch (IOException iOException) {
                throw new XMLEncryptionException("empty", iOException);
            }
            catch (CanonicalizationException canonicalizationException) {
                throw new XMLEncryptionException("empty", canonicalizationException);
            }
        }
        if (this._cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        string = this._cipherData.getCipherValue().getValue();
        logger.debug("Encrypted octets:\n" + string);
        byte[] byArray = null;
        try {
            byArray = Base64.decode(string);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new XMLEncryptionException("empty", base64DecodingException);
        }
        return byArray;
    }
}

