/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509Util {
    private static Log log = LogFactory.getLog((class$org$apache$ws$security$processor$X509Util == null ? (class$org$apache$ws$security$processor$X509Util = X509Util.class$("org.apache.ws.security.processor.X509Util")) : class$org$apache$ws$security$processor$X509Util).getName());
    static /* synthetic */ Class class$org$apache$ws$security$processor$X509Util;

    public static boolean isContent(Node encBodyData) {
        String typeStr;
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null && (typeStr = tmpE.getAttribute("Type")) != null) {
            return typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return true;
    }

    public static String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null && (symEncAlgo = tmpE.getAttribute("Algorithm")) == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (log.isDebugEnabled()) {
            log.debug("Sym Enc Algo: " + symEncAlgo);
        }
        return symEncAlgo;
    }

    protected static SecretKey getSharedKey(Element keyInfoElem, String algorithm, CallbackHandler cb) throws WSSecurityException {
        String keyName = null;
        Element keyNmElem = (Element)WSSecurityUtil.getDirectChild(keyInfoElem, "KeyName", "http://www.w3.org/2000/09/xmldsig#");
        if (keyNmElem != null) {
            keyNmElem.normalize();
            Node tmpN = keyNmElem.getFirstChild();
            if (tmpN != null && tmpN.getNodeType() == 3) {
                keyName = tmpN.getNodeValue();
            }
        }
        if (keyName == null) {
            throw new WSSecurityException(3, "noKeyname");
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 4);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName}, e);
        }
        byte[] decryptedData = pwCb.getKey();
        if (decryptedData == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{keyName});
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

