/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;

public class WsdlOperation {
    protected BindingOperation bindingOperation = null;
    protected SOAPBody inputBody = null;
    protected SOAPBody outputBody = null;
    protected List<SOAPHeader> inputHeaderList = new ArrayList<SOAPHeader>();
    protected SOAPHeader inputHeader = null;
    protected SOAPHeader outputHeader = null;
    protected String bindingStyle = "document";
    protected String useStyle = "literal";
    protected String soapActionURI = null;
    protected Message inputMessage = null;
    protected Message outputMessage = null;
    protected Part firstInputPart = null;
    protected Part firstOutputPart = null;

    public BindingOperation getBindingOperation() {
        return this.bindingOperation;
    }

    public Operation getOperation() {
        return this.bindingOperation.getOperation();
    }

    public String getName() {
        return this.bindingOperation.getName();
    }

    public String getSoapActionURI() {
        return this.soapActionURI;
    }

    public String getUseStyle() {
        return this.useStyle;
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public Message getInputMessage() {
        return this.inputMessage;
    }

    public Message getOutputMessage() {
        return this.outputMessage;
    }

    public Part getFirstInputPart() {
        return this.firstInputPart;
    }

    public Part getFirstOutputPart() {
        return this.firstOutputPart;
    }

    public SOAPBody getInputBody() {
        return this.inputBody;
    }

    public SOAPBody getOutputBody() {
        return this.outputBody;
    }

    public SOAPHeader getInputHeader() {
        return this.inputHeader;
    }

    public List getInputHeaderList() {
        return this.inputHeaderList;
    }

    public SOAPHeader getOutputHeader() {
        return this.outputHeader;
    }

    public WsdlOperation(BindingOperation bindOp, String bindingStyle) {
        this.bindingOperation = bindOp;
        if (bindingStyle != null && !bindingStyle.equals("")) {
            this.bindingStyle = bindingStyle;
        }
        if (bindOp.getBindingInput() != null && bindOp.getBindingInput().getExtensibilityElements() != null) {
            for (Object obj : bindOp.getBindingInput().getExtensibilityElements()) {
                if (obj instanceof SOAPBody) {
                    this.inputBody = (SOAPBody)obj;
                    continue;
                }
                if (!(obj instanceof SOAPHeader)) continue;
                this.inputHeader = (SOAPHeader)obj;
                this.inputHeaderList.add(this.inputHeader);
            }
        }
        if (bindOp.getBindingOutput() != null && bindOp.getBindingOutput().getExtensibilityElements() != null) {
            for (Object obj : bindOp.getBindingOutput().getExtensibilityElements()) {
                if (obj instanceof SOAPBody) {
                    this.outputBody = (SOAPBody)obj;
                    continue;
                }
                if (!(obj instanceof SOAPHeader)) continue;
                this.outputHeader = (SOAPHeader)obj;
            }
        }
        if (this.inputBody != null && this.inputBody.getUse() != null && !this.inputBody.getUse().equals("")) {
            this.useStyle = this.inputBody.getUse();
        }
        if (this.outputBody != null && this.outputBody.getUse() != null && !this.outputBody.getUse().equals("")) {
            this.useStyle = this.outputBody.getUse();
        }
        List extensibilityList = bindOp.getExtensibilityElements();
        for (Object obj : extensibilityList) {
            if (!(obj instanceof SOAPOperation)) continue;
            this.soapActionURI = ((SOAPOperation)obj).getSoapActionURI();
        }
        Operation operation = bindOp.getOperation();
        if (operation == null) {
            throw new ARWSException("INVALID_WSDL", "No operation for bindingOperation:" + bindOp.getName() + ": Can't get operation");
        }
        WsdlUtil.trace("  Operation name: " + operation.getName());
        if (operation.getInput() != null) {
            this.inputMessage = operation.getInput().getMessage();
        }
        if (operation.getOutput() != null) {
            this.outputMessage = operation.getOutput().getMessage();
        }
        if (this.inputMessage != null && this.inputMessage.getOrderedParts(null) != null && this.inputMessage.getOrderedParts(null).size() > 0) {
            this.firstInputPart = (Part)this.inputMessage.getOrderedParts(null).get(0);
        }
        if (this.outputMessage != null && this.outputMessage.getOrderedParts(null) != null && this.outputMessage.getOrderedParts(null).size() > 0) {
            this.firstOutputPart = (Part)this.outputMessage.getOrderedParts(null).get(0);
        }
    }
}

