/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomXmlSchemaParser {
    protected LinkedList<OneXmlSchema> schemaDomList = new LinkedList();
    protected HashMap<String, OneXmlSchema> schemaDomMap = new HashMap();
    protected LinkedList globalElementList = new LinkedList();
    protected HashMap globalElementMap = new HashMap();
    protected LinkedList globalComplexTypesList = new LinkedList();
    protected HashMap globalComplexTypesMap = new HashMap();
    protected HashMap<String, String> nsPrefixMap = new HashMap();
    protected int currentNsPrefixIndex = 0;
    protected HashMap<String, String> externalNamespaces = new HashMap();
    protected StringBuffer warnings = new StringBuffer();
    protected boolean isLinked = false;

    public HashMap getNsPrefixMap() {
        return this.nsPrefixMap;
    }

    public HashMap getExternalNamespaces() {
        return this.externalNamespaces;
    }

    public boolean getIsLinked() {
        return this.isLinked;
    }

    public CustomXmlSchemaParser(StringBuffer warnings) {
        this.warnings = warnings;
    }

    public String parseSchema(String parentNamespace, String schemaInfo) {
        if (schemaInfo == null || schemaInfo.equals("")) {
            return null;
        }
        if (schemaInfo.indexOf("<?xml") != -1) {
            InputSource is = new InputSource(new StringReader(schemaInfo));
            Document schemaDom = WsdlUtil.newDocument(is);
            return this.parseSchema(schemaDom.getDocumentElement());
        }
        this.isLinked = true;
        String uri = schemaInfo;
        return this.parseOneSchema(parentNamespace, null, uri);
    }

    public String parseSchema(Element typesElem) {
        this.isLinked = false;
        NodeList schemas = typesElem.getChildNodes();
        for (int i = 0; i < schemas.getLength(); ++i) {
            Element schemaElem;
            Node n = schemas.item(i);
            if (n.getNodeType() != 1 || !(schemaElem = (Element)n).getLocalName().equals("schema")) continue;
            OneXmlSchema schema = new OneXmlSchema(schemaElem);
            String uri = "ns" + this.currentNsPrefixIndex + ".xsd";
            if (this.nsPrefixMap.get(schema.targetNamespace) == null) {
                this.schemaDomMap.put(uri, schema);
                this.schemaDomList.addLast(schema);
            }
            if (this.nsPrefixMap.get(schema.targetNamespace) == null) {
                this.nsPrefixMap.put(schema.targetNamespace, "ns" + this.currentNsPrefixIndex);
                ++this.currentNsPrefixIndex;
            } else if (schema.targetNamespace.length() == 0) {
                throw new ARWSException("INVALID_XSD", "Schema with empty targetnamespace already exists");
            }
            this.externalNamespaces.put(uri, schema.targetNamespace);
            Node n1 = null;
            n = schema.schemaElem.getFirstChild();
            while (n != null) {
                n1 = n.getNextSibling();
                if (n.getNodeType() == 1) {
                    this.addGlobal(schema.targetNamespace, (Element)n, uri);
                }
                n = n1;
            }
        }
        if (this.schemaDomList.size() > 0) {
            return this.schemaDomList.get((int)0).targetNamespace;
        }
        return null;
    }

    public void emdedSchemas(Element typesElement) {
        HashMap<String, Element> combinedSchemaDomMap = new HashMap<String, Element>();
        LinkedList<Element> combinedSchemaDomList = new LinkedList<Element>();
        for (OneXmlSchema schema : this.schemaDomList) {
            Element schemaElem = schema.schemaElem;
            Element importedSchemaDom = (Element)typesElement.getOwnerDocument().importNode(schemaElem, true);
            String targetNamespace = schema.targetNamespace;
            Element combinedSchemaDom = (Element)combinedSchemaDomMap.get(targetNamespace);
            if (combinedSchemaDom == null) {
                combinedSchemaDomMap.put(targetNamespace, importedSchemaDom);
                combinedSchemaDomList.add(importedSchemaDom);
                continue;
            }
            NodeList children = importedSchemaDom.getChildNodes();
            for (int j = children.getLength(); j > 0; --j) {
                combinedSchemaDom.appendChild(children.item(0));
            }
        }
        for (Element combinedSchemaDom : combinedSchemaDomList) {
            typesElement.appendChild(combinedSchemaDom);
        }
    }

    public Document getSchemaInfo() {
        Document schemaInfo = WsdlUtil.newDocument();
        Element typesElement = schemaInfo.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:types");
        schemaInfo.appendChild(typesElement);
        this.emdedSchemas(typesElement);
        return schemaInfo;
    }

    public Document getGlobalElementsAndComplexTypes() {
        Element qelem;
        Document doc = WsdlUtil.newDocument();
        Element root = doc.createElementNS(null, "globals");
        doc.appendChild(root);
        for (QName qname : this.globalElementList) {
            qelem = doc.createElementNS(null, "global");
            root.appendChild(qelem);
            qelem.setAttributeNS(null, "namespace", qname.getNamespaceURI());
            qelem.setAttributeNS(null, "name", qname.getLocalPart());
            qelem.setAttributeNS(null, "type", "element");
        }
        for (QName qname : this.globalComplexTypesList) {
            qelem = doc.createElementNS(null, "global");
            root.appendChild(qelem);
            qelem.setAttributeNS(null, "namespace", qname.getNamespaceURI());
            qelem.setAttributeNS(null, "name", qname.getLocalPart());
            qelem.setAttributeNS(null, "type", "complexType");
        }
        return doc;
    }

    public QName getFirstGlobalElement() {
        Iterator i = this.globalElementList.iterator();
        if (i != null && i.hasNext()) {
            return (QName)i.next();
        }
        return null;
    }

    public QName getFirstGlobalComplexType() {
        Iterator i = this.globalComplexTypesList.iterator();
        if (i != null && i.hasNext()) {
            return (QName)i.next();
        }
        return null;
    }

    public String parseOneSchema(String parentNamespace, String baseUri, String schemaUri) {
        String uri = XMLSchemaParser.expandSystemId(schemaUri, baseUri);
        OneXmlSchema schema = this.schemaDomMap.get(uri);
        if (schema != null) {
            return schema.targetNamespace;
        }
        schema = new OneXmlSchema(uri, parentNamespace);
        this.schemaDomMap.put(uri, schema);
        this.schemaDomList.addLast(schema);
        if (baseUri == null) {
            this.externalNamespaces.put(schemaUri, schema.targetNamespace);
        }
        if (this.nsPrefixMap.get(schema.targetNamespace) == null) {
            this.nsPrefixMap.put(schema.targetNamespace, "ns" + this.currentNsPrefixIndex);
            ++this.currentNsPrefixIndex;
        }
        Node n1 = null;
        Node n = schema.schemaElem.getFirstChild();
        while (n != null) {
            n1 = n.getNextSibling();
            if (n.getNodeType() == 1) {
                Element child = (Element)n;
                if (child.getLocalName().equals("import")) {
                    this.parseOneSchema(child.getAttribute("namespace"), uri, child.getAttribute("schemaLocation"));
                    child.removeAttribute("schemaLocation");
                } else if (child.getLocalName().equals("include")) {
                    this.parseOneSchema(schema.targetNamespace, uri, child.getAttribute("schemaLocation"));
                    child.getParentNode().removeChild(child);
                } else {
                    this.addGlobal(schema.targetNamespace, child, uri);
                }
            }
            n = n1;
        }
        return schema.targetNamespace;
    }

    public void addGlobal(String targetNamespace, Element global, String uri) {
        LinkedList globalsList;
        HashMap globalsMap;
        String globalType = global.getLocalName();
        if (globalType.equals("element")) {
            globalsMap = this.globalElementMap;
            globalsList = this.globalElementList;
        } else if (globalType.equals("complexType")) {
            globalsMap = this.globalComplexTypesMap;
            globalsList = this.globalComplexTypesList;
        } else {
            return;
        }
        QName name = new QName(targetNamespace, global.getAttribute("name"));
        if (globalsMap.get(name) == null) {
            globalsList.add(name);
            globalsMap.put(name, "");
        } else {
            global.getParentNode().removeChild(global);
            this.warnings.append("WARNING: Ignoring " + globalType + " " + name + " from " + uri + "as it already exists" + System.getProperty("line.separator"));
        }
    }

    public void AddImportsForExternalNamespaces(OneXmlSchema schema, Document schemaDom) {
        HashMap extMap = this.getExternalNamespaces();
        Iterator iter = extMap.keySet().iterator();
        Element lastElement = null;
        while (iter.hasNext()) {
            String nsuri = (String)iter.next();
            String nspace = (String)extMap.get(nsuri);
            if (nspace == null || nspace.equals(schema.targetNamespace)) continue;
            String nsPrefix = this.nsPrefixMap.get(nspace);
            NodeList impElem = schemaDom.getDocumentElement().getElementsByTagNameNS("*", "import");
            boolean bFound = false;
            for (int j = 0; j < impElem.getLength(); ++j) {
                Element importElem;
                lastElement = importElem = (Element)impElem.item(j);
                String nameSpace = importElem.getAttribute("namespace");
                if (nameSpace == null || !nspace.equals(nameSpace)) continue;
                bFound = true;
                break;
            }
            if (bFound || nsPrefix == null || nspace.equals("")) continue;
            Element schemaElem = schemaDom.getDocumentElement();
            String prefix = schemaElem.getPrefix();
            Element importElem = schemaDom.createElementNS("http://www.w3.org/2001/XMLSchema", prefix != null ? prefix + ":import" : "import");
            importElem.setAttributeNS(null, "namespace", nspace);
            importElem.setAttributeNS(null, "schemaLocation", nsPrefix + ".xsd");
            if (lastElement == null) {
                Node nd;
                for (nd = schemaElem.getFirstChild(); nd != null && nd.getNodeType() != 1; nd = nd.getNextSibling()) {
                }
                if (nd != null && nd.getNodeType() == 1) {
                    lastElement = (Element)nd;
                }
            }
            if (lastElement == null) continue;
            schemaElem.insertBefore(importElem, lastElement);
        }
    }

    public String writeSchemasToTempDir(String tempDir, ArrayList xmlnsList, Node soapEncNs) {
        if (this.schemaDomList.size() == 0) {
            return null;
        }
        String dirName = tempDir + System.getProperty("file.separator");
        for (int i = 0; i < this.schemaDomList.size(); ++i) {
            OneXmlSchema schema = this.schemaDomList.get(i);
            Document schemaDom = null;
            try {
                schemaDom = WsdlUtil.newDocument();
                Node newNode = schemaDom.importNode(schema.schemaElem, true);
                schemaDom.appendChild(newNode);
            }
            catch (DOMException e) {
                throw new ARWSException("OTHER_ERROR", "DomException while importing" + e, e);
            }
            if (xmlnsList != null) {
                for (int j = 0; j < xmlnsList.size(); ++j) {
                    Attr attr = (Attr)xmlnsList.get(j);
                    NamedNodeMap existingNodes = schemaDom.getDocumentElement().getAttributes();
                    if (this.exists(existingNodes, attr)) continue;
                    Attr newAttr = (Attr)schemaDom.importNode(attr, true);
                    schemaDom.getDocumentElement().setAttributeNodeNS(newAttr);
                }
            }
            NodeList importElements = schemaDom.getDocumentElement().getElementsByTagNameNS("*", "import");
            boolean foundSoapEncImport = false;
            for (int j = 0; j < importElements.getLength(); ++j) {
                String nsPrefix;
                Element importElem = (Element)importElements.item(j);
                String nameSpace = importElem.getAttribute("namespace");
                if (nameSpace == null) continue;
                if (nameSpace.equals(Constants.URI_DEFAULT_SOAP_ENC)) {
                    foundSoapEncImport = true;
                }
                if ((nsPrefix = this.nsPrefixMap.get(nameSpace)) == null) continue;
                importElem.setAttributeNS(null, "schemaLocation", nsPrefix + ".xsd");
            }
            if (soapEncNs != null && !foundSoapEncImport) {
                Element schemaElem = schemaDom.getDocumentElement();
                String prefix = schemaElem.getPrefix();
                Element importElem = schemaDom.createElementNS("http://www.w3.org/2001/XMLSchema", prefix != null ? prefix + ":import" : "import");
                importElem.setAttributeNS(null, "namespace", Constants.URI_DEFAULT_SOAP_ENC);
                importElem.setAttributeNS(null, "schemaLocation", Constants.URI_DEFAULT_SOAP_ENC);
                schemaElem.insertBefore(importElem, schemaElem.getFirstChild());
            }
            this.AddImportsForExternalNamespaces(schema, schemaDom);
            try {
                String nsPrefix = this.nsPrefixMap.get(schema.targetNamespace);
                FileOutputStream fileStream = new FileOutputStream(dirName + nsPrefix + ".xsd");
                XMLUtils.PrettyDocumentToWriter(schemaDom, new OutputStreamWriter((OutputStream)fileStream, "utf-8"));
                continue;
            }
            catch (FileNotFoundException e) {
                throw new ARWSException("CANT_CREATE_TEMP_FILES", "Cannot create file: " + dirName + "s" + i + ".xsd " + e, e);
            }
            catch (UnsupportedEncodingException e) {
                throw new ARWSException("OTHER_ERROR", e.getMessage(), e);
            }
        }
        return dirName + "ns0.xsd";
    }

    public String getFirstNamespace() {
        if (this.schemaDomList.size() >= 1) {
            OneXmlSchema schema = this.schemaDomList.get(0);
            return schema.targetNamespace;
        }
        return null;
    }

    boolean exists(NamedNodeMap existingNodes, Attr attr) {
        boolean bool = false;
        Node node = existingNodes.getNamedItem(attr.getName());
        bool = node != null;
        return bool;
    }

    public class OneXmlSchema {
        protected String uri = null;
        protected String targetNamespace = null;
        protected Document schemaDom = null;
        protected Element schemaElem = null;

        public OneXmlSchema(String uri, String parentNamespace) {
            this.schemaDom = WsdlUtil.newDocument(uri, false);
            this.schemaElem = this.schemaDom.getDocumentElement();
            if (!this.schemaElem.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + uri + " does not have root element as schema");
            }
            this.targetNamespace = this.schemaElem.getAttribute("targetNamespace");
            if (this.targetNamespace == null || this.targetNamespace.equals("")) {
                this.targetNamespace = parentNamespace;
                this.schemaElem.setAttributeNS(null, "targetNamespace", this.targetNamespace);
            }
        }

        public OneXmlSchema(Element schemaElem) {
            if (!schemaElem.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + this.uri + " does not have root element as schema");
            }
            this.schemaElem = schemaElem;
            this.schemaDom = schemaElem.getOwnerDocument();
            this.targetNamespace = schemaElem.getAttribute("targetNamespace");
        }
    }
}

