/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.snmp.helper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetHelper {
    public static final Pattern URL = Pattern.compile("((((https?|ftps?|gopher|telnet|nntp)://)|(mailto:|news:))(%[0-9A-Fa-f]{2}|[-()_.!~*';/?:@&=+$,A-Za-z0-9])+)([).!';/?:,][[:blank:]])?");
    public static final Pattern FQDN_HOST_NAME = Pattern.compile("\\b((?:[a-zA-Z0-9](?:[a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,63})\\b");
    public static final Pattern LAX_FQDN_HOST_NAME = Pattern.compile("\\b((?:[a-zA-Z0-9](?:[a-zA-Z0-9\\-_]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]{2,63})\\b");
    public static final Pattern IP_ADDRESS = Pattern.compile("\\b((?:(?:25[0-5]|2[0-4]\\d|[01]\\d\\d|\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]\\d\\d|\\d?\\d))\\b");
    public static final Pattern EMAIL_ADDRESS = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+@[a-zA-Z0-9\\-]+\\.[a-zA-Z0-9\\.]+$");
    public static final int MINIMUM_PORT = 0;
    public static final int MAXIMUM_PORT = 65535;
    public static final int MAXIMUM_RESTRICTED_PORT = 1023;
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;

    public static boolean isValidURL(String url) {
        boolean result = false;
        if (url != null) {
            Matcher matcher = URL.matcher(url);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean isValidURL(String url, boolean allowIPV6) {
        boolean result = false;
        if (url != null && !(result = NetHelper.isValidURL(url)) && allowIPV6) {
            int startIndex = url.indexOf(91);
            int endIndex = url.indexOf(93);
            if (startIndex > 0 && endIndex > startIndex) {
                String prefix = url.substring(0, startIndex);
                String ipV6Potential = url.substring(startIndex + 1, endIndex);
                String suffix = url.substring(endIndex + 1);
                if (NetHelper.isIPv6LiteralAddress(ipV6Potential)) {
                    String dummyIPV4URL = prefix + "127.0.0.1" + suffix;
                    result = NetHelper.isValidURL(dummyIPV4URL);
                }
            }
        }
        return result;
    }

    public static String getPrettyHostName(String hostName) {
        String result;
        try {
            InetAddress x = InetAddress.getByName(hostName);
            result = x.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            result = hostName;
        }
        return result;
    }

    public static String getLocalHostIP() {
        String result = "";
        try {
            result = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            result = "127.0.0.1";
        }
        if (result == null || result.trim().equals("")) {
            result = "127.0.0.1";
        }
        return result;
    }

    public static boolean isLocalHostName(String hostName) {
        boolean result = false;
        if (hostName != null) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                InetAddress[] addresses = InetAddress.getAllByName(hostName);
                for (int i = 0; !result && i < addresses.length; ++i) {
                    result = localhost.equals(addresses[i]);
                    if (result || !addresses[i].isLoopbackAddress()) continue;
                    result = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isValidFQDNHostName(String hostName) {
        boolean result = false;
        if (hostName != null) {
            Matcher matcher = FQDN_HOST_NAME.matcher(hostName);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean isValidLaxFQDNHostName(String hostName) {
        boolean result = false;
        if (hostName != null) {
            Matcher matcher = LAX_FQDN_HOST_NAME.matcher(hostName);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean canGetIPForHostName(String hostName) {
        boolean result = false;
        try {
            byte[] address;
            InetAddress inetAddress;
            if (hostName != null && (inetAddress = InetAddress.getByName(hostName)) != null && (address = inetAddress.getAddress()) != null) {
                result = true;
            }
        }
        catch (Throwable t) {
            result = false;
        }
        return result;
    }

    public static boolean isActiveHostName(String hostName) {
        boolean result = false;
        if (hostName != null && !hostName.trim().equals("")) {
            try {
                InetAddress.getByName(hostName);
                result = true;
            }
            catch (Throwable t) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isValidIP(String ipAddress) {
        boolean result = false;
        if (ipAddress != null) {
            Matcher matcher = IP_ADDRESS.matcher(ipAddress);
            result = matcher.matches();
        }
        return result;
    }

    public static boolean isValidIP(String ipAddress, boolean allowIPV6) {
        boolean result = false;
        if (ipAddress != null && !(result = NetHelper.isValidIP(ipAddress)) && allowIPV6) {
            result = NetHelper.isIPv6LiteralAddress(ipAddress);
        }
        return result;
    }

    public static boolean isActiveIP(String ipAddress) {
        boolean result = false;
        if (ipAddress != null && !ipAddress.trim().equals("")) {
            try {
                InetAddress addr = InetAddress.getByName(ipAddress);
                addr = InetAddress.getByName(addr.getHostName());
                result = true;
            }
            catch (Throwable t) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isRestrictedPort(String port) {
        boolean result = false;
        if (port != null) {
            try {
                int portNumber = Integer.parseInt(port);
                if (portNumber >= 0 && portNumber <= 1023) {
                    result = true;
                }
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isPortOpen(String host, int port) {
        boolean result = false;
        try {
            InetAddress address = InetAddress.getByName(host);
            Socket socket = new Socket(address, port);
            result = socket.isConnected();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean canBindPort(int port) {
        boolean result = false;
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            serverSocket.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isPortBound(String host, int port) {
        boolean result = false;
        try {
            InetAddress address = InetAddress.getByName(host);
            Socket socket = new Socket(address, port);
            result = socket.isBound();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isValidEmail(String email) {
        boolean result = false;
        if (email != null) {
            Matcher matcher = EMAIL_ADDRESS.matcher(email);
            result = matcher.matches();
        }
        return result;
    }

    public static String getBestFQDNMatch(String hostName) {
        String result = null;
        String host1 = null;
        String host2 = null;
        String host3 = null;
        if (hostName != null) {
            if (NetHelper.isValidFQDNHostName(hostName)) {
                result = hostName;
            } else {
                try {
                    String localHost = InetAddress.getLocalHost().getCanonicalHostName();
                    String localDomain = localHost.substring(localHost.indexOf(46));
                    InetAddress[] addresses = InetAddress.getAllByName(hostName);
                    boolean done = false;
                    for (int j = 0; j < addresses.length && !done; ++j) {
                        String tmpHostName = addresses[j].getHostName();
                        String tmpCanonicalHost = addresses[j].getCanonicalHostName();
                        String tmpDomain = tmpCanonicalHost.substring(tmpCanonicalHost.indexOf(46));
                        if (tmpHostName.equals(hostName) && tmpDomain.equals(localDomain)) {
                            host1 = tmpCanonicalHost;
                            done = true;
                            continue;
                        }
                        if (tmpHostName.equals(hostName) && NetHelper.isValidFQDNHostName(tmpHostName)) {
                            host2 = tmpCanonicalHost;
                            continue;
                        }
                        host3 = tmpCanonicalHost;
                    }
                }
                catch (Throwable t) {
                    result = hostName;
                }
                result = host1 != null ? host1 : (host2 != null ? host2 : (host3 != null ? host3 : hostName));
            }
        }
        return result;
    }

    private NetHelper() {
    }

    private static byte[] textToNumericFormatV4(String src) {
        byte[] result = null;
        if (src.length() != 0) {
            result = new byte[4];
            String[] s = src.split("\\.", -1);
            try {
                switch (s.length) {
                    case 1: {
                        long value = Long.parseLong(s[0]);
                        if (value < 0L || value > 0xFFFFFFFFL) {
                            result = null;
                            break;
                        }
                        result[0] = (byte)(value >> 24 & 0xFFL);
                        result[1] = (byte)((value & 0xFFFFFFL) >> 16 & 0xFFL);
                        result[2] = (byte)((value & 0xFFFFL) >> 8 & 0xFFL);
                        result[3] = (byte)(value & 0xFFL);
                        break;
                    }
                    case 2: {
                        long value = Integer.parseInt(s[0]);
                        if (value < 0L || value > 255L) {
                            result = null;
                            break;
                        }
                        result[0] = (byte)(value & 0xFFL);
                        value = Integer.parseInt(s[1]);
                        if (value < 0L || value > 0xFFFFFFL) {
                            result = null;
                            break;
                        }
                        result[1] = (byte)(value >> 16 & 0xFFL);
                        result[2] = (byte)((value & 0xFFFFL) >> 8 & 0xFFL);
                        result[3] = (byte)(value & 0xFFL);
                        break;
                    }
                    case 3: {
                        long value;
                        for (int i = 0; i < 2; ++i) {
                            value = Integer.parseInt(s[i]);
                            if (value < 0L || value > 255L) {
                                result = null;
                                continue;
                            }
                            result[i] = (byte)(value & 0xFFL);
                        }
                        value = Integer.parseInt(s[2]);
                        if (value < 0L || value > 65535L) {
                            result = null;
                            break;
                        }
                        result[2] = (byte)(value >> 8 & 0xFFL);
                        result[3] = (byte)(value & 0xFFL);
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < 4; ++i) {
                            long value = Integer.parseInt(s[i]);
                            if (value < 0L || value > 255L) {
                                result = null;
                                continue;
                            }
                            result[i] = (byte)(value & 0xFFL);
                        }
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                result = null;
            }
        }
        return result;
    }

    private static byte[] textToNumericFormatV6(String src) {
        if (src.length() < 2) {
            return null;
        }
        char[] srcb = src.toCharArray();
        byte[] dst = new byte[16];
        int srcbLength = srcb.length;
        int pc = src.indexOf("%");
        if (pc == srcbLength - 1) {
            return null;
        }
        if (pc != -1) {
            srcbLength = pc;
        }
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (srcb[i] == ':' && srcb[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean sawXdigit = false;
        int val = 0;
        while (i < srcbLength) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = srcb[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                sawXdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!sawXdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcbLength) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                sawXdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = src.substring(curtok, srcbLength);
                int dotCount = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dotCount;
                    ++index;
                }
                if (dotCount != 3) {
                    return null;
                }
                byte[] v4addr = NetHelper.textToNumericFormatV4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                sawXdigit = false;
                break;
            }
            return null;
        }
        if (sawXdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        byte[] result = null;
        if (j == 16) {
            byte[] newdst = NetHelper.convertFromIPv4MappedAddress(dst);
            result = newdst != null ? newdst : dst;
        }
        return result;
    }

    public static boolean isIPv6LiteralAddress(String src) {
        return NetHelper.textToNumericFormatV6(src) != null;
    }

    private static byte[] convertFromIPv4MappedAddress(byte[] addr) {
        byte[] result = null;
        if (NetHelper.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            result = newAddr;
        }
        return result;
    }

    private static boolean isIPv4MappedAddress(byte[] addr) {
        boolean result = false;
        if (addr.length >= 16 && addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1) {
            result = true;
        }
        return result;
    }
}

