/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.snmp;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.snmp.helper.SNMPConfFileCreate;
import com.bmc.arsys.plugins.snmp.helper.SNMPConfFileHelper;
import com.bmc.arsys.plugins.snmp.helper.SNMPPluginConstants;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SNMPPlugin
extends ARDBCPlugin
implements SNMPPluginConstants {
    private static Logger log = Logger.getLogger(SNMPPlugin.class);
    private static SNMPConfFileCreate snmpFileHelper;
    private static String arsnmpdstr;
    private static String armonitorstr;
    private static File arsnmpdFile;
    private static File snmpdFile;
    private static File armonitorFile;
    private static String arserverName;

    public static void init(ARPluginContext arPluginContext) throws ARException {
        log.info((Object)"###############################################################");
        log.info((Object)"Plugin initialization.");
        log.info((Object)("Plugin name is " + arPluginContext.getPluginInfo().getName()));
        log.info((Object)("Plugin version is " + arPluginContext.getPluginInfo().getVersion()));
        snmpFileHelper = new SNMPConfFileCreate();
        arsnmpdstr = arPluginContext.getConfigItem("arconfPath");
        log.debug((Object)("AR Conf Path: " + arsnmpdstr));
        armonitorstr = arPluginContext.getConfigItem("armonitorPath");
        log.debug((Object)("AR Monitor Path: " + armonitorstr));
        arsnmpdFile = new File(arsnmpdstr + SNMPConfFileHelper.getFileSeparator() + "conf" + SNMPConfFileHelper.getFileSeparator() + "arsnmpd" + SNMPConfFileHelper.getConfExtension());
        armonitorFile = new File(armonitorstr + SNMPConfFileHelper.getFileSeparator() + "armonitor" + SNMPConfFileHelper.getConfExtension());
        snmpdFile = new File(arsnmpdstr + SNMPConfFileHelper.getFileSeparator() + SNMPConfFileHelper.getFileSeparator() + "conf" + SNMPConfFileHelper.getFileSeparator() + "snmpd.conf");
        arserverName = arPluginContext.getARConfigEntry("Server-Name");
        log.debug((Object)("AR Server Name: " + arserverName));
        log.info((Object)"###############################################################");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        String ar = "";
        try {
            log.debug((Object)"In Method createEntry");
            Class<SNMPPlugin> clazz = SNMPPlugin.class;
            synchronized (SNMPPlugin.class) {
                snmpFileHelper.createEntrySNMP(arsnmpdFile, armonitorFile, snmpdFile, arsnmpdstr, arserverName, entry);
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
        {
            return ar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(ARPluginContext arPluginContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        Entry entry;
        try {
            Class<SNMPPlugin> clazz = SNMPPlugin.class;
            synchronized (SNMPPlugin.class) {
                entry = this.readconfFile();
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("The SNMP Plugin could not retrieve getEntry", thr);
        }
        {
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        try {
            Class<SNMPPlugin> clazz = SNMPPlugin.class;
            synchronized (SNMPPlugin.class) {
                log.debug((Object)"In Method setEntry");
                Entry entry1 = this.readconfFile();
                entry1.putAll((Map)entry);
                snmpFileHelper.createEntrySNMP(arsnmpdFile, armonitorFile, snmpdFile, arsnmpdstr, arserverName, entry1);
                // ** MonitorExit[var9_8] (shouldn't be in output)
            }
        }
        catch (Exception ex) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + ex.getLocalizedMessage());
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getListEntryWithFields(ARPluginContext arPluginContext, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, List<SortInfo> sortList, List<EntryListFieldInfo> getListFields, int startAt, int maxRetrieve, OutputInteger numMatches) throws ARException {
        ArrayList<Entry> listEntries = new ArrayList<Entry>();
        try {
            Class<SNMPPlugin> clazz = SNMPPlugin.class;
            synchronized (SNMPPlugin.class) {
                Entry entry = this.readconfFile();
                log.debug((Object)"In Method getListEntryWithFields");
                entry.put(Integer.valueOf(1), new Value("000000000000001"));
                listEntries.add(entry);
                if (numMatches != null) {
                    numMatches.setValue(listEntries.size());
                }
                // ** MonitorExit[var13_12] (shouldn't be in output)
            }
        }
        catch (Throwable thr) {
            throw new RuntimeException("The SNMP Plugin could not retrieve getListEntryWithFields", thr);
        }
        {
            return listEntries;
        }
    }

    public void terminate(ARPluginContext arPluginContext) throws ARException {
        arsnmpdFile = null;
        armonitorFile = null;
        snmpdFile = null;
        snmpFileHelper = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"###############################################################");
            log.info((Object)("Plugin name is " + arPluginContext.getPluginInfo().getName()));
            log.info((Object)"Plugin terminated");
            log.info((Object)"###############################################################");
        }
    }

    public Entry readconfFile() {
        Entry entry = new Entry();
        try {
            String[] instanceTokens;
            log.debug((Object)"In Method getEntry");
            Properties arsnmpdMap = snmpFileHelper.readArSNMPD(arsnmpdFile);
            String strPort = snmpFileHelper.readArMonitorforPort(armonitorFile);
            entry.put(Integer.valueOf(500007820), new Value(Integer.parseInt(strPort.equals("") ? "0" : strPort)));
            boolean isArmonitorset = snmpFileHelper.readArMonitorforConfig(armonitorFile);
            String sys_loc_str = arsnmpdMap.getProperty("syslocation");
            String admin_contact_str = arsnmpdMap.getProperty("syscontact");
            String read_only_community_str = "";
            if (arsnmpdMap.getProperty("rocommunity") != null) {
                read_only_community_str = arsnmpdMap.getProperty("rocommunity");
            } else if (arsnmpdMap.getProperty("rocommunity6") != null) {
                read_only_community_str = arsnmpdMap.getProperty("rocommunity6");
            }
            String read_write_community_str = "";
            if (arsnmpdMap.getProperty("rwcommunity") != null) {
                read_write_community_str = arsnmpdMap.getProperty("rwcommunity");
            } else if (arsnmpdMap.getProperty("rwcommunity6") != null) {
                read_write_community_str = arsnmpdMap.getProperty("rwcommunity6");
            }
            String read_only_user_name_usercomm = arsnmpdMap.getProperty("rouser");
            String read_write_user_name_usercomm = arsnmpdMap.getProperty("rwuser");
            String enable_traps_str = "";
            if (arsnmpdMap.getProperty("authtrapenable") != null && !arsnmpdMap.getProperty("authtrapenable").equals("") && arsnmpdMap.getProperty("authtrapenable").equals("1")) {
                enable_traps_str = "0";
            } else if (arsnmpdMap.getProperty("authtrapenable") != null && !arsnmpdMap.getProperty("authtrapenable").equals("") && arsnmpdMap.getProperty("authtrapenable").equals("2")) {
                enable_traps_str = "1";
            }
            String trap_version_str = "";
            int trap_ver = 0;
            if (arsnmpdMap.getProperty("trapsink") != null && !arsnmpdMap.getProperty("trapsink").equals("")) {
                trap_version_str = arsnmpdMap.getProperty("trapsink");
                trap_ver = 0;
            } else if (arsnmpdMap.getProperty("trap2sink") != null && !arsnmpdMap.getProperty("trap2sink").equals("")) {
                trap_version_str = arsnmpdMap.getProperty("trap2sink");
                trap_ver = 1;
            }
            entry.put(new Integer(1), new Value("000000000000001"));
            entry.put(Integer.valueOf(500007800), new Value(sys_loc_str != null ? sys_loc_str : ""));
            entry.put(Integer.valueOf(500007810), new Value(admin_contact_str != null ? admin_contact_str : ""));
            entry.put(Integer.valueOf(500007840), new Value(read_only_community_str != null ? read_only_community_str : ""));
            entry.put(Integer.valueOf(500007850), new Value(read_write_community_str != null ? read_write_community_str : ""));
            int auth_mode_req_str = 0;
            String user_name_usercomm_str = "";
            int access_mode_usercomm_str = 0;
            String auth_mode_usercomm_str = "";
            String sys_receive_traps_str = "";
            String snmp_trap_community_str = "";
            int snmp_trap_port_int = 0;
            if (read_only_community_str != null && !read_only_community_str.equals("")) {
                auth_mode_req_str = 0;
            }
            if (read_write_community_str != null && !read_write_community_str.equals("")) {
                auth_mode_req_str = 0;
            }
            if (read_only_user_name_usercomm != null && !read_only_user_name_usercomm.equals("")) {
                instanceTokens = read_only_user_name_usercomm.split(" ");
                user_name_usercomm_str = instanceTokens[0];
                auth_mode_usercomm_str = instanceTokens[1];
                access_mode_usercomm_str = 0;
                auth_mode_req_str = 1;
            }
            if (read_write_user_name_usercomm != null && !read_write_user_name_usercomm.equals("")) {
                instanceTokens = read_write_user_name_usercomm.split(" ");
                if (!(instanceTokens[0] == null || instanceTokens[0].equals("") || instanceTokens[0].startsWith("noauth") || instanceTokens[0].startsWith("auth") || instanceTokens[0].startsWith("priv"))) {
                    user_name_usercomm_str = instanceTokens[0];
                    auth_mode_usercomm_str = instanceTokens[1] != null ? instanceTokens[1] : "";
                } else {
                    user_name_usercomm_str = "";
                    auth_mode_usercomm_str = instanceTokens[0];
                }
                access_mode_usercomm_str = 1;
                auth_mode_req_str = 1;
            }
            if (trap_version_str != null && !trap_version_str.equals("")) {
                if (trap_version_str.contains("<Trap System>")) {
                    trap_version_str = trap_version_str.replace("<Trap System>", "<TrapSystem>");
                }
                if (trap_version_str.contains("<Trap Community>")) {
                    trap_version_str = trap_version_str.replace("<Trap Community>", "<TrapCommunity>");
                }
                instanceTokens = trap_version_str.trim().split(" ");
                boolean portDetecetd = false;
                if (instanceTokens != null && instanceTokens.length >= 1 && instanceTokens[0] != null && !SNMPConfFileHelper.digitsOnly(instanceTokens[0])) {
                    if (instanceTokens[0].contains("udp6:[")) {
                        sys_receive_traps_str = instanceTokens[0].substring(instanceTokens[0].indexOf("[") + 1, instanceTokens[0].indexOf("]"));
                        String port = instanceTokens[0].substring(instanceTokens[0].lastIndexOf(":") + 1);
                        if (port != null && SNMPConfFileHelper.digitsOnly(port)) {
                            snmp_trap_port_int = Integer.parseInt(port);
                            portDetecetd = true;
                        } else {
                            portDetecetd = false;
                        }
                    } else {
                        sys_receive_traps_str = instanceTokens[0].contains("udp6:") ? instanceTokens[0].substring(instanceTokens[0].indexOf(":") + 1) : instanceTokens[0];
                    }
                }
                if (instanceTokens != null && instanceTokens.length > 1 && instanceTokens[1] != null && !SNMPConfFileHelper.digitsOnly(instanceTokens[1])) {
                    snmp_trap_community_str = instanceTokens[1];
                }
                if (instanceTokens != null && instanceTokens.length > 2 && instanceTokens[2] != null && SNMPConfFileHelper.digitsOnly(instanceTokens[2]) && !portDetecetd) {
                    snmp_trap_port_int = Integer.parseInt(instanceTokens[2]);
                }
            }
            int auth_mode_user = 0;
            auth_mode_user = auth_mode_usercomm_str.equals("noauth") ? 0 : (auth_mode_usercomm_str.equals("auth") ? 1 : (auth_mode_usercomm_str.equals("priv") ? 2 : 0));
            entry.put(Integer.valueOf(500007830), new Value(auth_mode_req_str));
            entry.put(Integer.valueOf(500007860), new Value(user_name_usercomm_str));
            entry.put(Integer.valueOf(500007870), new Value(access_mode_usercomm_str));
            entry.put(Integer.valueOf(500007880), new Value(auth_mode_user));
            entry.put(Integer.valueOf(500007910), new Value(enable_traps_str));
            entry.put(Integer.valueOf(500007920), new Value(trap_ver));
            entry.put(Integer.valueOf(500007930), new Value(sys_receive_traps_str));
            entry.put(Integer.valueOf(500007940), new Value(snmp_trap_community_str));
            entry.put(Integer.valueOf(500007950), new Value(snmp_trap_port_int));
            entry.put(Integer.valueOf(500007960), new Value(isArmonitorset ? "0" : "1"));
            entry.put(Integer.valueOf(500007890), new Value(""));
            entry.put(Integer.valueOf(500007900), new Value(""));
        }
        catch (Throwable thr) {
            throw new RuntimeException("Failed to read the data from SNMP Configuration Files.", thr);
        }
        return entry;
    }

    static {
        arsnmpdstr = "";
        armonitorstr = "";
        arsnmpdFile = null;
        snmpdFile = null;
        armonitorFile = null;
        arserverName = "";
    }
}

