/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsplugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.TikaDocHandler;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FTSPlugin
extends ARFilterAPIPlugin {
    private static final String GCE_UTIL_APP_METHOD_NAME = "GCEUtilApp";
    private static final String AR_UTIL_EGCP_CLASS_NAME = "com.bmc.arsys.util.ARUtilEgcp";
    private static final String REMEDY_APP_SERVICE_PASSWORD_KEY = "Remedy-App-Service-Password";
    private static FTSService m_service = null;
    private static TikaDocHandler m_docHandler = new TikaDocHandler();
    private static final Logger LOGGER = Logger.getLogger(FTSPlugin.class);
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.FTS", (ARPluggable)this);
    private static final int AR_DEFAULT_FT_OPTIMIZE_THRESHOLD = 1000;
    private static final int AR_MIN_FT_OPTIMIZE_THRESHOLD = 10;
    private static final String strSeeLogMsg = new String("-See logfile for details.");
    private static int deletePolicyTime = 0;
    private static String getIndexSearcherRetry = "1:0";

    public static void init(ARPluginContext context) throws ARException {
        LOGGER.info((Object)"FTSPlugin initialize()");
        m_service = LuceneFTSService.getLuceneFTSService();
        if (context != null) {
            String indexSearcherRetry;
            String collectionDir = context.getConfigItem("ftCollectionDir");
            String configDir = context.getConfigItem("ftConfigDir");
            String caseSensitivity = context.getConfigItem("ftCaseSensitivity");
            int caseSensitivityVal = 0;
            if ("false".equals(caseSensitivity)) {
                caseSensitivityVal = 1;
            }
            String stopFilename = context.getConfigItem("ftStopFile");
            String optThreshold = context.getConfigItem("ftOptimizeThreshold");
            int optimizeThreshold = 1000;
            if (optThreshold != null) {
                optimizeThreshold = new Integer(optThreshold);
            }
            if (optimizeThreshold < 10) {
                optimizeThreshold = 10;
            }
            String ftLangCode = context.getConfigItem("ftLangCode");
            int searchThreshold = 10000;
            String strSearchThreshold = context.getConfigItem("ftSearchThreshold");
            try {
                if (strSearchThreshold != null) {
                    searchThreshold = new Integer(strSearchThreshold);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String delPolicyTime = context.getConfigItem("ftDeletePolicyTime");
            if (delPolicyTime != null) {
                deletePolicyTime = new Integer(delPolicyTime);
            }
            if ((indexSearcherRetry = context.getConfigItem("ftGetIndexSearcherRetry")) != null) {
                getIndexSearcherRetry = indexSearcherRetry;
            }
            FTSPlugin.initializeSearchService(collectionDir, configDir, caseSensitivityVal, optimizeThreshold, ftLangCode, searchThreshold, deletePolicyTime, getIndexSearcherRetry, false);
        }
    }

    public void terminate(ARPluginContext context) throws ARException {
        LOGGER.info((Object)"FTSPlugin terminate()");
        this.closeOperation();
    }

    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        if (m_service == null) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: SearchService is invalid");
            throw new ARException(2, 657, "filterAPICall: SearchService is invalid");
        }
        if (pInValues == null || pInValues.size() == 0) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: No input values supplied");
            throw new ARException(2, 862, "filterAPICall: No input values supplied");
        }
        Value val = pInValues.get(0);
        if (val.getDataType() != DataType.INTEGER) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: OP Code needs to be an integer value between 0-5");
            throw new ARException(2, 663);
        }
        int opCode = (Integer)val.getValue();
        LOGGER.info((Object)("FTSPlugin filterAPICall: OP Code = " + opCode));
        switch (opCode) {
            case 0: {
                this.initOperation(context, pInValues);
                break;
            }
            case 1: {
                this.createUpdateOperation(opCode, pInValues);
                break;
            }
            case 2: {
                this.createUpdateOperation(opCode, pInValues);
                break;
            }
            case 3: {
                this.deleteOperation(pInValues);
                break;
            }
            case 4: {
                this.checkIfReindex(context);
                return this.getOperation(pInValues);
            }
            case 5: {
                this.closeOperation();
                break;
            }
            case 6: {
                this.commitOperation();
                break;
            }
            case 7: {
                this.updateConfigOperation();
                break;
            }
            case 8: {
                this.checkIfReindex(context);
                return this.multiGetOperation(pInValues);
            }
            case 9: {
                this.setDocBoost(pInValues);
                break;
            }
            default: {
                LOGGER.error((Object)("FTSPlugin filterAPICall: Invalid OP Code: " + opCode));
                throw new ARException(2, 864, new String("filterAPICall: Invalid OP Code: " + opCode));
            }
        }
        return null;
    }

    private ARServerUser createConnection(ARPluginContext context) throws ARException {
        String serverName = context.getARConfigEntry("Server-Connect-Name");
        if (StringUtils.isEmpty((String)serverName) && StringUtils.isEmpty((String)(serverName = context.getARConfigEntry("Server-Name")))) {
            serverName = "localhost";
        }
        String portString = context.getARConfigEntry("TCD-Specific-Port");
        int tcpPort = 0;
        if (!StringUtils.isEmpty((String)portString)) {
            try {
                tcpPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ARServerUser connection = new ARServerUser("Remedy Application Service", this.readPassword(context), "", serverName);
        if (tcpPort != 0) {
            connection.setPort(tcpPort);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfReindex(ARPluginContext context) throws ARException {
        ARServerUser arUser = null;
        ServerInfoMap serverInfo = null;
        try {
            arUser = this.createConnection(context);
            try {
                serverInfo = arUser.getServerInfo(new int[]{234});
            }
            catch (ARException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)"Error occurred while connecting to AR server", (Throwable)e);
                }
                LOGGER.warn((Object)"Cannot connect to AR server to see if reindex is in process. Will assume its not and continue");
            }
            Value value = (Value)serverInfo.get((Object)234);
            if (value.getIntValue() == 1) {
                throw new ARException(2, 682, context.getPluginInfo().getName() + " cannot search as reindex is in progress.");
            }
        }
        finally {
            if (arUser != null) {
                arUser.logout();
            }
        }
    }

    private String readPassword(ARPluginContext context) {
        String password = context.getARConfigEntry(REMEDY_APP_SERVICE_PASSWORD_KEY);
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(AR_UTIL_EGCP_CLASS_NAME);
            Object egcpInstance = clazz.newInstance();
            Method methodCalledAsGCEUtilApp = clazz.getMethod(GCE_UTIL_APP_METHOD_NAME, String.class);
            Object result = methodCalledAsGCEUtilApp.invoke(egcpInstance, password);
            if (result != null && result instanceof String) {
                return (String)result;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exception while reading RAS password " + e.getMessage()));
            }
            LOGGER.warn((Object)"Unable to read RAS password");
        }
        return password;
    }

    private synchronized void initOperation(ARPluginContext context, List<Value> pInValues) throws ARException {
        if (pInValues.size() < 7) {
            LOGGER.error((Object)"FTSPlugin initOperation: Not enough input values provided");
            throw new ARException(2, 862, "initOperation: Not enough input values provided");
        }
        String FTCollDir = null;
        Value val = pInValues.get(1);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            FTCollDir = val.toString();
        }
        if (FTCollDir == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Collection Directory not provided");
            throw new ARException(2, 656, "initOperation: Collection Directory not provided");
        }
        String FTConfigDir = null;
        val = pInValues.get(2);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            FTConfigDir = val.toString();
        }
        if (FTConfigDir == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Configuration Directory not provided");
            throw new ARException(2, 656, "initOperation: Configuration Directory not provided");
        }
        int FTCaseSensitivity = 1;
        val = pInValues.get(3);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            FTCaseSensitivity = (Integer)val.getValue();
        }
        String FTStopWordFileName = null;
        val = pInValues.get(4);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            FTStopWordFileName = val.toString();
        }
        if (FTStopWordFileName == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Configuration Directory not provided");
            throw new ARException(2, 656, "initOperation: FTS Stop word filename is not provided");
        }
        int FTOptimizeThreshold = 1000;
        val = pInValues.get(5);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            FTOptimizeThreshold = (Integer)val.getValue();
        }
        if (FTOptimizeThreshold < 10) {
            FTOptimizeThreshold = 10;
        }
        String FTLangCode = null;
        val = pInValues.get(6);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            FTLangCode = val.toString();
        }
        int FTSearchThreshold = -1;
        int FTSearchThresholdCfg = -1;
        if (pInValues.size() >= 8) {
            val = pInValues.get(7);
            if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
                FTSearchThreshold = val.getIntValue();
            }
            if (FTSearchThreshold < 0) {
                String msgDetail = "FTSPlugin initOperation: searchThreshold value is invalid and was ignored/not set.  Value recieved: " + FTSearchThreshold + "   Value must be and integer equal to or greather than (>=) '" + 0 + "'";
                LOGGER.warn((Object)msgDetail);
            }
        } else {
            FTSearchThresholdCfg = 1000000;
            if (context != null) {
                try {
                    FTSearchThresholdCfg = new Integer(context.getConfigItem("ftSearchThreshold"));
                }
                catch (Exception e) {
                    FTSearchThresholdCfg = 10000;
                    context.setConfigItem("ftSearchThreshold", new Integer(FTSearchThresholdCfg).toString());
                }
            }
        }
        boolean isIndexer = true;
        if (pInValues.size() >= 9 && (val = pInValues.get(8)).getDataType() == DataType.INTEGER && val.getValue() != null && val.getIntValue() == 0) {
            isIndexer = false;
        }
        LOGGER.info((Object)("FTSPlugin initOperation: FTCollDir=" + FTCollDir + " FTConfiguration =" + FTConfigDir + " FTCaseSensitivity=" + FTCaseSensitivity + " FTStopWordFileName=" + FTStopWordFileName + " FTOptimizeThreshold=" + FTOptimizeThreshold + " FTLangCode=" + FTLangCode + "FTSearchThreshold=" + FTSearchThreshold + " isIndexer=" + isIndexer));
        FTSPlugin.initializeSearchService(FTCollDir, FTConfigDir, FTCaseSensitivity, FTOptimizeThreshold, FTLangCode, FTSearchThreshold > -1 ? FTSearchThreshold : FTSearchThresholdCfg, deletePolicyTime, getIndexSearcherRetry, isIndexer);
        if (context != null) {
            String strSearchThreshold;
            if (context.getConfigItem("ftCollectionDir") == null || !context.getConfigItem("ftCollectionDir").equals(FTCollDir)) {
                context.setConfigItem("ftCollectionDir", FTCollDir);
            }
            if (context.getConfigItem("ftConfigDir") == null || !context.getConfigItem("ftConfigDir").equals(FTConfigDir)) {
                context.setConfigItem("ftConfigDir", FTConfigDir);
            }
            boolean caseSensitivity = FTCaseSensitivity == 0;
            String strConfigCaseSensitivity = context.getConfigItem("ftCaseSensitivity");
            if (strConfigCaseSensitivity == null || caseSensitivity != Boolean.parseBoolean(strConfigCaseSensitivity)) {
                if (caseSensitivity) {
                    context.setConfigItem("ftCaseSensitivity", "true");
                } else {
                    context.setConfigItem("ftCaseSensitivity", "false");
                }
            }
            if (context.getConfigItem("ftStopFile") == null || !context.getConfigItem("ftStopFile").equals(FTStopWordFileName)) {
                context.setConfigItem("ftStopFile", FTStopWordFileName);
            }
            if (context.getConfigItem("ftOptimizeThreshold") == null || !context.getConfigItem("ftOptimizeThreshold").equals(FTOptimizeThreshold)) {
                context.setConfigItem("ftOptimizeThreshold", new Integer(FTOptimizeThreshold).toString());
            }
            if (context.getConfigItem("ftLangCode") == null || !context.getConfigItem("ftLangCode").equals(FTLangCode)) {
                context.setConfigItem("ftLangCode", FTLangCode);
            }
            if ((strSearchThreshold = context.getConfigItem("ftSearchThreshold")) == null || FTSearchThreshold > -1 && FTSearchThreshold != Integer.parseInt(strSearchThreshold)) {
                context.setConfigItem("ftSearchThreshold", new Integer(FTSearchThreshold).toString());
            }
        }
    }

    private void createUpdateOperation(int opCode, List<Value> pInValues) throws ARException {
        String[] fieldNames = new String[3];
        String[] fieldValues = new String[3];
        BitSet[] fullTextOptions = new BitSet[3];
        float docBoost = 1.0f;
        float[] fieldBoost = new float[3];
        BitSet ftIndexedBitset = new BitSet(2);
        ftIndexedBitset.set(0);
        if (pInValues.size() < 9) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: Not enough input values provided");
            throw new ARException(2, 862, "createUpdateOperation");
        }
        String schemaId = null;
        Value val = pInValues.get(1);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            schemaId = ((Integer)val.getValue()).toString();
        }
        if (schemaId == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: schemaId not provided");
            throw new ARException(2, 872, "schemaId not provided");
        }
        String fieldId = null;
        val = pInValues.get(2);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            fieldId = val.toString();
        }
        if (fieldId == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: fieldId not provided");
            throw new ARException(2, 867, "fieldId not provided");
        }
        String entryId = null;
        val = pInValues.get(3);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            entryId = val.toString();
        }
        if (entryId == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: entryId not provided");
            throw new ARException(2, 656, "entryId not provided");
        }
        String modifiedTime = null;
        val = pInValues.get(4);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            modifiedTime = ((Integer)val.getValue()).toString();
        }
        if (modifiedTime == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: modifiedTime not provided");
            throw new ARException(2, 867, "modifiedTime not provided");
        }
        fieldNames[0] = "modifiedTime";
        fieldValues[0] = modifiedTime;
        fullTextOptions[0] = ftIndexedBitset;
        String createTime = null;
        val = pInValues.get(5);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            createTime = ((Integer)val.getValue()).toString();
        }
        if (createTime == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: createTime not provided");
            throw new ARException(2, 867, "createTime not provided");
        }
        fieldNames[1] = "createTime";
        fieldValues[1] = createTime;
        fullTextOptions[1] = ftIndexedBitset;
        val = pInValues.get(6);
        String fieldValue = this.readFieldValue(val);
        if (fieldValue == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: fieldValue not provided");
            throw new ARException(2, 867, "fieldValue not provided");
        }
        fieldNames[2] = fieldId;
        fieldValues[2] = fieldValue;
        int ftOption = 1;
        val = pInValues.get(7);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            ftOption = (Integer)val.getValue();
        }
        BitSet ftIndexedBitsetfield = new BitSet(2);
        ftIndexedBitsetfield.set(0, ftOption == 1);
        ftIndexedBitsetfield.set(1, ftOption == 2);
        fullTextOptions[2] = ftIndexedBitsetfield;
        if (pInValues.size() >= 10) {
            String msgDetail;
            val = pInValues.get(9);
            if (val.getDataType() == DataType.REAL && val.getValue() != null) {
                docBoost = (float)val.getDoubleValue();
            }
            if (docBoost < -2000.0f) {
                msgDetail = "FTSPlugin createUpdateOperation: docBoost value supplied is less than the minimum allowed value.  The minimum value will be used.  Supplied Value='" + docBoost + "'  Minimum value='" + -2000.0f + "'";
                LOGGER.warn((Object)msgDetail);
                docBoost = -2000.0f;
            } else if (docBoost > 2000.0f) {
                msgDetail = "FTSPlugin createUpdateOperation: docBoost value supplied exceeds the maximum value.  The maximum value will be used.  Supplied Value='" + docBoost + "'  Maximum value='" + 2000.0f + "'";
                LOGGER.warn((Object)msgDetail);
                docBoost = 2000.0f;
            }
        }
        for (int i = 0; i < 3; ++i) {
            fieldBoost[i] = 1.0f;
        }
        if (pInValues.size() >= 11) {
            val = pInValues.get(10);
            if (val.getDataType() == DataType.REAL && val.getValue() != null) {
                fieldBoost[2] = (float)val.getDoubleValue();
            }
            if (fieldBoost[2] < -2000.0f || fieldBoost[2] > 2000.0f) {
                String msgDetail = "FTSPlugin createUpdateOperation: fieldBoost value is invalid as was ignored/not set.  -2000.0 <= fieldBoost <= 2000.0, 1.0=default/noBoost, value supplied=" + fieldBoost[0];
                LOGGER.warn((Object)msgDetail);
                fieldBoost[2] = 1.0f;
            }
        }
        int commitFlag = 0;
        val = pInValues.get(8);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            commitFlag = (Integer)val.getValue();
        }
        LOGGER.info((Object)("FTSPlugin createUpdateOperation: opCode=" + opCode + " schemaId=" + schemaId + " entryId=" + entryId + " fieldId=" + fieldId + " ftoption=" + ftOption + " commitFlag=" + commitFlag + " fieldBoost=" + fieldBoost[2] + " docBoost=" + docBoost));
        if (opCode == 2) {
            this.deleteFieldFromDocument(fieldId, schemaId, entryId);
        }
        try {
            m_service.indexEntryFields(schemaId, entryId, docBoost, fieldNames, fieldValues, fullTextOptions, fieldBoost, commitFlag);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::createUpdateOperation - Error " + (opCode == 2 ? "updating" : "creating") + " the document index.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse) + " Plugin details: opCode=" + opCode + " schemaId=" + schemaId + " entryId=" + entryId + " fieldId=" + fieldId + " ftoption=" + ftOption + " commitFlag=" + commitFlag;
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::createUpdateOperation - Document index failure while " + (opCode == 2 ? "updating" : "creating") + " the index entry.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
    }

    private void deleteOperation(List<Value> pInValues) throws ARException {
        Value val;
        Value val2;
        Value val3;
        Value val4;
        if (pInValues.size() < 1 || pInValues.size() > 5) {
            LOGGER.error((Object)"FTSPlugin deleteOperation: Not enough input values provided");
            throw new ARException(2, 862, "deleteOperation");
        }
        int schemaId = 0;
        if (pInValues.size() > 1 && (val4 = pInValues.get(1)).getDataType() == DataType.INTEGER && val4.getValue() != null) {
            schemaId = (Integer)val4.getValue();
        }
        String fieldId = null;
        if (pInValues.size() > 2 && (val3 = pInValues.get(2)).getDataType() == DataType.CHAR && val3.getValue() != null) {
            fieldId = val3.toString();
        }
        String entryId = null;
        if (pInValues.size() > 3 && (val2 = pInValues.get(3)).getDataType() == DataType.CHAR && val2.getValue() != null) {
            entryId = val2.toString();
        }
        int commitFlag = 1;
        if (pInValues.size() > 4 && (val = pInValues.get(4)).getDataType() == DataType.INTEGER && val.getValue() != null) {
            commitFlag = (Integer)val.getValue();
        }
        LOGGER.info((Object)("FTSPlugin deleteOperation:  schemaId=" + schemaId + " entryId=" + entryId + " fieldId=" + fieldId + " commitFlag=" + commitFlag));
        try {
            if (schemaId == 0) {
                m_service.deleteIndexDir();
            } else {
                String schemaIdStr = Integer.valueOf(schemaId).toString();
                if (fieldId == null || fieldId.length() == 0) {
                    if (entryId == null || entryId.length() == 0) {
                        m_service.deleteDocuments(schemaIdStr, true);
                        m_service.commitNow(schemaIdStr);
                    } else {
                        m_service.deleteEntryDocument(schemaIdStr, entryId);
                        m_service.commitNow("" + schemaId);
                    }
                } else {
                    this.deleteFieldFromDocument(fieldId, schemaIdStr, entryId, commitFlag);
                }
            }
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::deleteOperation - Error while modifying and/or deleting the index item(s) for the document. schemaId=" + schemaId + " entryId=" + entryId + " fieldId=" + fieldId + "  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::deleteOperation - Index data modification/deletion error.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
    }

    private List<Value> getOperation(List<Value> pInValues) throws ARException {
        if (pInValues.size() != 6) {
            LOGGER.error((Object)"FTSPlugin getOperation: Not enough input values provided");
            throw new ARException(2, 862, "getOperation");
        }
        int schemaId = 0;
        Value val = pInValues.get(1);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            schemaId = (Integer)val.getValue();
        }
        if (schemaId == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: schemaId not provided");
            throw new ARException(2, 872, "getOperation: schemaId not provided");
        }
        String fieldId = null;
        val = pInValues.get(2);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            fieldId = val.toString();
        }
        if (fieldId == null || fieldId.length() == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: fieldId not provided");
            throw new ARException(2, 867, "getOperation: fieldId not provided");
        }
        String query = null;
        val = pInValues.get(3);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            query = val.toString();
        }
        if (query == null || query.length() == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: Search query not provided");
            throw new ARException(2, 872, "getOperation: Search query not provided");
        }
        int ftOption = 1;
        val = pInValues.get(4);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            ftOption = (Integer)val.getValue();
        }
        BitSet[] fullTextOptions = new BitSet[]{new BitSet(2)};
        fullTextOptions[0].set(0, ftOption == 1);
        fullTextOptions[0].set(1, ftOption == 2);
        int maxReturn = 0;
        val = pInValues.get(5);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            maxReturn = (Integer)val.getValue();
        }
        LOGGER.info((Object)("FTSPlugin getOperation:  schemaId=" + schemaId + " fieldId=" + fieldId + " ftoption=" + ftOption));
        String[] queryFieldNames = new String[]{fieldId};
        String[] queryFieldValues = new String[]{query};
        List<FTSService.EntryData> returnValues = null;
        try {
            returnValues = m_service.getEntryIdsByQuery(Integer.valueOf(schemaId).toString(), queryFieldNames, queryFieldValues, fullTextOptions, maxReturn);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::getOperation - Error during index query.  SchemaId='" + schemaId + " fieldId=" + fieldId + " ftoption=" + ftOption + "'. " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::getOperation - Error while querying the index.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
        return this.buildGetFTSResponse(returnValues);
    }

    private void closeOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin closeOperation");
        if (m_service != null) {
            try {
                m_service.close();
                m_service = null;
            }
            catch (FTSServiceException ftsse) {
                String errLogDetail = "FTSPlugin::closeOperation - Error closing the index.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
                LOGGER.error((Object)errLogDetail);
                String errMessage = "FTSPlugin::closeOperation - Error while closing the index.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
                throw new ARException(2, 875, errMessage);
            }
        }
    }

    private void commitOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin commitOperation");
        if (m_service != null) {
            try {
                m_service.commitAll();
            }
            catch (FTSServiceException ftsse) {
                String errLogDetail = "FTSPlugin::commitOperation - Error while committing data inserted into the index.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
                LOGGER.error((Object)errLogDetail);
                String errMessage = "FTSPlugin::commitOperation - Error performing index commit.  " + ftsse.getLocalizedMessage();
                throw new ARException(2, 875, errMessage);
            }
        }
    }

    private synchronized void updateConfigOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin updateConfigOperation");
        if (m_service != null) {
            try {
                m_service.updateConfiguration();
            }
            catch (FTSServiceException ftsse) {
                String errLogDetail = "FTSPlugin::updateConfigOperation - Error updating the configuration for FTS.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
                LOGGER.error((Object)errLogDetail);
                String errMessage = "FTSPlugin::updateConfigOperation - Error updating FTS config.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
                throw new ARException(2, 875, errMessage);
            }
        }
    }

    private List<Value> buildGetFTSResponse(List<FTSService.EntryData> entryDataList) {
        if (entryDataList == null || entryDataList.size() == 0) {
            return null;
        }
        ArrayList<Value> valueList = new ArrayList<Value>(entryDataList.size() * 2);
        for (FTSService.EntryData entryData : entryDataList) {
            valueList.add(new Value(entryData.entryId));
            valueList.add(new Value((double)entryData.score));
        }
        return valueList;
    }

    private List<Value> buildMultiGetFTSResponse(FTSService.FTSResultSet ftsResultSet) {
        if (ftsResultSet == null) {
            return null;
        }
        List<FTSService.EntryData> entryDataList = ftsResultSet.resultList;
        String delimStr = new String(new Character('\u0001').toString());
        ArrayList<Value> valueList = new ArrayList<Value>(entryDataList.size());
        StringBuffer outputStr = new StringBuffer();
        valueList.add(new Value(ftsResultSet.numMatches));
        if (entryDataList != null && entryDataList.size() > 0) {
            for (FTSService.EntryData entryData : entryDataList) {
                boolean isGlobalEntryData = entryData instanceof FTSService.GlobalEntryData;
                String createDate = isGlobalEntryData ? ((FTSService.GlobalEntryData)entryData).createDate : "";
                String modifiedDate = isGlobalEntryData ? ((FTSService.GlobalEntryData)entryData).modifiedDate : "";
                String title = isGlobalEntryData ? ((FTSService.GlobalEntryData)entryData).title : "";
                String excerpt = isGlobalEntryData ? ((FTSService.GlobalEntryData)entryData).excerpt : "";
                outputStr.delete(0, outputStr.length());
                outputStr.append(entryData.schemaId).append(";");
                outputStr.append(entryData.entryId).append(";");
                outputStr.append(entryData.score).append(";");
                outputStr.append(createDate).append(";");
                outputStr.append(modifiedDate).append(";");
                outputStr.append(delimStr + title + delimStr).append(";");
                outputStr.append(delimStr + excerpt + delimStr).append(";");
                StringBuffer returnFieldsBuf = new StringBuffer();
                if (isGlobalEntryData && ((FTSService.GlobalEntryData)entryData).returnFilterFields != null) {
                    returnFieldsBuf.append(((FTSService.GlobalEntryData)entryData).returnFilterFields.size()).append(";");
                    for (FTSService.ReturnFilterFields rff : ((FTSService.GlobalEntryData)entryData).returnFilterFields) {
                        returnFieldsBuf.append(delimStr).append(rff.filterField).append(delimStr).append(";").append(delimStr).append(rff.value != null ? rff.value : "").append(delimStr).append(";");
                    }
                } else {
                    returnFieldsBuf.append("0").append(";");
                }
                outputStr.append(returnFieldsBuf);
                valueList.add(new Value(outputStr.toString()));
            }
        }
        return valueList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFieldValue(Value val) throws ARException {
        String fieldValue;
        block20: {
            fieldValue = null;
            try {
                if (val == null || val.getValue() == null) break block20;
                InputStream is = null;
                DataType datatype = val.getDataType();
                if (datatype == DataType.CHAR) {
                    fieldValue = val.toString();
                    break block20;
                }
                if (datatype == DataType.ATTACHMENT) {
                    AttachmentValue attachVal = (AttachmentValue)val.getValue();
                    if (attachVal.getLocationType() == 1) {
                        File file = new File(attachVal.getValueFileName());
                        if (file == null) {
                            LOGGER.error((Object)"FTSPlugin readFieldValue: attachment fieldValue has bad location type");
                            throw new ARException(2, 658, "attachment filename is null");
                        }
                        try {
                            is = new FileInputStream(file);
                        }
                        catch (FileNotFoundException e) {
                            throw new ARException(2, 658, "attachment file not found: " + file.getAbsolutePath());
                        }
                    } else if (attachVal.getLocationType() == 2) {
                        is = new ByteArrayInputStream(attachVal.getContent());
                    } else {
                        LOGGER.error((Object)"FTSPlugin readFieldValue: attachment fieldValue has bad location type");
                        throw new ARException(2, 658, "attachment fieldValue");
                    }
                    fieldValue = m_docHandler.getText(is);
                    if (fieldValue != null) {
                        String attachmentMeta = " " + this.cleanAttachMetadata(attachVal.getName()) + " " + this.cleanAttachMetadata(attachVal.getValueFileName());
                        if (fieldValue.trim().length() == 0) {
                            LOGGER.warn((Object)"FTSPlugin readFieldValue: No indexable data was extracted from the document.  This may be normal if the document is binary in nature, or it may indicate that the document is either an unsupported type or corrupt.");
                            fieldValue = attachmentMeta;
                        } else {
                            fieldValue = fieldValue + attachmentMeta;
                        }
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {
                        break block20;
                    }
                    finally {
                        is = null;
                    }
                }
                LOGGER.error((Object)("FTSPlugin readFieldValue: Unsupported field value data type. Received datatype = " + datatype));
                throw new ARException(2, 663, "Unsupported field value data type. Received datatype = " + datatype);
            }
            catch (DocumentHandlerException e) {
                LOGGER.error((Object)e.getStackTrace());
                throw new ARException(2, 658, "attachment fieldValue" + e.getMessage());
            }
        }
        return fieldValue;
    }

    public String cleanAttachMetadata(String metaIn) {
        String cleanedMeta = "";
        if (metaIn != null) {
            cleanedMeta = new File(metaIn).getName();
        }
        return cleanedMeta;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readAttachFieldContent(Value val) throws ARException {
        void var2_6;
        Object var2_2 = null;
        if (val == null) return var2_6;
        if (val.getValue() == null) return var2_6;
        DataType datatype = val.getDataType();
        if (datatype != DataType.ATTACHMENT) {
            LOGGER.error((Object)("FTSPlugin readAttachFieldContent: Unsupported field value data type. Received datatype = " + datatype));
            throw new ARException(2, 663, "Unsupported field value data type. Received datatype = " + datatype);
        }
        AttachmentValue attachVal = (AttachmentValue)val.getValue();
        if (attachVal.getLocationType() == 1) {
            File file = new File(attachVal.getValueFileName());
            if (file == null) {
                LOGGER.error((Object)"FTSPlugin readAttachFieldContent: attachment fieldValue has bad location type");
                throw new ARException(2, 658, "attachment filename is null");
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                return var2_6;
            }
            catch (FileNotFoundException e) {
                throw new ARException(2, 658, "attachment file not found: " + file.getAbsolutePath());
            }
        }
        if (attachVal.getLocationType() == 2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attachVal.getContent());
            return var2_6;
        }
        LOGGER.error((Object)"FTSPlugin readAttachFieldContent: attachment fieldValue has bad location type");
        throw new ARException(2, 658, "attachment fieldValue");
    }

    private void deleteFieldFromDocument(String fieldId, String schemaId, String entryId, int commitFlag) throws ARException {
        String[] stringArray = new String[2];
        stringArray[0] = "schemaId";
        stringArray[1] = null;
        String[] queryFieldNames = stringArray;
        String[] queryFieldValues = new String[]{schemaId, null};
        if (entryId != null && entryId.length() != 0) {
            queryFieldNames[1] = "entryId";
            queryFieldValues[1] = entryId;
        }
        try {
            m_service.removeFieldFromDocumentsByQuery(schemaId, fieldId, queryFieldNames, queryFieldValues, commitFlag);
            m_service.commitNow(schemaId);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::deleteFieldFromDocument - Error while deleting a field from the documents index entry.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::deleteFieldFromDocument - Error modifying index entry.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
    }

    private void deleteFieldFromDocument(String fieldId, String schemaId, String entryId) throws ARException {
        String[] stringArray = new String[2];
        stringArray[0] = "schemaId";
        stringArray[1] = null;
        String[] queryFieldNames = stringArray;
        String[] queryFieldValues = new String[]{schemaId, null};
        if (entryId != null && entryId.length() != 0) {
            queryFieldNames[1] = "entryId";
            queryFieldValues[1] = entryId;
        }
        try {
            m_service.removeFieldFromDocumentsByQuery(schemaId, fieldId, queryFieldNames, queryFieldValues);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::deleteFieldFromDocument - Error while deleting a field from the documents index entry.  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::deleteFieldFromDocument - Error deleting index data.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
    }

    private static void initializeSearchService(String collectionDir, String configDir, int caseSensitivity, int optimizeThreshold, String langCode, int searchThreshold, int deletePolicyTime, String getIndexSearcherRetry, boolean isIndexer) throws ARException {
        FTSConfiguration ftConfig = new FTSConfiguration();
        ftConfig.setFullTextCollectionDir(collectionDir);
        if (!FTSPlugin.getDirectoryExists(collectionDir)) {
            LOGGER.error((Object)("FTS: The specified FTS Collection directory could not be found during Initialization.  It may be inaccessible or non-existent. path='" + collectionDir + "'"));
        }
        ftConfig.setFullTextConfigurationDir(configDir);
        if (!FTSPlugin.getDirectoryExists(configDir)) {
            LOGGER.error((Object)("FTS: The specified FTS Configuration directory could not be found during Initialization.  It may be inaccessible or non-existent. path='" + configDir + "'"));
        }
        ftConfig.setFullTextCaseInSensitive(caseSensitivity == 0);
        ftConfig.setFullTextOptimizeThreshold(optimizeThreshold);
        ftConfig.setFullTextLocale(langCode);
        ftConfig.setSearchThreshold(searchThreshold);
        ftConfig.setDeletePolicyTime(deletePolicyTime);
        ftConfig.setGetIndexSearcherRetry(getIndexSearcherRetry);
        try {
            m_service.init(ftConfig, isIndexer);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::initializeSearchService - Error initializing the FTSService:" + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = errLogDetail;
            throw new ARException(2, 875, errMessage);
        }
    }

    private static boolean getDirectoryExists(String directoryName) {
        File theDir = null;
        boolean dirExists = false;
        if (directoryName != null && directoryName.length() > 0) {
            theDir = new File(directoryName);
            dirExists = theDir.exists();
        }
        return dirExists;
    }

    private Map<String, String> buildReturnEntries(String returnEntriesString) {
        String[] entries;
        if (returnEntriesString == null || returnEntriesString.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : entries = returnEntriesString.split(String.valueOf("##"))) {
            String schemaId = null;
            int docIdIndex = entry.indexOf("#");
            if (docIdIndex > 0) {
                schemaId = entry.substring(0, docIdIndex);
            }
            entry = entry.substring(docIdIndex + String.valueOf("#").length());
            entry = entry + ";";
            if (schemaId == null) continue;
            result.put(schemaId, entry);
        }
        return result;
    }

    private List<Value> multiGetOperation(List<Value> pInValues) throws ARException {
        if (pInValues.size() < 14) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Not enough input values provided");
            throw new ARException(2, 862, "multiGetOperation");
        }
        ArrayList<FTSService.QuerySchemas> querySchemas = new ArrayList<FTSService.QuerySchemas>();
        this.populateQuerySchemas(pInValues, querySchemas);
        String mustQuery = null;
        Value val = pInValues.get(4);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            mustQuery = val.toString();
        }
        String shouldQuery = null;
        val = pInValues.get(5);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            shouldQuery = val.toString();
        }
        String notQuery = null;
        val = pInValues.get(6);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            notQuery = val.toString();
        }
        if (mustQuery == null && shouldQuery == null && notQuery == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Search query not provided");
            throw new ARException(2, 872, "multiGetOperation: Search query not provided");
        }
        String filterQuery = null;
        val = pInValues.get(7);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            filterQuery = val.toString();
        }
        int excerptOption = 0;
        val = pInValues.get(8);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            excerptOption = (Integer)val.getValue();
        }
        String sortOrder = null;
        val = pInValues.get(9);
        if (val.getDataType() == DataType.CHAR && (sortOrder = val.toString()) != null && sortOrder.trim().length() == 0) {
            sortOrder = null;
        }
        ArrayList<FTSService.ReturnFilterFields> returnFilterFields = null;
        String filterNames = null;
        String filterFieldslogMsg = "  No returnFields information/names provided.";
        val = pInValues.get(10);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            filterNames = val.toString();
        }
        returnFilterFields = new ArrayList<FTSService.ReturnFilterFields>();
        this.populateFilterFields(filterNames, returnFilterFields);
        if (returnFilterFields.size() > 0) {
            filterFieldslogMsg = "  Requested Filter Fields: ";
            for (FTSService.ReturnFilterFields rff : returnFilterFields) {
                filterFieldslogMsg = filterFieldslogMsg + " '" + rff.filterField + "' ";
            }
        }
        int resultMax = 0;
        val = pInValues.get(11);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            resultMax = (Integer)val.getValue();
        }
        String returnEntriesString = null;
        val = pInValues.get(12);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null && val.toString().length() != 0) {
            returnEntriesString = val.toString();
        }
        Map<String, String> returnEntries = this.buildReturnEntries(returnEntriesString);
        LOGGER.info((Object)("FTSPlugin multiGetOperation: mustQuery=" + mustQuery + " shouldQuery=" + shouldQuery + " notQuery=" + notQuery + " filterQuery=" + filterQuery + " excerptOption=" + excerptOption + " sortOrder='" + sortOrder + "resultMax='" + resultMax + "returnEntries='" + returnEntries + "'  msg=" + filterFieldslogMsg));
        FTSService.FTSResultSet ftsResultSet = null;
        try {
            ftsResultSet = m_service.getEntryIdsByGlobalQuery(shouldQuery, mustQuery, notQuery, querySchemas, filterQuery, returnFilterFields, sortOrder, excerptOption, returnEntries, resultMax);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::multiGetOperation - Error during multi-get operation for FTS.  mustQuery='" + mustQuery + "' shouldQuery='" + shouldQuery + "' notQuery='" + notQuery + "' filterQuery='" + filterQuery + "' excerptOption='" + excerptOption + "' sortOrder='" + sortOrder + "' resultMax='" + resultMax + "' returnEntries='" + returnEntries + "' filterFields=" + filterFieldslogMsg + "'  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::multiGetOperation - " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
        return this.buildMultiGetFTSResponse(ftsResultSet);
    }

    void populateFilterFields(String filterNames, List<FTSService.ReturnFilterFields> returnFilterFields) {
        if (returnFilterFields != null && filterNames != null && filterNames.length() > 0) {
            String[] filterNameArray;
            returnFilterFields.clear();
            for (String filterName : filterNameArray = filterNames.split(";")) {
                returnFilterFields.add(new FTSService.ReturnFilterFields(filterName));
            }
        } else {
            LOGGER.info((Object)"FTSPlugin multiGetOperation->populateFilterFields: The returnFields value is invalid.");
        }
    }

    void populateQuerySchemas(List<Value> inputArgs, List<FTSService.QuerySchemas> querySchemas) throws ARException {
        String schemaListStr = null;
        Value val = inputArgs.get(1);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            schemaListStr = (String)val.getValue();
        }
        if (schemaListStr == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Schema List not provided");
            throw new ARException(2, 872, "multiGetOperation: Schema List is not provided");
        }
        String fieldIdListStr = null;
        val = inputArgs.get(2);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            fieldIdListStr = (String)val.getValue();
        }
        if (fieldIdListStr == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Field Lists for schemas not provided");
            throw new ARException(2, 867, "multiGetOperation: Field Lists for schemas not provided");
        }
        String ftOptionListStr = null;
        val = inputArgs.get(3);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            ftOptionListStr = (String)val.getValue();
        }
        if (ftOptionListStr == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: FT option list for fields not provided");
            throw new ARException(2, 867, "multiGetOperation: FT option list for fields not provided");
        }
        String weightedRelevancyFieldsStr = null;
        val = inputArgs.get(13);
        if (val != null && val.getDataType() == DataType.CHAR && val.getValue() != null) {
            weightedRelevancyFieldsStr = (String)val.getValue();
        }
        String[] schemaIDs = schemaListStr.split(";");
        String[] listOfFieldIDs = fieldIdListStr.split("#");
        String[] listOfFTOptions = ftOptionListStr.split("#");
        String[] listOfWeightedRelevancyFields = null;
        if (weightedRelevancyFieldsStr != null && (listOfWeightedRelevancyFields = weightedRelevancyFieldsStr.split("#")).length != schemaIDs.length) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Weighted relevancy field Lists for schemas not provided in correct format");
            throw new ARException(2, 867, "multiGetOperation: Weighted relevancy field List for schemas not provided in correct format");
        }
        if (listOfFieldIDs.length != schemaIDs.length) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Field Lists for schemas not provided in correct format");
            throw new ARException(2, 867, "multiGetOperation: Field Lists for schemas not provided in correct format");
        }
        if (listOfFTOptions.length != schemaIDs.length) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: FT Option Lists for schemas not provided in correct format");
            throw new ARException(2, 867, "multiGetOperation: FT Option Lists for schemas not provided in correct format");
        }
        this.populateQuerySchemasList(querySchemas, schemaIDs, listOfFieldIDs, listOfFTOptions, listOfWeightedRelevancyFields);
    }

    private void populateQuerySchemasList(List<FTSService.QuerySchemas> querySchemas, String[] schemaIDs, String[] listOfFieldIDs, String[] listOfFTOptions, String[] weightedRelevancyFields) {
        for (int i = 0; i < schemaIDs.length; ++i) {
            FTSService.QuerySchemas querySchema = new FTSService.QuerySchemas(schemaIDs[i], new ArrayList<String>(), new ArrayList<BitSet>(), new ArrayList<String>());
            String fieldList = listOfFieldIDs[i];
            String[] fieldIDs = fieldList.split(";");
            for (int j = 0; j < fieldIDs.length; ++j) {
                querySchema.queryFieldNames.add(fieldIDs[j]);
            }
            String ftOptionList = listOfFTOptions[i];
            String[] ftOptions = ftOptionList.split(";");
            for (int k = 0; k < ftOptions.length; ++k) {
                int ftOptionVal = new Integer(ftOptions[k]);
                BitSet[] fullTextOptions = new BitSet[]{new BitSet(2)};
                fullTextOptions[0].set(0, ftOptionVal == 1);
                fullTextOptions[0].set(1, ftOptionVal == 2);
                querySchema.fullTextOptions.add(fullTextOptions[0]);
            }
            String weightedFields = weightedRelevancyFields[i];
            if (weightedFields != null && !weightedFields.isEmpty() && (fieldIDs = weightedFields.split(";")) != null) {
                for (int j = 0; j < fieldIDs.length; ++j) {
                    if (fieldIDs[j] == null || fieldIDs[j].isEmpty()) continue;
                    querySchema.weightedRelevancyFields.add(fieldIDs[j]);
                }
            }
            querySchemas.add(querySchema);
        }
    }

    public void setDocBoost(List<Value> pInValues) throws ARException {
        String strMsg = null;
        float docBoost = 1.0f;
        if (m_service == null) {
            String errorMsgDetail = "FTSPlugin setDocBoost: SearchService is invalid";
            LOGGER.error((Object)errorMsgDetail);
            throw new ARException(2, 657, errorMsgDetail);
        }
        if (pInValues.size() != 4) {
            LOGGER.error((Object)"FTSPlugin setDocBoost: Not enough input values provided.  The operation could not be completed");
            throw new ARException(2, 862, "setDocBoost");
        }
        String schemaId = null;
        Value val = pInValues.get(1);
        if (val.getDataType() == DataType.INTEGER && val.getValue() != null) {
            schemaId = ((Integer)val.getValue()).toString();
        }
        if (schemaId == null || schemaId.length() == 0) {
            strMsg = "setDocBoost: SchemaID was not provided and is required for this operation.";
            LOGGER.error((Object)"FTSPlugin setDocBoost: SchemaID was not provided");
            throw new ARException(2, 872, strMsg);
        }
        String entryId = null;
        val = pInValues.get(2);
        if (val.getDataType() == DataType.CHAR && val.getValue() != null) {
            entryId = (String)val.getValue();
        }
        if (entryId == null || entryId.length() == 0) {
            LOGGER.info((Object)"FTSPlugin setDocBoost: EntryID was not provided, it is a bulk operation");
        }
        if ((val = pInValues.get(3)).getDataType() == DataType.REAL && val.getValue() != null) {
            docBoost = (float)val.getDoubleValue();
        } else if (val.getDataType() != DataType.REAL) {
            LOGGER.warn((Object)"FTSPlugin setDocBoost: The value for docBoost provided was not of type REAL (class DataType)");
        } else {
            LOGGER.warn((Object)("FTSPlugin setDocBoost: The document boost value (docBoost) is null.  The default of 1 will be used. SchemaID=" + schemaId + "  EntryID=" + entryId));
        }
        LOGGER.info((Object)("FTSPlugin setDocBoost: schemaId=" + schemaId + " entryId=" + entryId + " docBoost=" + docBoost));
        if (docBoost < -2000.0f) {
            docBoost = -2000.0f;
        } else if (docBoost > 2000.0f) {
            docBoost = 2000.0f;
        }
        try {
            m_service.setDocBoost(schemaId, entryId, docBoost);
        }
        catch (FTSServiceException ftsse) {
            String errLogDetail = "FTSPlugin::setDocBoost - Error setting the boost value for the document. SchemaId='" + schemaId + "'  EntryId='" + entryId + "'  Document boost value='" + docBoost + ".  Message from FTSService: " + ftsse.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(ftsse);
            LOGGER.error((Object)errLogDetail);
            String errMessage = "FTSPlugin::setDocBoost - Error setting document index boost value.  " + ftsse.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, errMessage);
        }
    }

    private static String getFTSSEPassedExceptionInfo(FTSServiceException ftsse) {
        String rootCause = "";
        if (ftsse.getCause() != null) {
            rootCause = " Root Exception: " + ftsse.getCause().getLocalizedMessage();
        }
        return rootCause;
    }
}

