/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.customssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class LDAPSSLSocketFactoryBase
extends SSLSocketFactory {
    private SSLSocketFactory sslSocketFactory;

    public LDAPSSLSocketFactoryBase(String keyStorePath, String storePass) throws Exception {
        this.sslSocketFactory = LDAPSSLSocketFactoryBase.getSSLSocketFactory(keyStorePath, storePass);
    }

    private static SSLSocketFactory getSSLSocketFactory(String keyStorePath, String storePass) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = null;
        if (storePass != null) {
            password = storePass.toCharArray();
        }
        FileInputStream fis = new FileInputStream(keyStorePath);
        ks.load(fis, password);
        fis.close();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        SSLContext sslCtx = SSLContext.getInstance("TLSv1.2");
        sslCtx.init(null, tmf.getTrustManagers(), new SecureRandom());
        return sslCtx.getSocketFactory();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        this.sslSocketFactory.createSocket(s, host, port, autoClose);
        return this.removeSSL(this.sslSocketFactory.createSocket(s, host, port, autoClose));
    }

    private Socket removeSSL(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            String[] protocols = sslSocket.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.contains("SSL")) continue;
                set.add(protocol);
            }
            sslSocket.setEnabledProtocols(set.toArray(new String[0]));
        }
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.removeSSL(this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        return this.removeSSL(this.sslSocketFactory.createSocket(addr, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int lport) throws IOException, UnknownHostException {
        return this.removeSSL(this.sslSocketFactory.createSocket(addr, port, addr, lport));
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress laddr, int lport) throws IOException {
        return this.removeSSL(this.sslSocketFactory.createSocket(addr, port, laddr, lport));
    }
}

