/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.CheckStatus;
import com.bmc.arsys.plugins.configchecker.ConfigCheckerFilterPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ConfigCheckerLogForm
implements CheckResultNotifier {
    private static Logger logger = Logger.getLogger(ConfigCheckerFilterPlugin.class);
    private static String CHECKER_LOG_FORM = "ConfigCheckerLog";
    private static int CONFIG_CHECK_LOG_MESSAGE_TYPE = 46007;
    private static int CONFIG_CHECK_LOG_CURRENT_STATUS = 46008;
    private static int CONFIG_CHECK_LOG_PRODUCT = 46009;
    private static int CONFIG_CHECK_LOG_PRE_CHECKNAME = 46010;
    private static int CONFIG_CHECK_LOG_MSG = 46011;
    private static int CONFIG_CHECK_LOG_HINT = 46012;
    private boolean isSuccess = true;
    private ARServerUser user = null;

    ConfigCheckerLogForm(ARServerUser user) {
        this.user = user;
    }

    public boolean allCheckPassed() {
        return this.isSuccess;
    }

    @Override
    public boolean addResult(CheckStatus result) {
        try {
            Entry entry = new Entry();
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_MESSAGE_TYPE), new Value(result.getMessageType().toString(), DataType.CHAR));
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_CURRENT_STATUS), new Value(result.getStatus(), DataType.CHAR));
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_PRODUCT), new Value(result.getProduct().toString(), DataType.CHAR));
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_PRE_CHECKNAME), new Value(result.getPreCheckName(), DataType.CHAR));
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_MSG), new Value(result.getLogMessage(), DataType.CHAR));
            entry.put(Integer.valueOf(CONFIG_CHECK_LOG_HINT), new Value(result.getHint(), DataType.CHAR));
            this.user.createEntry(CHECKER_LOG_FORM, entry);
            if (result.getMessageType() == CheckStatus.MessageType.ERROR || result.getMessageType() == CheckStatus.MessageType.WARNING) {
                this.isSuccess = false;
            }
        }
        catch (ARException e) {
            logger.debug((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void purgeOldEntries() throws ARException {
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(1));
        RelationalOperationInfo relOp = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo defaultQualifier = new QualifierInfo(relOp);
        SortInfo sortInfo = new SortInfo(1, 1);
        ArrayList<SortInfo> sortList = new ArrayList<SortInfo>(1);
        sortList.add(sortInfo);
        int[] fieldIds = new int[]{1};
        List entryList = this.user.getListEntryObjects(CHECKER_LOG_FORM, defaultQualifier, 0, 0, sortList, fieldIds, false, null);
        if (entryList != null) {
            for (Entry entry : entryList) {
                Value val = (Value)entry.get((Object)1);
                String entryId = val.toString();
                this.user.deleteEntry(CHECKER_LOG_FORM, entryId, 0);
            }
        }
    }
}

