/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.plugins.arealdap.LDAPConstants;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.util.ARUtilEgcp;
import com.bmc.arsys.util.ArrayCentralConfig;
import com.bmc.arsys.util.CentralConfigFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public class LDAPProps
implements LDAPConstants {
    private final String AREA_CONFIG_COMPONENT_TYPE = "com.bmc.arsys.ldap.area";
    private static final String SERVER_CONNECT_NAME = "Server-Connect-Name";
    private static final String SERVER_NAME = "Server-Name";
    private static final String TCD_SPECIFIC_PORT = "TCD-Specific-Port";
    private static final String REMEDY_APP_SERVICE_PASSWORD = "Remedy-App-Service-Password";
    private static final String CONFIGURATION_NAME = "Configuration-Name";
    private final int LDAP_DFLT_PLAIN_PORT = 389;
    private final int LDAP_DFLT_SLL_PORT = 636;
    private String authHost;
    private int authPort;
    private String bindUser;
    private String bindPasswd;
    private String URL;
    private int timeout = 40;
    private String userBase;
    private String userFilter;
    private String chaseReferral;
    private boolean useSSL = false;
    private String keyStorePath;
    private String emailAttribName;
    private String defaultEmail;
    private int useGroups;
    private String rolesAttribName;
    private String defaultRoles;
    private String notifyMechAttribName;
    private int defaultNotifyMech;
    private String licenseMaskAttribName;
    private int defaultLicenseMask;
    private String licenseTypeAttribName;
    private int defaultLicenseType;
    private int defaultReservedLicense;
    private String licenseFTSAttribName;
    private String licenseRes1AttribName;
    private String licenseAppAttribName;
    private String defaultLicenseApp;
    private String groupBase;
    private String groupFilter;
    private String defaultGroups;
    Map<String, List<String>> configSettingMap;

    public boolean init(ARPluginContext pluginContext, int i) throws AREncryptionException, ARException {
        String resLicense;
        String host;
        ARServerUser context = this.getARServerUser(pluginContext);
        ArrayCentralConfig centralConigObj = CentralConfigFactory.newInstance((ARServerUser)context).newArrayCentralConfig();
        try {
            this.configSettingMap = centralConigObj.getConfigSettingsAsMap(this.getComponentName(pluginContext), "com.bmc.arsys.ldap.area", null);
        }
        catch (Exception e) {
            pluginContext.logMessage(pluginContext.getPluginInfo(), 2, "Failed to retrieve config setting map for AREA Ldap");
            throw e;
        }
        String index = "";
        if (i != 0) {
            index = "_" + i;
        }
        if ((host = this.getLDAPProp("AREA-LDAP-Hostname" + index)) == null) {
            return false;
        }
        if (host.contains(":") && !host.startsWith("[")) {
            host = "[" + host + "]";
        }
        this.setAuthHost(host);
        this.setUseSSL(this.getLDAPProp("AREA-LDAP-UseSSL" + index));
        try {
            this.setAuthPort(Integer.parseInt(this.getLDAPProp("AREA-LDAP-Port" + index)));
        }
        catch (Exception e) {
            if (this.useSSL()) {
                this.setAuthPort(636);
            }
            this.setAuthPort(389);
        }
        this.setBindUser(this.getLDAPProp("AREA-LDAP-Bind-User" + index));
        this.setBindPasswd(this.getLDAPProp("AREA-LDAP-Bind-Password" + index));
        this.setTimeout(this.getLDAPProp("External-Authentication-RPC-Timeout"), pluginContext.getARConfigEntry("AREA-LDAP-Connect-Timeout" + index));
        if (this.useSSL()) {
            this.setURL("ldaps://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        } else {
            this.setURL("ldap://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        }
        this.setUserBase(this.getLDAPProp("AREA-LDAP-User-Base" + index));
        this.setUserFilter(this.getLDAPProp("AREA-LDAP-User-Filter" + index));
        this.setChaseReferral(this.getLDAPProp("AREA-LDAP-Chase-Referral" + index));
        if (this.useSSL()) {
            this.setCertKeyStore(this.getLDAPProp("AREA-LDAP-Cert-DB" + index));
        }
        this.setEmailAttribName(this.getLDAPProp("AREA-LDAP-Email" + index));
        this.setDefaultEmail(this.getLDAPProp("AREA-LDAP-Email-Default" + index));
        this.setUseGroups(this.getLDAPProp("AREA-LDAP-Use-Groups" + index));
        this.setRolesAttribName(this.getLDAPProp("AREA-LDAP-Roles" + index));
        this.setDefaultRoles(this.getLDAPProp("AREA-LDAP-Roles-Default" + index));
        this.setNotifyMeth(this.getLDAPProp("AREA-LDAP-Notify-Meth" + index));
        this.setDefaultNotifyMech(this.getLDAPProp("AREA-LDAP-Notify-Meth-Default" + index));
        this.setLicenseMaskAttribName(this.getLDAPProp("AREA-LDAP-LicMask" + index));
        String mask = this.getLDAPProp("AREA-LDAP-LicMask-Default" + index);
        if (mask != null && !mask.isEmpty()) {
            this.setDefaultLicenseMask(Integer.parseInt(mask));
        }
        this.setLicenseTypeAttribName(this.getLDAPProp("AREA-LDAP-Lic" + index));
        String licType = this.getLDAPProp("AREA-LDAP-Lic-Default" + index);
        if (licType != null && !licType.isEmpty()) {
            this.setDefaultLicenseType(Integer.parseInt(licType));
        }
        if ((resLicense = this.getLDAPProp("AREA-LDAP-LicRes1-Default" + index)) != null && !resLicense.isEmpty()) {
            this.setDefaultReservedLicense(Integer.parseInt(resLicense));
        }
        this.setLicenseFTSAttribName(this.getLDAPProp("AREA-LDAP-LicFTS" + index));
        this.setLicenseRes1AttribName(this.getLDAPProp("AREA-LDAP-LicRes1" + index));
        this.setLicenseAppAttribName(this.getLDAPProp("AREA-LDAP-LicAPP" + index));
        this.setDefaultLicenseApp(this.getLDAPProp("AREA-LDAP-LicAPP-Default" + index));
        this.setGroupBase(this.getLDAPProp("AREA-LDAP-Group-Base" + index));
        this.setGroupFilter(this.getLDAPProp("AREA-LDAP-Group-Filter" + index));
        this.setDefaultGroups(this.getLDAPProp("AREA-LDAP-Group-Default" + index));
        return true;
    }

    public String getLDAPProp(String propName) {
        String value = null;
        if (null != this.configSettingMap) {
            for (String key : this.configSettingMap.keySet()) {
                List<String> valueList;
                if (!key.contentEquals(propName) || null == (valueList = this.configSettingMap.get(key)) || valueList.size() <= 0) continue;
                value = valueList.get(0);
                break;
            }
        }
        return value;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setBindUser(String bindUser) {
        this.bindUser = bindUser;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindPasswd(String bindPasswd) throws AREncryptionException {
        String bndPass = null;
        if (bindPasswd != null && !bindPasswd.isEmpty()) {
            PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
            byte[] decPasswd = null;
            decPasswd = pwdEnc.decryptPasswordEx(bindPasswd.getBytes());
            bndPass = new String(decPasswd);
        }
        this.bindPasswd = bndPass;
    }

    public String getBindPasswd() {
        return this.bindPasswd;
    }

    public void setURL(String uRL) {
        this.URL = uRL;
    }

    public String getURL() {
        return this.URL;
    }

    public void setTimeout(String extAuthTimeout, String connectTimeout) {
        int eaTimeout = 0;
        int ldapTimeout = 0;
        try {
            eaTimeout = Integer.parseInt(extAuthTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            ldapTimeout = Integer.parseInt(connectTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (eaTimeout > 0 && eaTimeout < ldapTimeout) {
            if (ldapTimeout > 0 && ldapTimeout < eaTimeout) {
                this.timeout = ldapTimeout < eaTimeout ? ldapTimeout : eaTimeout;
            }
        } else if (ldapTimeout > 0) {
            this.timeout = ldapTimeout;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setChaseReferral(String chaseReferral) {
        this.chaseReferral = chaseReferral;
    }

    public String getChaseReferral() {
        return this.chaseReferral;
    }

    public void setUseSSL(String useSSL) {
        if ("T".equalsIgnoreCase(useSSL)) {
            this.useSSL = true;
        }
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public void setCertKeyStore(String storePath) {
        if (storePath != null && !storePath.isEmpty()) {
            this.keyStorePath = storePath;
            if (this.keyStorePath.contains(";")) {
                this.keyStorePath = this.keyStorePath.replaceAll(";", "");
                this.keyStorePath = this.keyStorePath.trim();
            }
        }
    }

    public String getCertKeyStore() {
        return this.keyStorePath;
    }

    public void setEmailAttribName(String emailAttribName) {
        this.emailAttribName = emailAttribName;
    }

    public String getEmailAttribName() {
        return this.emailAttribName;
    }

    public void setUseGroups(String useGroups) {
        try {
            this.useGroups = Integer.parseInt(useGroups);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getUseGroups() {
        return this.useGroups;
    }

    public void setRolesAttribName(String rolesAttribName) {
        this.rolesAttribName = rolesAttribName;
    }

    public String getRolesAttribName() {
        return this.rolesAttribName;
    }

    public void setNotifyMeth(String notifyMeth) {
        this.notifyMechAttribName = notifyMeth;
    }

    public String getNotifyMeth() {
        return this.notifyMechAttribName;
    }

    public void setLicenseMaskAttribName(String licenseMaskAttribName) {
        this.licenseMaskAttribName = licenseMaskAttribName;
    }

    public String getLicenseMaskAttribName() {
        return this.licenseMaskAttribName;
    }

    public void setDefaultLicenseType(int defaultLicenseType) {
        this.defaultLicenseType = defaultLicenseType;
    }

    public int getDefaultLicenseType() {
        return this.defaultLicenseType;
    }

    public void setDefaultReservedLicense(int defaultReservedLicense) {
        this.defaultReservedLicense = defaultReservedLicense;
    }

    public int getDefaultReservedLicense() {
        return this.defaultReservedLicense;
    }

    public void setLicenseTypeAttribName(String licenseTypeAttribName) {
        this.licenseTypeAttribName = licenseTypeAttribName;
    }

    public void setDefaultLicenseMask(int defaultLicenseMask) {
        this.defaultLicenseMask = defaultLicenseMask;
    }

    public int getDefaultLicenseMask() {
        return this.defaultLicenseMask;
    }

    public String getLicenseTypeAttribName() {
        return this.licenseTypeAttribName;
    }

    public void setDefaultEmail(String defaultEmail) {
        this.defaultEmail = defaultEmail;
    }

    public String getDefaultEmail() {
        return this.defaultEmail;
    }

    public void setDefaultNotifyMech(String defaultNotifyMech) {
        try {
            this.defaultNotifyMech = Integer.parseInt(defaultNotifyMech);
        }
        catch (NumberFormatException ne) {
            this.defaultNotifyMech = 0;
        }
    }

    public int getDefaultNotifyMech() {
        return this.defaultNotifyMech;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setLicenseFTSAttribName(String licenseFTSAttribName) {
        this.licenseFTSAttribName = licenseFTSAttribName;
    }

    public String getLicenseFTSAttribName() {
        return this.licenseFTSAttribName;
    }

    public void setLicenseRes1AttribName(String licenseRes1AttribName) {
        this.licenseRes1AttribName = licenseRes1AttribName;
    }

    public String getLicenseRes1AttribName() {
        return this.licenseRes1AttribName;
    }

    public void setLicenseAppAttribName(String licenseAppAttribName) {
        this.licenseAppAttribName = licenseAppAttribName;
    }

    public String getLicenseAppAttribName() {
        return this.licenseAppAttribName;
    }

    public void setDefaultLicenseApp(String defaultLicenseApp) {
        this.defaultLicenseApp = defaultLicenseApp;
    }

    public String getDefaultLicenseApp() {
        return this.defaultLicenseApp;
    }

    public void setGroupBase(String groupBase) {
        this.groupBase = groupBase;
    }

    public String getGroupBase() {
        return this.groupBase;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setDefaultGroups(String defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public String getDefaultGroups() {
        return this.defaultGroups;
    }

    public String getComponentName(ARPluginContext pluginContext) throws ARException {
        String componentName = null;
        componentName = pluginContext.getARConfigEntry(CONFIGURATION_NAME);
        if (componentName == null || componentName.isEmpty()) {
            componentName = pluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
        }
        if (componentName == null || componentName.isEmpty()) {
            componentName = pluginContext.getARConfigEntry(SERVER_NAME);
        }
        try {
            if (componentName == null || componentName.isEmpty()) {
                componentName = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            componentName = "localhost";
        }
        return componentName;
    }

    public ARServerUser getARServerUser(ARPluginContext arPluginContext) throws ARException {
        ARServerUser arUser = null;
        int localServerPort = 0;
        String localServerName = null;
        localServerName = arPluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
        if (localServerName == null || localServerName.length() == 0) {
            localServerName = arPluginContext.getARConfigEntry(SERVER_NAME);
        }
        if (localServerName == null || localServerName.length() == 0) {
            arPluginContext.logMessage(arPluginContext.getPluginInfo(), 2, "Failed to retrieve ar server host from the ar.cfg file");
            throw new ARException();
        }
        String serverPort = arPluginContext.getARConfigEntry(TCD_SPECIFIC_PORT);
        if (null != serverPort && serverPort.length() > 0) {
            try {
                localServerPort = Integer.parseInt(serverPort);
            }
            catch (NumberFormatException e) {
                arPluginContext.logMessage(arPluginContext.getPluginInfo(), 2, "Failed to convert from String to int the TCD-Specific-Port property with value:" + serverPort + " as it configured in the ar.cfg");
                throw new ARException();
            }
        }
        String pwd = arPluginContext.getARConfigEntry(REMEDY_APP_SERVICE_PASSWORD);
        ARUtilEgcp egcp = new ARUtilEgcp();
        pwd = egcp.GCEUtilApp(pwd);
        arUser = new ARServerUser("Remedy Application Service", pwd, arPluginContext.getAuthString(), null, localServerName);
        if (localServerPort != 0) {
            arUser.setPort(localServerPort);
        }
        return arUser;
    }
}

