/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ardbcldap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.plugins.ardbcldap.DBCLdapProperties;
import com.bmc.arsys.plugins.ardbcldap.RootDSE;
import com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.util.ARUtilEgcp;
import com.bmc.arsys.util.ArrayCentralConfig;
import com.bmc.arsys.util.CentralConfigFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;

public class ARDBCLDAPContext {
    private static final String COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String JNDI_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_SCHEMA_URL_SUB_SCOPE = "sub";
    private static final int LDAP_DFLT_PLAIN_PORT = 389;
    private static final int LDAP_DFLT_SLL_PORT = 636;
    private DBCLdapProperties dbcLdapProps = new DBCLdapProperties();
    Map<String, List<String>> configSettingMap;
    private final String ARDBC_CONFIG_COMPONENT_TYPE = "com.bmc.arsys.ldap.ardbc";
    private static final String SERVER_CONNECT_NAME = "Server-Connect-Name";
    private static final String SERVER_NAME = "Server-Name";
    private static final String TCD_SPECIFIC_PORT = "TCD-Specific-Port";
    private static final String REMEDY_APP_SERVICE_PASSWORD = "Remedy-App-Service-Password";
    private static final String CONFIGURATION_NAME = "Configuration-Name";

    String getBaseDN(RootDSE rootDSE) {
        String cfgBaseDN = this.dbcLdapProps.getBaseDN();
        String baseDN = null;
        baseDN = cfgBaseDN != null && !cfgBaseDN.isEmpty() ? cfgBaseDN : rootDSE.getDefaultNamingContext();
        return baseDN;
    }

    public void populateProperties(ARPluginContext context) throws ARException {
        this.configSettingMap = this.getComponentMap(context);
        this.dbcLdapProps.setBindUser(this.getLDAPProp("ARDBC-LDAP-User-DN"));
        this.dbcLdapProps.setBindPassword(this.getLDAPProp("ARDBC-LDAP-Password"));
        this.setHostNames(this.getLDAPProp("ARDBC-LDAP-Hostname"));
        String useSSL = this.getLDAPProp("ARDBC-LDAP-UsingSSL");
        if (useSSL != null && useSSL.equals("T")) {
            this.dbcLdapProps.setUseSSL(true);
            String storePath = this.getLDAPProp("ARDBC-LDAP-Cert-DB");
            if (storePath != null && !storePath.isEmpty()) {
                if (storePath.contains(";")) {
                    storePath = storePath.replaceAll(";", "");
                }
                this.dbcLdapProps.setCertificateDB(storePath.trim());
            }
        }
        String ldapPort = this.getLDAPProp("ARDBC-LDAP-Port");
        int port = 0;
        try {
            port = Integer.parseInt(ldapPort);
        }
        catch (Exception e) {
            port = this.dbcLdapProps.isUseSSL() ? 636 : 389;
            context.logMessage(context.getPluginInfo(), 1, "Invalid Port specified:" + ldapPort + ",using port:" + port);
        }
        this.dbcLdapProps.setPortNumber(port);
        this.dbcLdapProps.setCertName(this.getLDAPProp("ARDBC-LDAP-Cert-Name"));
        this.dbcLdapProps.setKeyDB(this.getLDAPProp("ARDBC-LDAP-Key-DB"));
        this.dbcLdapProps.setKeyPassword(this.getLDAPProp("ARDBC-LDAP-Key-Password"));
        this.dbcLdapProps.setPageSize(this.getLDAPProp("ARDBC-LDAP-Page-Size"));
        this.dbcLdapProps.setChaseReferrals(true);
        this.dbcLdapProps.setTimeFormat(this.getLDAPProp("ARDBC-LDAP-Time-Format"));
        this.dbcLdapProps.setConnectTimeout(this.getLDAPProp("Server-Plugin-Default-Timeout"), this.getLDAPProp("ARDBC-LDAP-Connect-Timeout"));
        this.dbcLdapProps.setBaseDN(this.getLDAPProp("ARDBC-LDAP-Base-Dn"));
        String useCashe = this.getLDAPProp("ARDBC-LDAP-Use-Cache");
        if (useCashe != null && useCashe.equals("T")) {
            this.dbcLdapProps.setUseCache(true);
        }
        this.dbcLdapProps.setCacheTTL(this.getLDAPProp("ARDBC-LDAP-Cache-TTL"));
        String maxCacheSize = this.getLDAPProp("ARDBC-LDAP-Cache-MaxSize");
        if (maxCacheSize == null || "".equals(maxCacheSize)) {
            this.dbcLdapProps.setMaxCacheSize(0);
        } else {
            this.dbcLdapProps.setMaxCacheSize(Integer.parseInt(maxCacheSize));
        }
        String dnTimeout = this.getLDAPProp("ARDBC-LDAP-DN-Timeout");
        if (dnTimeout == null || "".equals(dnTimeout)) {
            this.dbcLdapProps.setDnTimeout(0);
        } else {
            this.dbcLdapProps.setDnTimeout(Integer.parseInt(dnTimeout));
        }
    }

    public Set<String> findSubDIT(String basedn, LdapContext ldapContext) throws NamingException {
        HashSet<String> subDIT = new HashSet<String>();
        String filter = "(objectclass=*)";
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(new String[]{"objectclass"});
        sCntrl.setSearchScope(2);
        NamingEnumeration<SearchResult> subTree = ldapContext.search(basedn, filter, sCntrl);
        while (subTree.hasMoreElements()) {
            SearchResult node = (SearchResult)subTree.nextElement();
            NamingEnumeration<? extends Attribute> attrs = node.getAttributes().getAll();
            while (attrs.hasMoreElements()) {
                Attribute attr = (Attribute)attrs.nextElement();
                for (int i = 0; i < attr.size(); ++i) {
                    subDIT.add(attr.get(i).toString());
                }
            }
        }
        return subDIT;
    }

    public List<VendorForm> getTableNames(ARPluginContext context, LdapContext ldapContext, StringBuilder ldapURL, RootDSE rootDSE) throws NamingException {
        String baseDN = this.getBaseDN(rootDSE);
        Set<String> subDIT = this.findSubDIT(baseDN, ldapContext);
        ArrayList<VendorForm> tableList = new ArrayList<VendorForm>(subDIT.size());
        if (!subDIT.isEmpty()) {
            for (String objectClassNm : subDIT) {
                StringBuilder tableURL = new StringBuilder();
                tableURL.append((CharSequence)ldapURL).append(baseDN).append("??").append(LDAP_SCHEMA_URL_SUB_SCOPE).append("?(objectclass=").append(objectClassNm).append(")");
                String url = tableURL.toString();
                context.logMessage(context.getPluginInfo(), 0, url);
                VendorForm form = new VendorForm("ARSYS.ARDBC.LDAP", url);
                tableList.add(form);
            }
        }
        return tableList;
    }

    List<String> ifEntriesExist(LdapContext ldapContext, String objClassName, String baseDN) throws NamingException {
        ArrayList<String> baseNames = new ArrayList<String>();
        String filter = "(objectclass=" + objClassName + ")";
        String[] attrIds = new String[]{"1.1"};
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrIds);
        sCntrl.setSearchScope(2);
        NamingEnumeration<SearchResult> enm = ldapContext.search(baseDN, filter, sCntrl);
        while (enm.hasMoreElements()) {
            SearchResult result = (SearchResult)enm.nextElement();
            String resultDN = result.getNameInNamespace();
            if (!resultDN.equalsIgnoreCase(baseDN)) {
                int index = resultDN.indexOf(44) + 1;
                resultDN = resultDN.substring(index);
            }
            if (baseNames.contains(resultDN)) continue;
            baseNames.add(resultDN);
        }
        return baseNames;
    }

    String getObjectClassName(String value) {
        int nameIndex = value.indexOf("NAME");
        String name = null;
        if (nameIndex != -1) {
            int start = value.indexOf("'", nameIndex) + 1;
            int end = value.indexOf("'", start);
            name = value.substring(start, end);
        }
        return name;
    }

    Enumeration<SearchResult> searchLDAP(String basedn, LdapContext ldapContext, String[] attrIds) throws NamingException {
        String filter = "(objectclass=*)";
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrIds);
        sCntrl.setSearchScope(0);
        NamingEnumeration<SearchResult> enm = ldapContext.search(basedn, filter, sCntrl);
        return enm;
    }

    LdapContext getInitialContext(ARPluginContext context) throws NamingException, IOException, ARException {
        int pageSize;
        if (this.dbcLdapProps.getHostNames() == null) {
            throw new ARException(2, 3377, "LDAP Server Host name not configured !");
        }
        Properties env = new Properties();
        if (this.dbcLdapProps.isUseSSL()) {
            String certDb = this.dbcLdapProps.getCertificateDB();
            if (certDb == null || certDb.isEmpty()) {
                throw new ARException(2, 3377, "TLS is enabled but No certificate keystore provided!");
            }
            ARLDAPSSLFactory.setKeyStorePath(this.dbcLdapProps.getCertificateDB());
            env.put("java.naming.ldap.factory.socket", "com.bmc.arsys.plugins.customssl.ARLDAPSSLFactory");
            env.put("java.naming.security.protocol", "tls");
            context.logMessage(context.getPluginInfo(), 0, "Setting Context.SECURITY_PROTOCOL: " + env.getProperty("java.naming.security.protocol"));
        } else {
            env.put(COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT, Integer.toString(this.dbcLdapProps.getConnectTimeout() * 1000));
        }
        env.put("java.naming.factory.initial", JNDI_LDAP_CTX_FACTORY);
        env.put("java.naming.security.authentication", "simple");
        if (this.dbcLdapProps.getBindUser() != null && !this.dbcLdapProps.getBindUser().isEmpty()) {
            env.put("java.naming.security.principal", this.dbcLdapProps.getBindUser());
            if (this.dbcLdapProps.getBindPassword() != null) {
                env.put("java.naming.security.credentials", this.dbcLdapProps.getBindPassword());
            }
        } else {
            context.logMessage(context.getPluginInfo(), 0, "Bind user is not configured so trying anonymous access!");
        }
        LdapContext initCtx = null;
        int count = 1;
        String sslLog = "";
        if (this.dbcLdapProps.isUseSSL()) {
            sslLog = "(Using " + env.getProperty("java.naming.security.protocol") + ")";
        }
        for (String host : this.dbcLdapProps.getHostNames()) {
            String protocol = "ldap";
            if (this.dbcLdapProps.isUseSSL()) {
                protocol = "ldaps";
            }
            String url = new StringBuffer().append(protocol + "://").append(host).append(":").append(this.dbcLdapProps.getPortNumber()).toString();
            context.logMessage(context.getPluginInfo(), 0, "Connecting to LDAP server:" + sslLog + url);
            env.put("java.naming.provider.url", url);
            try {
                initCtx = new InitialLdapContext(env, null);
            }
            catch (NamingException ne) {
                initCtx = null;
                if (this.dbcLdapProps.getHostNames().size() > count) {
                    ++count;
                    context.logMessage(context.getPluginInfo(), 2, ne.toString());
                }
                throw ne;
            }
            if (initCtx == null) continue;
            this.dbcLdapProps.setResolvedHost(host);
            break;
        }
        if ((pageSize = this.dbcLdapProps.getPageSize()) != 0) {
            initCtx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
        }
        return initCtx;
    }

    RootDSE getBaseName(LdapContext ldapContext) {
        RootDSE rootDSE = new RootDSE();
        try {
            String[] attrIds = new String[]{"subschemaSubentry", "defaultNamingContext", "namingContexts", ""};
            Enumeration<SearchResult> enm = this.searchLDAP("", ldapContext, attrIds);
            if (enm.hasMoreElements()) {
                SearchResult result = enm.nextElement();
                Attributes attrs = result.getAttributes();
                NamingEnumeration<String> attrEnum = attrs.getIDs();
                boolean ncFound = false;
                while (attrEnum.hasMoreElements()) {
                    String attrID = (String)attrEnum.nextElement();
                    if ("subschemaSubentry".equals(attrID)) {
                        rootDSE.setSubSchemaSubentry(attrs.get(attrID).get().toString());
                        continue;
                    }
                    if ("defaultNamingContext".equals(attrID)) {
                        rootDSE.setDefaultNamingContext(attrs.get(attrID).get().toString());
                        ncFound = true;
                        continue;
                    }
                    if (!"namingContexts".equals(attrID) || ncFound) continue;
                    rootDSE.setDefaultNamingContext(attrs.get(attrID).get(0).toString());
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return rootDSE;
    }

    public void setDbcLdapProps(DBCLdapProperties dbcLdapProps) {
        this.dbcLdapProps = dbcLdapProps;
    }

    public DBCLdapProperties getDbcLdapProps() {
        return this.dbcLdapProps;
    }

    List<ARVendorField> getObjectAttributes(String tableName, RootDSE rootDSE, LdapContext ldapContext) throws NamingException {
        ArrayList<ARVendorField> fields = new ArrayList<ARVendorField>();
        String filter = ARDBCLDAPContext.getFilter(tableName);
        String[] attrs = new String[]{"*", "createTimestamp", "modifyTimestamp", "creatorsName", "modifiersName"};
        SearchControls sCntrl = new SearchControls();
        sCntrl.setReturningAttributes(attrs);
        sCntrl.setSearchScope(2);
        sCntrl.setCountLimit(1L);
        NamingEnumeration<SearchResult> enm = ldapContext.search(this.getBaseDN(rootDSE), filter, sCntrl);
        if (enm.hasMoreElements()) {
            SearchResult result = (SearchResult)enm.nextElement();
            Attributes attributes = result.getAttributes();
            NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
            while (attrEnum.hasMoreElements()) {
                String syntaxValue;
                Attribute nextElement = (Attribute)attrEnum.nextElement();
                ARVendorField field = new ARVendorField();
                DirContext attrCtx = nextElement.getAttributeDefinition();
                field.setName(nextElement.getID());
                Attribute syntaxAttrib = attrCtx.getAttributes("").get("SYNTAX");
                field.setDataType(4);
                if (syntaxAttrib != null && (syntaxValue = (String)syntaxAttrib.get()) != null) {
                    if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.27") || syntaxValue.equals("Integer")) {
                        field.setDataType(2);
                    } else if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.24") || syntaxValue.equals("GeneralizedTime")) {
                        field.setDataType(7);
                    } else if (syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.1") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.4") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.5") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.8") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.9") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.10") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.23") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.28") || syntaxValue.equals("1.3.6.1.4.1.1466.115.121.1.49") || syntaxValue.equals("ACIItem") || syntaxValue.equals("Audio") || syntaxValue.equals("Binary") || syntaxValue.equals("Certificate") || syntaxValue.equals("CertificateList") || syntaxValue.equals("CertificatePair") || syntaxValue.equals("Fax") || syntaxValue.equals("JPEG") || syntaxValue.equals("SupportedAlgorithm")) {
                        field.setDataType(11);
                    }
                }
                fields.add(field);
            }
        }
        return fields;
    }

    static String getFilter(String tableName) {
        String[] parts = tableName.split("\\?");
        return parts[parts.length - 1];
    }

    private void setHostNames(String hostNames) {
        if (hostNames == null) {
            return;
        }
        ArrayList<String> hosts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(hostNames);
        while (st.hasMoreTokens()) {
            String host = st.nextToken();
            if (host.contains(":") && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            hosts.add(host);
        }
        this.dbcLdapProps.setHostNames(hosts);
    }

    private void setCertificate() {
    }

    private String getLDAPProp(String propName) {
        String value = null;
        if (null != this.configSettingMap) {
            for (String key : this.configSettingMap.keySet()) {
                List<String> valueList;
                if (!key.contentEquals(propName) || null == (valueList = this.configSettingMap.get(key)) || valueList.size() <= 0) continue;
                value = valueList.get(0);
            }
        }
        return value;
    }

    public ARServerUser getARServerUser(ARPluginContext arPluginContext) throws ARException {
        ARServerUser arUser = null;
        int localServerPort = 0;
        String localServerName = null;
        localServerName = arPluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
        if (localServerName == null || localServerName.length() == 0) {
            localServerName = arPluginContext.getARConfigEntry(SERVER_NAME);
        }
        if (localServerName == null || localServerName.length() == 0) {
            arPluginContext.logMessage(arPluginContext.getPluginInfo(), 2, "Failed to retrieve ar server host from the ar.cfg file");
            throw new ARException();
        }
        String serverPort = arPluginContext.getARConfigEntry(TCD_SPECIFIC_PORT);
        if (null != serverPort && serverPort.length() > 0) {
            try {
                localServerPort = Integer.parseInt(serverPort);
            }
            catch (NumberFormatException e) {
                arPluginContext.logMessage(arPluginContext.getPluginInfo(), 2, "Failed to convert from String to int the TCD-Specific-Port property with value:" + serverPort + " as it configured in the ar.cfg");
                throw new ARException();
            }
        }
        String pwd = arPluginContext.getARConfigEntry(REMEDY_APP_SERVICE_PASSWORD);
        ARUtilEgcp egcp = new ARUtilEgcp();
        pwd = egcp.GCEUtilApp(pwd);
        arUser = new ARServerUser("Remedy Application Service", pwd, arPluginContext.getAuthString(), null, localServerName);
        if (localServerPort != 0) {
            arUser.setPort(localServerPort);
        }
        return arUser;
    }

    private Map<String, List<String>> getComponentMap(ARPluginContext context) throws ARException {
        Map configSettingMap = null;
        ARServerUser arserverUser = this.getARServerUser(context);
        ArrayCentralConfig centralConigObj = CentralConfigFactory.newInstance((ARServerUser)arserverUser).newArrayCentralConfig();
        try {
            configSettingMap = centralConigObj.getConfigSettingsAsMap(this.getComponentName(context), "com.bmc.arsys.ldap.ardbc", null);
        }
        catch (Exception e) {
            context.logMessage(context.getPluginInfo(), 1, "Failed to retrieve config setting map for ARDBC Ldap");
            throw e;
        }
        return configSettingMap;
    }

    public String getComponentName(ARPluginContext pluginContext) throws ARException {
        String componentName = null;
        componentName = pluginContext.getARConfigEntry(CONFIGURATION_NAME);
        if (componentName == null || componentName.isEmpty()) {
            componentName = pluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
        }
        if (componentName == null || componentName.isEmpty()) {
            componentName = pluginContext.getARConfigEntry(SERVER_NAME);
        }
        try {
            if (componentName == null) {
                componentName = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            componentName = "localhost";
        }
        return componentName;
    }
}

