/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARQualifierHelper;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.util.ArrayList;
import java.util.List;

public class Utilities {
    public static String tzTimeZone = System.getenv("TZ");
    private static final int AR_RESERV_PREFERENCE_ARS_SCHEMA_USER = 30002;
    private static final int[] PREF_SCHEMA_KEY = new int[]{30002};
    private static final int[] USER_PREFERENCE_FIELD_IDS = new int[]{24003, 24015};
    private static String userPrefForm = null;

    public static int getIntegerValue(String value) {
        int nValue;
        block6: {
            nValue = 0;
            try {
                if (value != null && value.length() > 0) {
                    nValue = Integer.parseInt(value);
                }
            }
            catch (NumberFormatException nfe) {
                int ind = value.indexOf(";");
                if (ind == -1) break block6;
                value = value.substring(0, ind);
                try {
                    if (value != null && value.length() > 0) {
                        nValue = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return nValue;
    }

    public static int getVuiId(ARServerUser user, String formName, String localeName) {
        try {
            ArrayList<Value> paramList = new ArrayList<Value>();
            paramList.add(new Value(36));
            paramList.add(new Value("\"" + formName + "\""));
            paramList.add(new Value("3"));
            paramList.add(new Value(localeName));
            ProcessResult pr = user.executeProcessForActiveLink("*RemedyApplicationCommand", 9999, 0, 0, new Timestamp(0L), null, paramList);
            return new Integer(pr.getOutput());
        }
        catch (ARException are) {
            return -9999;
        }
    }

    public static QualifierInfo parseQualification(ARServerUser context, String queryString, String form, String locale) throws ARException {
        int vuid = Utilities.getVuiId(context, form, locale);
        List fieldObjectList = context.getListFieldObjects(form);
        ARQualifierHelper helper = new ARQualifierHelper();
        helper.generateFieldMaps(fieldObjectList, vuid, null, null);
        Utilities.loadUserPreference(context);
        if (tzTimeZone != null) {
            return helper.parseQualification(locale, queryString, tzTimeZone);
        }
        return helper.parseQualification(locale, queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult getLocalizedQual(ARServerUser user, String formName, int vuid, String originalQuery, String locale) throws ARException {
        String oldLocale = user.getLocale();
        if (locale != null && locale.length() > 0) {
            user.setLocale(locale);
        }
        try {
            ArrayList<Value> paramList = new ArrayList<Value>();
            paramList.add(new Value(20));
            paramList.add(new Value("\"" + formName + "\""));
            paramList.add(new Value("\"" + (vuid != 0 ? Integer.valueOf(vuid) : "") + "\""));
            paramList.add(new Value(originalQuery));
            ProcessResult processResult = user.executeProcessForActiveLink("*RemedyApplicationCommand", 9999, 0, 0, new Timestamp(0L), null, paramList);
            return processResult;
        }
        finally {
            user.setLocale(oldLocale);
        }
    }

    private static QualifierInfo buildUserPrefQualifier(ARServerUser serverUser) {
        return new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(OperandType.FIELDID, CoreFieldId.Submitter.getFieldId()), new ArithmeticOrRelationalOperand(new Value(serverUser.getUser()))));
    }

    public static void loadUserPreference(ARServerUser serverUser) throws ARException {
        List el;
        serverUser.setCustomDateFormat(null);
        serverUser.setCustomTimeFormat(null);
        if (userPrefForm == null) {
            List schemaList = serverUser.getListForm(0L, FormType.ALL.toInt() | 0x400, null, PREF_SCHEMA_KEY);
            if (schemaList == null) {
                return;
            }
            userPrefForm = (String)schemaList.get(0);
        }
        if ((el = serverUser.getListEntryObjects(userPrefForm, Utilities.buildUserPrefQualifier(serverUser), 0, 1, new ArrayList(), USER_PREFERENCE_FIELD_IDS, false, null)) == null) {
            return;
        }
        Entry[] data = el.toArray(new Entry[0]);
        if (data != null && data.length > 0) {
            String customTimeFormat;
            String customDateFormat;
            Value custDate = (Value)data[0].get((Object)USER_PREFERENCE_FIELD_IDS[0]);
            Value custTime = (Value)data[0].get((Object)USER_PREFERENCE_FIELD_IDS[1]);
            if (custDate != null && custDate.getValue() != null && (customDateFormat = custDate.toString()).length() > 0) {
                serverUser.setCustomDateFormat(customDateFormat);
            }
            if (custTime != null && custTime.getValue() != null && (customTimeFormat = custTime.getValue().toString()).length() > 0) {
                serverUser.setCustomTimeFormat(customTimeFormat);
            }
        }
    }
}

