/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.ant;

import java.io.File;
import java.io.IOException;
import org.acplt.oncrpc.apps.jrpcgen.jrpcgen;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JrpcgenTask
extends Task {
    private File srcFile;
    private File destDir;
    private String packageName;
    private boolean debug = false;
    private boolean verbose = false;
    private boolean backup = false;
    private boolean createDir = false;

    public void setSrcfile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setCreatedir(boolean createDir) {
        this.createDir = createDir;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void execute() throws BuildException {
        this.checkAttributes();
        try {
            System.out.println("Compiling " + this.srcFile.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.packageName != null) {
            jrpcgen.packageName = this.packageName;
            try {
                this.destDir = new File(this.destDir.getCanonicalPath() + File.separator + this.packageName.replace('.', File.separatorChar));
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.createDir) {
            try {
                boolean dirsCreated;
                if (!this.destDir.exists() && !(dirsCreated = this.destDir.mkdirs())) {
                    throw new BuildException("Could not create destination dir");
                }
            }
            catch (SecurityException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (this.debug) {
            this.dumpState();
        }
        jrpcgen.debug = this.debug;
        jrpcgen.verbose = this.verbose;
        jrpcgen.noBackups = !this.backup;
        jrpcgen.destinationDir = this.destDir;
        jrpcgen.xFile = this.srcFile;
        try {
            jrpcgen.doParse();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    private void checkAttributes() throws BuildException {
        if (this.srcFile == null) {
            throw new BuildException("srcfile has not been set");
        }
        if (this.destDir == null) {
            throw new BuildException("destdir has not been set");
        }
        try {
            if (!this.srcFile.isFile()) {
                throw new BuildException("problem reading srcdir");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("problem accessing srcdir");
            }
        }
        catch (SecurityException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void dumpState() {
        System.out.println(this.srcFile);
        System.out.println(this.destDir);
        System.out.println(this.packageName);
        System.out.println(this.backup);
        System.out.println(this.debug);
        System.out.println(this.verbose);
        System.out.println(this.createDir);
    }
}

