/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class StringUtils {
    private static final Map<CharSequence, CharSequence> BASIC_ESCAPE = new HashMap<CharSequence, CharSequence>();

    public static byte[] getUtf8Bytes(String input) {
        if (input == null) {
            return null;
        }
        try {
            return input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String stripControlCharacters(String rawValue) {
        int i;
        if (rawValue == null) {
            return null;
        }
        String value = StringUtils.replaceEntities(rawValue);
        boolean hasControlChars = false;
        for (int i2 = value.length() - 1; i2 >= 0; --i2) {
            if (!Character.isISOControl(value.charAt(i2))) continue;
            hasControlChars = true;
            break;
        }
        if (!hasControlChars) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length());
        for (i = 0; i < value.length() && Character.isISOControl(value.charAt(i)); ++i) {
        }
        boolean suppressingControlChars = false;
        while (i < value.length()) {
            if (Character.isISOControl(value.charAt(i))) {
                suppressingControlChars = true;
            } else {
                if (suppressingControlChars) {
                    suppressingControlChars = false;
                    buf.append(' ');
                }
                buf.append(value.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    private static String replaceEntities(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            String c = String.valueOf(Character.toChars(Character.codePointAt(value, i)));
            CharSequence escapedEntity = BASIC_ESCAPE.get(c);
            if (escapedEntity == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedEntity);
        }
        return sb.toString();
    }

    static {
        BASIC_ESCAPE.put("\"", "&quot;");
        BASIC_ESCAPE.put("&", "&amp;");
        BASIC_ESCAPE.put("<", "&lt;");
        BASIC_ESCAPE.put(">", "&gt;");
    }
}

