/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.ws;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.WebSocket;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedChannel;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedHandler;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketSelectedHandlerImpl
extends WebSocketHandlerAdapter
implements WebSocketSelectedHandler {
    private static final String CLASS_NAME = WebSocketSelectedHandlerImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static WebSocketSelectedHandlerFactory FACTORY = new WebSocketSelectedHandlerFactory(){

        @Override
        public WebSocketSelectedHandlerImpl createSelectedHandler() {
            return new WebSocketSelectedHandlerImpl();
        }
    };
    protected WebSocketHandlerListener listener;

    public WebSocketSelectedHandlerImpl() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public void processConnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "connect", channel);
        if (((WebSocketSelectedChannel)channel).readyState == WebSocket.ReadyState.CLOSED) {
            throw new IllegalStateException("WebSocket is already closed");
        }
        this.nextHandler.processConnect(channel, uri, protocol);
    }

    public void handleConnectionOpened(WebSocketChannel channel, String protocol) {
        LOG.entering(CLASS_NAME, "handleConnectionOpened");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState == WebSocket.ReadyState.CONNECTING) {
            selectedChannel.readyState = WebSocket.ReadyState.OPEN;
            this.listener.connectionOpened(channel, protocol);
        }
    }

    public void handleMessageReceived(WebSocketChannel channel, ByteBuffer message) {
        LOG.entering(CLASS_NAME, "handleMessageReceived", message);
        if (((WebSocketSelectedChannel)channel).readyState != WebSocket.ReadyState.OPEN) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, message.getHexDump());
        }
        this.listener.messageReceived(channel, message);
    }

    protected void handleConnectionClosed(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "handleConnectionClosed");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState != WebSocket.ReadyState.CLOSED) {
            selectedChannel.readyState = WebSocket.ReadyState.CLOSED;
            this.listener.connectionClosed(channel);
        }
    }

    protected void handleConnectionFailed(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "connectionFailed");
        WebSocketSelectedChannel selectedChannel = (WebSocketSelectedChannel)channel;
        if (selectedChannel.readyState != WebSocket.ReadyState.CLOSED) {
            selectedChannel.readyState = WebSocket.ReadyState.CLOSED;
            this.listener.connectionFailed(channel);
        }
    }

    @Override
    public void setNextHandler(WebSocketHandler nextHandler) {
        this.nextHandler = nextHandler;
        nextHandler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketSelectedHandlerImpl.this.handleConnectionOpened(channel, protocol);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer message) {
                WebSocketSelectedHandlerImpl.this.handleMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketSelectedHandlerImpl.this.handleConnectionClosed(channel);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketSelectedHandlerImpl.this.handleConnectionFailed(channel);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }
        });
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }

    static interface WebSocketSelectedHandlerFactory {
        public WebSocketSelectedHandler createSelectedHandler();
    }
}

