/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj.annotation;

import com.bmc.thirdparty.org.springframework.aop.Pointcut;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJExpressionPointcut;
import com.bmc.thirdparty.org.springframework.aop.aspectj.TypePatternClassFilter;
import com.bmc.thirdparty.org.springframework.aop.framework.AopConfigException;
import com.bmc.thirdparty.org.springframework.aop.support.ComposablePointcut;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;

public class AspectMetadata {
    private final AjType<?> ajType;
    private final Pointcut perClausePointcut;
    private String aspectName;

    public AspectMetadata(Class<?> aspectClass, String aspectName) {
        this.aspectName = aspectName;
        Class<?> currClass = aspectClass;
        AjType ajType = null;
        while (!currClass.equals(Object.class)) {
            AjType ajTypeToCheck = AjTypeSystem.getAjType(currClass);
            if (ajTypeToCheck.isAspect()) {
                ajType = ajTypeToCheck;
                break;
            }
            currClass = currClass.getSuperclass();
        }
        if (ajType == null) {
            throw new IllegalArgumentException("Class '" + aspectClass.getName() + "' is not an @AspectJ aspect");
        }
        this.ajType = ajType;
        if (this.ajType.getDeclarePrecedence().length > 0) {
            throw new IllegalArgumentException("DeclarePrecendence not presently supported in Spring AOP");
        }
        switch (this.ajType.getPerClause().getKind()) {
            case SINGLETON: {
                this.perClausePointcut = Pointcut.TRUE;
                return;
            }
            case PERTARGET: 
            case PERTHIS: {
                AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut();
                ajexp.setLocation("@Aspect annotation on " + aspectClass.getName());
                ajexp.setExpression(this.findPerClause(aspectClass));
                this.perClausePointcut = ajexp;
                return;
            }
            case PERTYPEWITHIN: {
                this.perClausePointcut = new ComposablePointcut(new TypePatternClassFilter(this.findPerClause(aspectClass)));
                return;
            }
        }
        throw new AopConfigException("PerClause " + ajType.getPerClause().getKind() + " not supported by Spring AOP for " + aspectClass);
    }

    private String findPerClause(Class<?> aspectClass) {
        String str = aspectClass.getAnnotation(Aspect.class).value();
        str = str.substring(str.indexOf("(") + 1);
        str = str.substring(0, str.length() - 1);
        return str;
    }

    public AjType<?> getAjType() {
        return this.ajType;
    }

    public Class<?> getAspectClass() {
        return this.ajType.getJavaClass();
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public Pointcut getPerClausePointcut() {
        return this.perClausePointcut;
    }

    public boolean isPerThisOrPerTarget() {
        PerClauseKind kind = this.getAjType().getPerClause().getKind();
        return kind == PerClauseKind.PERTARGET || kind == PerClauseKind.PERTHIS;
    }

    public boolean isPerTypeWithin() {
        PerClauseKind kind = this.getAjType().getPerClause().getKind();
        return kind == PerClauseKind.PERTYPEWITHIN;
    }

    public boolean isLazilyInstantiated() {
        return this.isPerThisOrPerTarget() || this.isPerTypeWithin();
    }
}

