/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Scanner;

public class DSOPoolAssignmentDecoder {
    static final String FILE_DELIMITER = "\\\\";
    static final String AR_CURRENT_SERVER_TAG = "@";
    static final int ASSIGN_TYPE_MARKER = 100;
    static final int ERROR_UNEXPECTED_VALUE = -1;
    private int asgnFldId;
    private String encStr;
    private ARServerUser context;
    private Scanner scanner;

    private void init() throws ARException {
        this.scanner = new Scanner(this.encStr).useDelimiter(FILE_DELIMITER);
        this.asgnFldId = this.readInt();
    }

    public AssignInfo decode(String encStr, ARServerUser context) throws ARException {
        this.encStr = encStr;
        this.context = context;
        this.init();
        return this.createAssignInfo();
    }

    private AssignInfo createAssignInfo() throws ARException {
        AssignInfo asgnInfo = new AssignInfo();
        int asgnType = this.readInt() - 100;
        switch (asgnType) {
            case 0: {
                asgnInfo.setAssignType(0);
                break;
            }
            case 1: {
                asgnInfo.setAssignType(1);
                asgnInfo.setValue(this.createValue());
                break;
            }
            case 3: {
                asgnInfo.setAssignType(3);
                asgnInfo.setProcess(this.createProcess());
                break;
            }
            case 4: {
                asgnInfo.setAssignType(4);
                asgnInfo.setArithOp(this.createArithOpAssignInfo());
                break;
            }
            case 7: {
                asgnInfo.setAssignType(7);
                break;
            }
            case 6: {
                asgnInfo.setAssignType(6);
                break;
            }
            case 8: {
                asgnInfo.setAssignType(8);
                break;
            }
            case 5: {
                asgnInfo.setAssignType(5);
                asgnInfo.setFunction(this.createFunction());
                break;
            }
            case 2: {
                asgnInfo.setAssignType(2);
                asgnInfo.setField(this.createFieldAssignInfo());
                break;
            }
            default: {
                this.throwError();
            }
        }
        return asgnInfo;
    }

    private AssignFieldInfo createFieldAssignInfo() throws ARException {
        AssignFieldInfo asgnFldInfo = new AssignFieldInfo();
        int serverNameLength = this.readInt();
        String server = null;
        this.scanner.useDelimiter("\\z");
        String tempStr = this.readLine();
        server = tempStr.substring(1, serverNameLength + 1);
        asgnFldInfo.setServer(server);
        if (tempStr != null) {
            this.scanner = new Scanner(tempStr.substring(serverNameLength + 1)).useDelimiter(FILE_DELIMITER);
        }
        if (asgnFldInfo.getServer().equals(AR_CURRENT_SERVER_TAG)) {
            // empty if block
        }
        int schemaNameLength = this.readInt();
        String schema = null;
        this.scanner.useDelimiter("\\z");
        tempStr = this.readLine();
        schema = tempStr.substring(1, schemaNameLength + 1);
        asgnFldInfo.setForm(schema);
        if (tempStr != null) {
            this.scanner = new Scanner(tempStr.substring(schemaNameLength + 1)).useDelimiter(FILE_DELIMITER);
        }
        asgnFldInfo.setTag(this.readInt());
        if (asgnFldInfo.getTag() == 1) {
            asgnFldInfo.setFieldId(this.readInt());
        } else if (asgnFldInfo.getTag() == 6) {
            int pTag;
            int currFId = this.readInt();
            CurrencyPartInfo cpi = new CurrencyPartInfo(currFId, pTag, (pTag = this.readInt()) == 4 ? this.readString() : "");
            asgnFldInfo.setCurrencyPart(cpi);
        } else if (asgnFldInfo.getTag() == 4) {
            int enumValue = this.readInt();
            boolean bType = this.readInt() == 1;
            StatusHistoryValueIndicator statusHist = new StatusHistoryValueIndicator(bType, enumValue);
            asgnFldInfo.setStatHistory(statusHist);
        }
        this.scanner.next();
        return asgnFldInfo;
    }

    private ArithOpAssignInfo createArithOpAssignInfo() throws ARException {
        ArithOpAssignInfo arithOp = new ArithOpAssignInfo();
        arithOp.setOperation(this.readInt());
        if (arithOp.getOperation() != 6) {
            arithOp.setOperandLeft(this.createAssignInfo());
        }
        arithOp.setOperandRight(this.createAssignInfo());
        return arithOp;
    }

    private FunctionAssignInfo createFunction() throws ARException {
        FunctionAssignInfo funcInfo = new FunctionAssignInfo();
        funcInfo.setFunctionCode(this.readInt());
        int paramCount = this.readInt();
        ArrayList<AssignInfo> paramList = new ArrayList<AssignInfo>();
        for (int i = 0; i < paramCount; ++i) {
            paramList.add(this.createAssignInfo());
        }
        funcInfo.setParameterList(paramList);
        return funcInfo;
    }

    private String createProcess() throws ARException {
        String procCmd = null;
        int procCmdSize = this.readInt();
        this.scanner.useDelimiter("\\z");
        String tempStr = this.readLine();
        procCmd = tempStr.substring(1, procCmdSize + 1);
        this.scanner = new Scanner(tempStr.substring(procCmdSize + 1)).useDelimiter(FILE_DELIMITER);
        return procCmd;
    }

    private Value createValue() throws ARException {
        Value value = null;
        int dataType = this.readInt();
        switch (dataType) {
            case 0: {
                value = new Value();
                break;
            }
            case 1: {
                Keyword kw = Keyword.toKeyword(this.readInt());
                value = new Value(kw);
                break;
            }
            case 2: {
                int intValue = this.readInt();
                value = new Value(intValue);
                break;
            }
            case 3: {
                double dblValue = this.readDouble();
                value = new Value(dblValue);
                break;
            }
            case 4: 
            case 5: {
                int useCodeSet = this.readInt();
                value = new Value(this.readString());
                break;
            }
            case 6: {
                String strEnum = this.readString();
                DataType dto = DataType.toDataType(6);
                value = new Value(strEnum, dto);
                break;
            }
            case 7: {
                long tmpStmp = this.readLong();
                value = new Value(new Timestamp(tmpStmp));
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                double dblVal = this.readDouble();
                value = new Value(dblVal);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                String currVal = this.readString();
                String currCode = this.readString();
                CurrencyValue cv = new CurrencyValue();
                cv.setValue(new BigDecimal(currVal));
                cv.setCurrencyCode(currCode);
                value = new Value(cv);
                break;
            }
            case 13: {
                int no_of_days = Integer.parseInt(this.readString());
                DateInfo di = new DateInfo(no_of_days);
                value = new Value(di);
                break;
            }
            case 14: {
                long tmpStmp1 = Long.parseLong(this.readString());
                value = new Value(new Time(tmpStmp1));
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 100: {
                break;
            }
        }
        return value;
    }

    private int readInt() throws ARException {
        if (!this.scanner.hasNextInt()) {
            this.throwError();
        }
        return this.scanner.nextInt();
    }

    private String readString() throws ARException {
        if (!this.scanner.hasNext()) {
            this.throwError();
        }
        return this.scanner.next();
    }

    private long readLong() throws ARException {
        if (!this.scanner.hasNextLong()) {
            this.throwError();
        }
        return this.scanner.nextLong();
    }

    private double readDouble() throws ARException {
        if (!this.scanner.hasNextDouble()) {
            this.throwError();
        }
        return this.scanner.nextDouble();
    }

    private String readLine() throws ARException {
        if (!this.scanner.hasNextLine()) {
            this.throwError();
        }
        return this.scanner.nextLine();
    }

    private void throwError() throws ARException {
        String msg = "Error while decoding.";
        throw new ARException(2, 0, msg);
    }
}

