/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.ARCryptoConstants;
import com.bmc.arsys.arencrypt.AREncEnginePool;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ARPublicPrivateKeyPair
extends ARPPKey {
    private transient KeyPair key_pair;
    private String keyPairProvider;
    private Date mLastCreateTime;
    private int mKeyExpiry;
    private static transient Map<String, KeyPairGenerator> keyPairGeneratorMap = new ConcurrentHashMap<String, KeyPairGenerator>();

    public ARPublicPrivateKeyPair(int algorithm, int expiry) throws AREncryptionException {
        this.mKeyExpiry = expiry;
        this.setAlgorithmParam(algorithm);
    }

    @Override
    public void setAlgorithmParam(int encAlgorithm) throws AREncryptionException {
        super.setAlgorithmParam(encAlgorithm);
        this.setEncType(this.getKeyID());
        this.setKeyPairProvider(ARCryptoConstants.KEYPAIRGENERATOR_PROVIDERS[this.getJCEProviderIdx()][encAlgorithm - 4]);
    }

    @Override
    protected Key getRsaKey() throws AREncryptionException {
        throw new AREncryptionException(9006);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateKeyPair() throws AREncryptionException {
        try {
            KeyPairGenerator key_gen;
            KeyPairGenerator keyPairGenerator = key_gen = this.getGenerator();
            synchronized (keyPairGenerator) {
                RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(this.getModulusBitSize(), RSAKeyGenParameterSpec.F0);
                key_gen.initialize(spec);
                this.key_pair = key_gen.generateKeyPair();
            }
        }
        catch (GeneralSecurityException ge) {
            throw new AREncryptionException(ge, 9006);
        }
        this.mLastCreateTime = new Date(System.currentTimeMillis());
    }

    public PublicKey getPublicKey() throws AREncryptionException {
        if (this.key_pair == null || System.currentTimeMillis() > this.mLastCreateTime.getTime() + (long)this.mKeyExpiry) {
            this.generateKeyPair();
        }
        return this.key_pair.getPublic();
    }

    public PrivateKey getPrivateKey() throws AREncryptionException {
        if (this.key_pair == null || System.currentTimeMillis() > this.mLastCreateTime.getTime() + (long)this.mKeyExpiry) {
            this.generateKeyPair();
        }
        return this.key_pair.getPrivate();
    }

    public Date getLastCreateTime() {
        return this.mLastCreateTime;
    }

    public byte[] getPublicKeyBytes() throws AREncryptionException {
        return ((RSAPublicKey)this.getPublicKey()).getModulus().toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPairGenerator getGenerator() throws AREncryptionException {
        KeyPairGenerator keyGen;
        String instStr = this.toString();
        Map<String, KeyPairGenerator> map = keyPairGeneratorMap;
        synchronized (map) {
            if (keyPairGeneratorMap.containsKey(instStr)) {
                keyGen = keyPairGeneratorMap.get(instStr);
            } else {
                try {
                    keyGen = this.getKeyPairProvider() != null ? KeyPairGenerator.getInstance(this.getEncAlgorithmStr(), this.getKeyPairProvider()) : KeyPairGenerator.getInstance(this.getEncAlgorithmStr());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AREncryptionException(9006);
                }
                catch (NoSuchProviderException e) {
                    throw new AREncryptionException(9010);
                }
                keyPairGeneratorMap.put(instStr, keyGen);
            }
        }
        return keyGen;
    }

    @Override
    protected void setKeyID() {
        this.keyID = "PPKey";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getProvider() != null) {
            sb.append("_").append(this.getProvider());
        }
        if (this.keyPairProvider != null) {
            sb.append("_").append(this.keyPairProvider);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.key_pair).append(this.provider).append(this.keyPairProvider).append(this.mLastCreateTime).append(this.mKeyExpiry).append(this.keyID).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AREncEnginePool)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ARPublicPrivateKeyPair rhs = (ARPublicPrivateKeyPair)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.key_pair, rhs.key_pair).append(this.provider, rhs.provider).append(this.keyPairProvider, rhs.keyPairProvider).append(this.mLastCreateTime, rhs.mLastCreateTime).append(this.mKeyExpiry, rhs.mKeyExpiry).append(this.keyID, rhs.keyID).isEquals();
    }

    private String getKeyPairProvider() {
        return this.keyPairProvider;
    }

    private void setKeyPairProvider(String keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }
}

