/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arcompress;

import com.bmc.arsys.arcompress.Compressable;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.ARFileHandler;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class ARCompressor
implements Compressable {
    public static final int COMPRESSION_HEADER_SIZE = 8;
    protected static final byte[] ARZIP_MAGIC = new byte[]{31, -116};
    protected static final int CURRENT_FORMAT_VERSION = 2;
    private static final int DEFAULT_PACKING_LEVEL = 6;
    private int uncompressedLen;
    private Deflater compressor = new Deflater(6, true);
    private long checksum;

    public ARCompressor() {
        this.cleanCompressor();
    }

    @Override
    public void setInput(byte[] ibytes) {
        if (ibytes == null || ibytes.length == 0) {
            this.cleanCompressor();
            return;
        }
        this.uncompressedLen = ibytes.length;
        this.compressor.setInput(ibytes);
        this.compressor.finish();
        CRC32 check = new CRC32();
        check.update(ibytes);
        this.checksum = check.getValue();
    }

    @Override
    public void setInput(File ifile) throws IOException {
        this.setInput(ARFileHandler.readBytesFromFile(ifile));
    }

    private void cleanCompressor() {
        this.uncompressedLen = 0;
        this.checksum = 0L;
        this.compressor.reset();
    }

    @Override
    public int deflate(ARByteArrayBuffer buf) {
        if (this.uncompressedLen == 0) {
            this.end();
            return 0;
        }
        int outBytesLen = this.getCompressLenEstimation();
        byte[] outBytes = new byte[outBytesLen];
        outBytes[0] = ARZIP_MAGIC[0];
        outBytes[1] = ARZIP_MAGIC[1];
        outBytes[2] = 2;
        outBytes[3] = 0;
        outBytes[4] = new Integer(this.uncompressedLen & 0xFF).byteValue();
        outBytes[5] = new Integer(this.uncompressedLen >> 8 & 0xFF).byteValue();
        outBytes[6] = new Integer(this.uncompressedLen >> 16 & 0xFF).byteValue();
        outBytes[7] = new Integer(this.uncompressedLen >> 24 & 0xFF).byteValue();
        int outputLen = 8;
        outputLen += this.compressor.deflate(outBytes, 8, outBytes.length - 8);
        outBytes[outputLen++] = new Long(this.checksum & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 8 & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 16 & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 24 & 0xFFL).byteValue();
        this.cleanCompressor();
        this.compressor.setInput(new byte[0]);
        this.compressor.end();
        buf.setContentLen(outputLen);
        buf.setBuffer(outBytes);
        outBytes = null;
        if (outputLen < outBytesLen) {
            buf.trimByteArray();
        }
        return outputLen;
    }

    @Override
    public byte[] deflate() {
        if (this.uncompressedLen == 0) {
            this.end();
            return new byte[0];
        }
        byte[] outBytes = new byte[this.getCompressLenEstimation()];
        outBytes[0] = ARZIP_MAGIC[0];
        outBytes[1] = ARZIP_MAGIC[1];
        outBytes[2] = 2;
        outBytes[3] = 0;
        outBytes[4] = new Integer(this.uncompressedLen & 0xFF).byteValue();
        outBytes[5] = new Integer(this.uncompressedLen >> 8 & 0xFF).byteValue();
        outBytes[6] = new Integer(this.uncompressedLen >> 16 & 0xFF).byteValue();
        outBytes[7] = new Integer(this.uncompressedLen >> 24 & 0xFF).byteValue();
        int outputLen = 8;
        outputLen += this.compressor.deflate(outBytes, 8, outBytes.length - 8);
        outBytes[outputLen++] = new Long(this.checksum & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 8 & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 16 & 0xFFL).byteValue();
        outBytes[outputLen++] = new Long(this.checksum >> 24 & 0xFFL).byteValue();
        this.cleanCompressor();
        this.compressor.setInput(new byte[0]);
        this.compressor.end();
        byte[] returnBytes = outputLen < outBytes.length ? StringByteUtil.resizeByteArray(outBytes, outputLen) : outBytes;
        return returnBytes;
    }

    @Override
    public int deflate(File oFile) throws IOException {
        ARByteArrayBuffer buf = new ARByteArrayBuffer();
        int len = this.deflate(buf);
        if (len > 0) {
            ARFileHandler.writeBytesIntoFile(buf, oFile);
        }
        return len;
    }

    public void end() {
        this.compressor.end();
    }

    private int getCompressLenEstimation() {
        return this.uncompressedLen + 8 + (this.uncompressedLen + 8) / 100 + 12;
    }
}

