/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.apitransport.chunking.IARChunkable;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import java.nio.ByteBuffer;

public abstract class ARChunkProcessorBase
implements IARChunkable {
    private boolean compressed = false;
    private boolean chunkingDone;
    private int round = 0;
    private String serverCharSetName;
    protected ByteBuffer totalByteBuf;
    protected byte[] returnedByteArray;
    protected int chunkingRoundRetryCount = 0;
    private static int MAX_RETRY_ALLOWED_PERCHUCK = 2;
    public static String CHUNK_PROCESSOR_KEY = "AR_CHUNK_CALL_PROCESSS_KEY";

    @Override
    public boolean hasNextRound() {
        return !this.isChunkingDone();
    }

    @Override
    public void nextRound() {
        ++this.round;
    }

    @Override
    public boolean isFirstRound() {
        return this.round == 1;
    }

    protected boolean isOnlyOneRound() {
        boolean flag = false;
        if (this.round == 1 && this.chunkingDone) {
            flag = true;
        }
        return flag;
    }

    @Override
    public int getRoundNumber() {
        return this.round;
    }

    @Override
    public void setRoundNumber(int roundNumber) {
        this.round = roundNumber;
    }

    protected String getServerCharSetName() {
        return this.serverCharSetName;
    }

    public void setServerCharSetName(String serverCharSetName) {
        this.serverCharSetName = serverCharSetName;
    }

    protected void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    protected boolean isChunkingDone() {
        return this.chunkingDone;
    }

    protected void setChunkingDone(boolean chunkingDone) {
        this.chunkingDone = chunkingDone;
    }

    protected void setChunkingDone(boolean done, ArRpcControlStruct control) {
        this.setChunkingDone(done);
        ArBoolean doneByte = null;
        doneByte = done ? new ArBoolean(1) : new ArBoolean(0);
        control.setDone(doneByte);
    }

    protected boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void init(Object input) {
    }

    @Override
    public void end() {
    }

    public boolean shouldRetry(int chunkingRound) {
        boolean bReturn = true;
        int lastFailedChunkingRoundNumber = 0;
        Object tmp = ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo().get(CHUNK_PROCESSOR_KEY);
        if (tmp != null && tmp instanceof Integer) {
            lastFailedChunkingRoundNumber = (Integer)tmp;
        }
        if (chunkingRound != lastFailedChunkingRoundNumber) {
            lastFailedChunkingRoundNumber = chunkingRound;
            this.chunkingRoundRetryCount = 0;
        } else {
            ++this.chunkingRoundRetryCount;
        }
        if (this.chunkingRoundRetryCount > MAX_RETRY_ALLOWED_PERCHUCK) {
            bReturn = false;
        }
        if (bReturn) {
            ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo().put(CHUNK_PROCESSOR_KEY, lastFailedChunkingRoundNumber);
        } else {
            ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo().remove(CHUNK_PROCESSOR_KEY);
        }
        return bReturn;
    }
}

