/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class LoggingInfo
implements Serializable {
    private static final long serialVersionUID = -2184816770940532956L;
    private static Logger log = Logger.getLogger(LoggingInfo.class);
    private boolean m_isEnabled;
    private long m_type;
    private long m_writeToFileOrStatus;
    private String m_fileNameWithPath;
    private PrintStream m_printStream;

    public LoggingInfo() {
        this.m_isEnabled = false;
        this.m_type = 0L;
        this.m_writeToFileOrStatus = 0L;
        this.m_fileNameWithPath = null;
    }

    public LoggingInfo(boolean isEnabled, long type, long writeToFileOrStatus, String path) {
        this.m_isEnabled = isEnabled;
        this.m_type = type;
        this.m_writeToFileOrStatus = writeToFileOrStatus;
        this.m_fileNameWithPath = path;
    }

    public void enable(boolean isEnabled) {
        this.m_isEnabled = isEnabled;
    }

    public void setType(long type) {
        this.m_type = type;
    }

    public void setWriteToFileOrStatus(long writeToFileOrStatus) {
        this.m_writeToFileOrStatus = writeToFileOrStatus;
    }

    public void setPath(String fileNameWithPath) {
        this.m_fileNameWithPath = fileNameWithPath;
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public long getType() {
        return this.m_type;
    }

    public long getWriteToFileOrStatus() {
        return this.m_writeToFileOrStatus;
    }

    public String getPath() {
        return this.m_fileNameWithPath;
    }

    public boolean isWorkflowMaskOn() {
        return (this.m_type & 1L) != 0L || (this.m_type & 0x10L) != 0L || (this.m_type & 2L) != 0L;
    }

    public boolean log(String text) {
        if (!this.isEnabled() || !this.isWorkflowMaskOn()) {
            return false;
        }
        if ((this.m_writeToFileOrStatus & 1L) != 0L) {
            try {
                if (this.m_printStream == null) {
                    FileOutputStream fos = new FileOutputStream(this.m_fileNameWithPath);
                    this.m_printStream = new PrintStream(fos);
                }
                this.m_printStream.println(text);
            }
            catch (IOException e) {
                log.error("IOException  while trying to write file", e);
            }
        }
        return (this.m_writeToFileOrStatus & 2L) == 0L;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Is Enabled", this.m_isEnabled).append("Type", this.m_type).append("Write To File Or Status", this.m_writeToFileOrStatus).append("File Name With Path", this.m_fileNameWithPath).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_isEnabled).append(this.m_type).append(this.m_writeToFileOrStatus).append(this.m_fileNameWithPath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LoggingInfo rhs = (LoggingInfo)obj;
        return new EqualsBuilder().append(this.m_isEnabled, rhs.m_isEnabled).append(this.m_type, rhs.m_type).append(this.m_writeToFileOrStatus, rhs.m_writeToFileOrStatus).append(this.m_fileNameWithPath, rhs.m_fileNameWithPath).isEquals();
    }
}

