/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5;

import com.kaazing.gateway.client.html5.ByteBuffer;
import java.util.logging.Logger;

public class Base64Util {
    private static final String CLASS_NAME = Base64Util.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final byte[] INDEXED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static final byte PADDING_BYTE = 61;

    @Deprecated
    private Base64Util() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    public static String encode(ByteBuffer decoded) {
        int byte1;
        int byte0;
        LOG.entering(CLASS_NAME, "encode", decoded);
        int decodedSize = decoded.remaining();
        int effectiveDecodedSize = (decodedSize + 2) / 3 * 3;
        int decodedFragmentSize = decodedSize % 3;
        int encodedArraySize = effectiveDecodedSize / 3 * 4;
        byte[] encodedArray = new byte[encodedArraySize];
        int encodedArrayPosition = 0;
        byte[] decodedArray = decoded.array();
        int decodedArrayOffset = decoded.arrayOffset();
        int decodedArrayPosition = decodedArrayOffset + decoded.position();
        int decodedArrayLimit = decodedArrayOffset + decoded.limit() - decodedFragmentSize;
        while (decodedArrayPosition < decodedArrayLimit) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
            int byte2 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
            encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C | byte2 >> 6 & 3];
            encodedArray[encodedArrayPosition++] = INDEXED[byte2 & 0x3F];
        }
        if (decodedFragmentSize == 1) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30];
            encodedArray[encodedArrayPosition++] = 61;
            encodedArray[encodedArrayPosition++] = 61;
        } else if (decodedFragmentSize == 2) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
            encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C];
            encodedArray[encodedArrayPosition++] = 61;
        }
        return new String(encodedArray);
    }

    public static ByteBuffer decode(String encoded) {
        LOG.entering(CLASS_NAME, "decode", encoded);
        if (encoded == null) {
            return null;
        }
        int length = encoded.length();
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 Encoded String");
        }
        byte[] encodedArray = encoded.getBytes();
        byte[] decodedArray = new byte[length / 4 * 3];
        int decodedArrayOffset = 0;
        int i = 0;
        while (i < length) {
            byte char0 = encodedArray[i++];
            byte char1 = encodedArray[i++];
            byte char2 = encodedArray[i++];
            byte char3 = encodedArray[i++];
            int byte0 = Base64Util.mapped(char0);
            int byte1 = Base64Util.mapped(char1);
            int byte2 = Base64Util.mapped(char2);
            int byte3 = Base64Util.mapped(char3);
            decodedArray[decodedArrayOffset++] = (byte)(byte0 << 2 & 0xFC | byte1 >> 4 & 3);
            if (char2 == 61) continue;
            decodedArray[decodedArrayOffset++] = (byte)(byte1 << 4 & 0xF0 | byte2 >> 2 & 0xF);
            if (char3 == 61) continue;
            decodedArray[decodedArrayOffset++] = (byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F);
        }
        return ByteBuffer.wrap(decodedArray, 0, decodedArrayOffset);
    }

    private static int mapped(int ch) {
        if ((ch & 0x40) != 0) {
            if ((ch & 0x20) != 0) {
                assert (ch >= 97);
                assert (ch <= 122);
                return ch - 71;
            }
            assert (ch >= 65);
            assert (ch <= 90);
            return ch - 65;
        }
        if ((ch & 0x20) != 0) {
            if ((ch & 0x10) != 0) {
                if ((ch & 8) != 0 && (ch & 4) != 0) {
                    assert (ch == 61);
                    return 0;
                }
                assert (ch >= 48);
                assert (ch <= 57);
                return ch + 4;
            }
            if ((ch & 4) != 0) {
                assert (ch == 47);
                return 63;
            }
            assert (ch == 43);
            return 62;
        }
        LOG.warning("Invalid BASE64 string");
        throw new IllegalArgumentException("Invalid BASE64 string");
    }
}

