/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.log4j.Logger;

class ARExternalProcessUtil
extends Thread {
    private static Logger log = Logger.getLogger(ARExternalProcessUtil.class);
    private static String osname = System.getProperty("os.name");
    private static boolean SUPPORTED = osname.startsWith("Win");
    private static String envVar = "arserver_on_timeout";
    private static String envValue = "1";
    private String _serverName;
    private String[] cmdWin;
    private String[] cmdLinuxSolaris;

    ARExternalProcessUtil(String serverName) {
        this._serverName = serverName;
        this.cmdWin = new String[]{"cmd", "/c", "staf", this._serverName, "PROCESS", "START", "SHELL", "COMMAND", "c:\\work\\rundump.bat"};
        this.cmdLinuxSolaris = new String[]{"cmd", "/c", "staf", this._serverName, "PROCESS", "START", "SHELL", "COMMAND", "/usr/local/rundump.sh"};
    }

    static void runProcess(String serverName) {
        String env;
        if (SUPPORTED && (env = System.getenv(envVar)) != null && env.length() > 0 && envValue.equals(env.trim().toString())) {
            ARExternalProcessUtil util = new ARExternalProcessUtil(serverName);
            util.setDaemon(true);
            util.start();
        }
    }

    @Override
    public void run() {
        this.invokeProcessOnServer(this.cmdWin);
        this.invokeProcessOnServer(this.cmdLinuxSolaris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeProcessOnServer(String[] command) {
        Process p = null;
        BufferedReader in = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Executing invokeProcessOnServer with command= " + Arrays.deepToString(command)));
            }
            p = Runtime.getRuntime().exec(command);
            p.waitFor();
            if (log.isTraceEnabled()) {
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    log.trace((Object)line);
                }
            }
        }
        catch (Throwable e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("exceptiion on staf to server " + this._serverName), e);
            }
        }
        finally {
            if (p != null) {
                p.destroy();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

