/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.EncoderOutput;
import com.kaazing.gateway.client.html5.impl.bridge.HttpRequestBridgeHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandlerFactory;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamChannel;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandler;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedEncoder;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedEncoderImpl;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

class UpstreamHandlerImpl
implements UpstreamHandler {
    static final String CLASS_NAME = UpstreamHandlerImpl.class.getName();
    static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static UpstreamHandlerFactory FACTORY = new UpstreamHandlerFactory(){

        @Override
        public UpstreamHandler createUpstreamHandler() {
            return new UpstreamHandlerImpl();
        }
    };
    static final HttpRequestHandlerFactory UPSTREAM_HANDLER_FACTORY = new HttpRequestHandlerFactory(){

        @Override
        public HttpRequestHandler createHandler() {
            return new HttpRequestBridgeHandler();
        }
    };
    private static final byte WSF_COMMAND_FRAME_START = 1;
    private static final byte WSF_COMMAND_FRAME_END = -1;
    private static final byte[] RECONNECT_EVENT_BYTES = new byte[]{1, 48, 49, -1};
    private static final byte[] CLOSE_EVENT_BYTES = new byte[]{1, 48, 50, -1};
    WebSocketEmulatedEncoder<UpstreamChannel> encoder = new WebSocketEmulatedEncoderImpl<UpstreamChannel>();
    private EncoderOutput<UpstreamChannel> out = new EncoderOutput<UpstreamChannel>(){

        @Override
        public void write(UpstreamChannel channel, ByteBuffer buf) {
            UpstreamHandlerImpl.this.processMessageWrite(channel, buf);
        }
    };
    HttpRequestHandler nextHandler;
    UpstreamHandlerListener listener;

    UpstreamHandlerImpl() {
        this.setNextHandler(UPSTREAM_HANDLER_FACTORY.createHandler());
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        this.nextHandler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                ConcurrentLinkedQueue<ByteBuffer> sendQueue = channel.sendQueue;
                ByteBuffer payload = ByteBuffer.allocate(1024);
                while (!sendQueue.isEmpty()) {
                    payload.putBuffer(sendQueue.poll());
                }
                payload.putBytes(RECONNECT_EVENT_BYTES);
                payload.flip();
                UpstreamHandlerImpl.this.nextHandler.processSend(request, payload);
            }

            @Override
            public void requestOpened(HttpRequest request) {
            }

            @Override
            public void requestProgressed(HttpRequest request, ByteBuffer payload) {
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                channel.sendInFlight.set(false);
                if (!channel.sendQueue.isEmpty()) {
                    UpstreamHandlerImpl.this.flushIfNecessary(channel);
                }
            }

            @Override
            public void errorOccurred(HttpRequest request) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                channel.sendInFlight.set(false);
                UpstreamHandlerImpl.this.listener.upstreamFailed(channel);
            }

            @Override
            public void requestAborted(HttpRequest request) {
            }

            @Override
            public void requestClosed(HttpRequest request) {
            }
        });
    }

    @Override
    public void processOpen(UpstreamChannel channel) {
    }

    @Override
    public void processTextMessage(UpstreamChannel channel, String message) {
        LOG.entering(CLASS_NAME, "processsTextMessage", message);
        this.encoder.encodeTextMessage(channel, message, this.out);
    }

    @Override
    public void processBinaryMessage(UpstreamChannel channel, ByteBuffer message) {
        LOG.entering(CLASS_NAME, "processsBinaryMessage", message);
        this.encoder.encodeBinaryMessage(channel, message, this.out);
    }

    private void processMessageWrite(UpstreamChannel channel, ByteBuffer payload) {
        LOG.entering(CLASS_NAME, "processMessageWrite", payload);
        channel.sendQueue.offer(payload);
        this.flushIfNecessary(channel);
    }

    private void flushIfNecessary(UpstreamChannel channel) {
        LOG.entering(CLASS_NAME, "flushIfNecessary");
        if (channel.sendInFlight.compareAndSet(false, true)) {
            HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.POST, channel.location, false);
            request.setHeader("Content-Type", "application/octet-stream");
            if (channel.cookie != null) {
                request.setHeader("Cookie", channel.cookie);
            }
            request.parent = channel;
            channel.request = request;
            this.nextHandler.processOpen(request);
        }
    }

    @Override
    public void processClose(UpstreamChannel channel) {
        this.processMessageWrite(channel, ByteBuffer.wrap(CLOSE_EVENT_BYTES));
    }

    @Override
    public void setListener(UpstreamHandlerListener listener) {
        this.listener = listener;
    }
}

