/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.type.classreading;

import com.bmc.thirdparty.org.springframework.asm.ClassReader;
import com.bmc.thirdparty.org.springframework.core.NestedIOException;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.core.type.ClassMetadata;
import com.bmc.thirdparty.org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import com.bmc.thirdparty.org.springframework.core.type.classreading.MetadataReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class SimpleMetadataReader
implements MetadataReader {
    private final Resource resource;
    private final ClassMetadata classMetadata;
    private final AnnotationMetadata annotationMetadata;

    SimpleMetadataReader(Resource resource, ClassLoader classLoader) throws IOException {
        ClassReader classReader;
        BufferedInputStream is = new BufferedInputStream(resource.getInputStream());
        try {
            classReader = new ClassReader(is);
        }
        catch (IllegalArgumentException ex) {
            throw new NestedIOException("ASM ClassReader failed to parse class file - probably due to a new Java class file version that isn't supported yet: " + resource, ex);
        }
        finally {
            ((InputStream)is).close();
        }
        AnnotationMetadataReadingVisitor visitor = new AnnotationMetadataReadingVisitor(classLoader);
        classReader.accept(visitor, 2);
        this.annotationMetadata = visitor;
        this.classMetadata = visitor;
        this.resource = resource;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

