/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.util.ArrayCentralConfig;
import java.util.List;
import org.apache.log4j.Logger;

public class CentralConfigFactory {
    private static final Logger LOGGER = Logger.getLogger(CentralConfigFactory.class);
    private static final String DEFAULT_COMPONENT_FORM = "AR System Configuration Component";
    private static final String DEFAULT_JOIN_FORM = "AR System Configuration Component Setting";
    private static final int[] COMPONENT_FORM_FIELDS = new int[]{179, 3200, 3201, 3209, 3202, 3208};
    private static final int[] JOIN_FORM_FIELDS = new int[]{3200, 3201, 3202, 3204, 3205, 3206, 3207};
    private final ARServerUser context;
    private final String componentFormName;
    private final String joinFormName;

    public static CentralConfigFactory newInstance(ARServerUser context) {
        return new CentralConfigFactory(context);
    }

    private CentralConfigFactory(ARServerUser context) {
        this.context = context;
        this.componentFormName = this.getSystemFormTableName(FormType.REGULAR, COMPONENT_FORM_FIELDS, DEFAULT_COMPONENT_FORM);
        this.joinFormName = this.getSystemFormTableName(FormType.JOIN, JOIN_FORM_FIELDS, DEFAULT_JOIN_FORM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSystemFormTableName(FormType formType, int[] fields, String defaultName) {
        String formName = defaultName;
        String origOverlayGroup = this.context.getOverlayGroup();
        try {
            this.context.setOverlayGroup("-1");
            List<String> formNames = this.context.getListForm(0L, formType.toInt(), null, fields);
            if (formNames == null || formNames.isEmpty()) {
                LOGGER.debug("Searching for the name of a system form returned no results, defaulting to: " + defaultName);
            } else {
                formName = formNames.get(0);
                LOGGER.debug("Searching for the name of a system form succeeded, using: " + formName);
            }
        }
        catch (ARException e) {
            LOGGER.warn("Error while trying to get the name of a system form, defaulting to: " + defaultName, e);
        }
        finally {
            this.context.setOverlayGroup(origOverlayGroup);
        }
        return formName;
    }

    public String getComponentFormName() {
        return this.componentFormName;
    }

    public String getJoinFormName() {
        return this.joinFormName;
    }

    public ArrayCentralConfig newArrayCentralConfig() {
        return new ArrayCentralConfig(this.context, this.componentFormName, this.joinFormName);
    }
}

