/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.archgidutil;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.demo.archgidutil.ArchgidCommandLineUtil;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class ArchgidInteractiveHandler
extends ArchgidCommandLineUtil {
    private final Logger LOGGER = Logger.getLogger(ArchgidInteractiveHandler.class);
    private int oldId;
    private int newId;
    private String formName;
    private int listFormId;
    private int listFieldId;
    private static final String BLANK = "";

    protected void handleInteractiveChangeId() throws ARException {
        Scanner console = new Scanner(System.in);
        try {
            this.LOGGER.info("\nEnter User name:");
            this.userName = console.next().trim();
            this.LOGGER.info("\nEnter password:");
            this.password = console.next().trim();
            if (this.password.equalsIgnoreCase("-")) {
                this.password = BLANK;
            }
            this.LOGGER.info("\nEnter authentication string:");
            this.authenticationString = console.next();
            if (this.authenticationString.equalsIgnoreCase("-")) {
                this.authenticationString = BLANK;
            }
            this.LOGGER.info("\n\nEnter server name:");
            this.serverName = console.next().trim();
            this.LOGGER.info("\nEnter tcp port if needed:");
            this.tcpPort = console.next().trim();
            if (this.tcpPort.equalsIgnoreCase("-")) {
                this.tcpPort = BLANK;
            }
            this.parseAndVerifyOperationTypeInteractive(console);
            this.initServer();
            this.parseAndVerifyFormIdInteractive(console);
            this.parseAndVerifyFieldIdInteractive(console);
        }
        finally {
            if (null != console) {
                console.close();
            }
        }
    }

    private void parseAndVerifyFieldIdInteractive(Scanner console) {
        List<String> listFields = this.showSortedAvailableFields();
        if (this.operationType.equals("1")) {
            this.LOGGER.info("Enter menu id of field to update: ");
        } else if (this.operationType.equals("2")) {
            this.LOGGER.info("Enter id of form containing field to update: ");
        } else {
            this.LOGGER.info("Enter id of form containing VUI to update: ");
        }
        this.listFormId = Integer.parseInt(console.next().trim());
        if (this.listFormId <= listFields.size()) {
            this.oldId = Integer.parseInt(listFields.get(this.listFieldId - 1));
            this.LOGGER.info("  **** Field Chosen to Update *** " + this.oldId);
        } else {
            this.LOGGER.info("  **** No Field matches ID list from command line\n");
        }
    }

    private List<String> showSortedAvailableFields() {
        return null;
    }

    private void parseAndVerifyOperationTypeInteractive(Scanner console) {
        this.LOGGER.info("\n\ntype of ID to change:\n(1 - Form \n(2 - Field \n(3 - VUI \n(4 - Group");
        this.operationType = console.next();
        if (this.operationType.equals("1") || this.operationType.equals("2") || this.operationType.equals("3") || this.operationType.equals("4")) {
            return;
        }
        this.operationType = null;
        this.LOGGER.info("**** Illegal operation, must be :\n(1 - Form \n(2 - Field \n(3 - VUI \n(4 - Group");
        this.parseAndVerifyOperationTypeInteractive(console);
    }

    private void parseAndVerifyFormIdInteractive(Scanner console) throws ARException {
        List<String> listForms = this.showSortedAvailableForms();
        if (this.operationType.equals("1")) {
            this.LOGGER.info("Enter id of form to update: ");
        } else if (this.operationType.equals("2")) {
            this.LOGGER.info("Enter id of form containing field to update: ");
        } else {
            this.LOGGER.info("Enter id of form containing VUI to update: ");
        }
        this.listFormId = Integer.parseInt(console.next().trim());
        if (this.listFormId <= listForms.size()) {
            this.formName = listForms.get(this.listFormId - 1);
            this.LOGGER.info("  **** Form Chosen to Update *** " + this.formName);
        } else {
            this.LOGGER.info("  **** No form matches ID list from command line\n");
        }
    }

    private List<String> showSortedAvailableForms() throws ARException {
        List<String> listForm = this.primaryServer.getListForm();
        Collections.sort(listForm);
        if (listForm != null && !listForm.isEmpty()) {
            int i = 0;
            this.LOGGER.info("** Form List from Server **");
            for (String form : listForm) {
                this.LOGGER.info(++i + " : " + form);
            }
        } else {
            this.LOGGER.error("** Did not get any form list from server **");
        }
        return listForm;
    }
}

