/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.PasswordHashing;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;

public class Sha256
implements PasswordHashing {
    public static final String PREFIX = "a$";
    public static final int LENGTH_BYTES = 16;

    @Override
    public String hashPasswordForStorage(String password, Charset charSet) {
        if (charSet == null) {
            charSet = StandardCharsets.UTF_8;
        }
        byte[] salt = this.getSalt();
        byte[] passwordBytes = password.getBytes(charSet);
        byte[] hashedBytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(salt);
            md.update(passwordBytes);
            hashedBytes = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
        String base64Salt = encoder.encodeToString(salt);
        String base64Hash = encoder.encodeToString(hashedBytes);
        return PREFIX + base64Salt + base64Hash;
    }

    @Override
    public boolean isHashedBy(String storedPassword) {
        return storedPassword.startsWith(PREFIX);
    }

    @Override
    public boolean isPasswordValid(String suppliedPassword, String storedPassword) {
        byte[] passwordBytes = suppliedPassword.getBytes(StandardCharsets.UTF_8);
        Base64.Decoder decoder = Base64.getDecoder();
        String base64Salt = storedPassword.substring(2, 24);
        byte[] salt = decoder.decode(base64Salt);
        byte[] hashedBytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(salt);
            md.update(passwordBytes);
            hashedBytes = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        String base64Hash = storedPassword.substring(24);
        byte[] suppliedHashBytes = decoder.decode(base64Hash);
        boolean result = Arrays.equals(hashedBytes, suppliedHashBytes);
        return result;
    }

    @Override
    public byte[] getSalt() {
        SecureRandom rand = new SecureRandom();
        byte[] newSalt = new byte[16];
        rand.nextBytes(newSalt);
        return newSalt;
    }
}

