/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;

public final class JCECheck {
    private static Logger logger = Logger.getLogger(JCECheck.class);
    private static boolean printedOnce;

    public static void printJCE(boolean consolePrint, boolean repeatePrint) {
        Provider[] providers;
        if (!consolePrint && !logger.isDebugEnabled() && !repeatePrint && printedOnce) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("java.vendor : " + System.getProperty("java.vendor")).append("\n");
        msg.append("JCE Provider: ");
        logger.debug(msg.toString());
        if (consolePrint) {
            System.out.println(msg.toString());
        }
        for (Provider provider : providers = Security.getProviders()) {
            msg = new StringBuilder();
            msg.append("<><><>").append(provider).append("<><><>");
            logger.debug(msg.toString());
            if (consolePrint) {
                System.out.println(msg.toString());
            }
            for (Provider.Service service : provider.getServices()) {
                String msg1 = service.toString();
                logger.debug(msg1.trim());
                if (!consolePrint) continue;
                System.out.println(msg1);
            }
        }
        printedOnce = true;
    }

    public static void main(String[] args) {
        JCECheck.printJCE(true, true);
    }
}

