/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.apitransport.session.ARRpcKeyExchangeBase;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcClientStubBase;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPublicKey;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArGetServerInfo12In;
import com.bmc.arsys.arrpc.ArGetServerInfo12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12In;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12In;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12Out;
import com.bmc.arsys.arrpc.ArRandomBytes;
import com.bmc.arsys.arrpc.ArServerInfoList;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.arrpc.xdr.DecoratedArRpcXdrOut;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

class ARKeyExchanger
extends ARRpcKeyExchangeBase {
    private transient ApiRpcClientStubBase _rpcClient;
    private transient int _encryptPolicy;
    protected transient ARPublicKey _svrPublicKey;
    private static Logger log = Logger.getLogger(ARKeyExchanger.class);

    protected ARKeyExchanger(ApiRpcClientStubBase rpcClient) {
        this._rpcClient = rpcClient;
        this._encryptPolicy = 2;
        this._svrPublicKey = new ARPublicKey();
    }

    @Override
    protected void keyExchangeHandler() throws OncRpcException, IOException, ARException, AREncryptionException {
        ArRpcControlStruct control = this.createRpcControlStruct();
        this.getEncryptInfo(control);
        if (this.encryptionIsAllowed()) {
            this._rpcClient.getArRpcCallContext().setEncryptAPICalls(true);
            try {
                this.keyExchange(control);
            }
            catch (AREncryptionException e) {
                if (this._encryptPolicy == 0 && (e.getErrorNum() == 9010 || e.getErrorNum() == 9011)) {
                    this._rpcClient.getArRpcCallContext().setEncryptAPICalls(false);
                    String serverName = "";
                    ARServerContext svrCtx = this._rpcClient.getArRpcCallContext().getServerContext();
                    if (svrCtx != null) {
                        serverName = svrCtx.getServer();
                    }
                    log.info("Error " + e.getErrorNum() + " turns off encrytion on the connection since Encrypt-Security-Policy is optional on server " + serverName);
                }
                throw e;
            }
        }
    }

    private void getEncryptInfo(ArRpcControlStruct control) throws OncRpcException, ARException, AREncryptionException {
        ArRpcXdrIn in = this.createServerInfoIn(control);
        ArRpcXdrOut out = this.createServerInfoOut();
        ArRpcCallContext callCtx = this._rpcClient.getArRpcCallContext();
        callCtx.setSkipXdrEncryption(true);
        DecoratedArRpcXdrOut dout = new DecoratedArRpcXdrOut(out);
        this._rpcClient.arCall(this.getProcNumEncryptInfo(), in, dout);
        out = dout.getTheObject();
        callCtx.setSkipXdrEncryption(false);
        ApiRpcClientStubBase.verifyStatus(out);
        String serverName = "";
        ARServerContext svrCtx = callCtx.getServerContext();
        if (svrCtx != null) {
            serverName = svrCtx.getServer();
        }
        ArServerInfoList serverInfoListOut = this.getServerInfoList(out);
        if (serverInfoListOut.value.length > 0 && serverInfoListOut.value[0].operation == 133) {
            this._encryptPolicy = serverInfoListOut.value[0].value.intVal;
        }
        if (serverInfoListOut.value.length > 1 && serverInfoListOut.value[1].operation == 129) {
            this._svrPublicKey.setKey(serverInfoListOut.value[1].value.byteListVal.bytes);
        }
        if (serverInfoListOut.value.length > 2 && serverInfoListOut.value[2].operation == 132) {
            callCtx.getEncCtx().setDataEncryptAlg(serverInfoListOut.value[2].value.intVal, this._encryptPolicy, serverName);
        }
        if (this._encryptPolicy != 2 && serverInfoListOut.value.length > 3 && serverInfoListOut.value[3].operation == 168) {
            this._svrPublicKey.setAlgorithmParam(serverInfoListOut.value[3].value.intVal);
        }
    }

    protected void keyExchange(ArRpcControlStruct control) throws ARException, AREncryptionException, OncRpcException, IOException {
        ArRpcCallContext callCtx = this._rpcClient.getArRpcCallContext();
        callCtx.setSkipXdrEncryption(true);
        this.keyExchangePrepare();
        this.keyExchangeBegin(control);
        this.keyExchangeFinal(control);
        callCtx.setSkipXdrEncryption(false);
    }

    protected void keyExchangePrepare() throws AREncryptionException {
        AREncryptAPISessionNodeBase encCtx = this._rpcClient.getArRpcCallContext().getEncCtx();
        encCtx.setClientRandBytes(StringByteUtil.generateRandomBytes(20));
        encCtx.setPreMasterKey(StringByteUtil.generateRandomBytes(40));
    }

    protected boolean encryptionIsAllowed() {
        boolean flag = true;
        flag = this._encryptPolicy != 2;
        ARServerContext ctx = this._rpcClient.getArRpcCallContext().getServerContext();
        if (ctx != null) {
            ctx.setEncryptionEnabled(flag);
        }
        return flag;
    }

    protected void keyExchangeBegin(ArRpcControlStruct control) throws ARException, OncRpcException {
        AREncryptAPISessionNodeBase encCtx = this._rpcClient.getArRpcCallContext().getEncCtx();
        ArRpcXdrIn in = this.createKeyExchangeBeginIn(control, encCtx);
        ArRpcXdrOut out = this.createKeyExchangeBeginOut();
        DecoratedArRpcXdrOut dout = new DecoratedArRpcXdrOut(out);
        this._rpcClient.arCall(this.getProcNumKeyExchangeBegin(), in, dout);
        out = dout.getTheObject();
        ApiRpcClientStubBase.verifyStatus(out);
        this.setInEncCtx(encCtx, out);
    }

    protected void keyExchangeFinal(ArRpcControlStruct control) throws AREncryptionException, ARException, OncRpcException, IOException {
        AREncryptAPISessionNodeBase encCtx = this._rpcClient.getArRpcCallContext().getEncCtx();
        ArRpcXdrIn in = this.createKeyExchangeFinalIn(control, encCtx);
        ArRpcXdrOut out = this.createKeyExchangeFinalOut();
        DecoratedArRpcXdrOut dout = new DecoratedArRpcXdrOut(out);
        this._rpcClient.arCall(this.getProcNumKeyExchangeFinal(), in, dout);
        out = dout.getTheObject();
        ApiRpcClientStubBase.verifyStatus(out);
        encCtx.getClintKeyInfo().genDataEncKeys(encCtx.getDataEncRandomBytesObj());
        encCtx.resetDataEncRandomBytesObj();
        int sessionId = this.unxdrAndDecryptSessionId(encCtx.getClintKeyInfo().getSvrDataKey(), this.getEncSessionId(out));
        log.debug("compare to org sessionId = " + encCtx.getClintKeyInfo().getSessionId());
        if (encCtx.getClintKeyInfo().getSessionId() != sessionId) {
            throw new ARException(2, 9002);
        }
        encCtx.getClintKeyInfo().setSessionId(sessionId);
        encCtx.setSessionId(sessionId);
    }

    protected ArRpcControlStruct createRpcControlStruct() {
        return new ArControlStruct12();
    }

    protected ArRpcXdrOut createServerInfoOut() {
        return new ArGetServerInfo12Out();
    }

    protected ArServerInfoList getServerInfoList(ArRpcXdrOut out) {
        return ((ArGetServerInfo12Out)out).getServerInfoList();
    }

    protected ArRpcXdrIn createServerInfoIn(ArRpcControlStruct control) {
        ArGetServerInfo12In in = new ArGetServerInfo12In();
        in.setControl((ArControlStruct12)control);
        in.requestList.value = new int[4];
        in.requestList.value[0] = 133;
        in.requestList.value[1] = 129;
        in.requestList.value[2] = 132;
        in.requestList.value[3] = 168;
        return in;
    }

    protected void setInEncCtx(AREncryptAPISessionNodeBase encCtx, ArRpcXdrOut out) {
        encCtx.setServerRandBytes(((ArKeyExchangeBegin12Out)out).serverRandBytes.value);
        encCtx.getClintKeyInfo().setSessionId(((ArKeyExchangeBegin12Out)out).sessionId);
    }

    protected ArRpcXdrIn createKeyExchangeBeginIn(ArRpcControlStruct control, AREncryptAPISessionNodeBase encCtx) {
        ArKeyExchangeBegin12In in = new ArKeyExchangeBegin12In();
        in.setControl((ArControlStruct12)control);
        in.clientRandBytes = new ArRandomBytes(encCtx.getClientRandBytes());
        return in;
    }

    protected ArRpcXdrOut createKeyExchangeBeginOut() {
        return new ArKeyExchangeBegin12Out();
    }

    protected byte[] getEncSessionId(ArRpcXdrOut out) {
        return ((ArKeyExchangeFinal12Out)out).getEncSessionId();
    }

    protected ArRpcXdrOut createKeyExchangeFinalOut() {
        return new ArKeyExchangeFinal12Out();
    }

    protected ArRpcXdrIn createKeyExchangeFinalIn(ArRpcControlStruct control, AREncryptAPISessionNodeBase encCtx) throws AREncryptionException, ARException, OncRpcException, IOException {
        ArKeyExchangeFinal12In in = new ArKeyExchangeFinal12In();
        in.control = (ArControlStruct12)control;
        in.sessionId = encCtx.getClintKeyInfo().getSessionId();
        log.debug("sessionID before encryption = " + in.sessionId);
        byte[] encXdrPreMasterKey = this.xdrAndEncrypPreMasterKey(this._svrPublicKey, encCtx.getPreMasterKey());
        in.setEncPreMasterKey(encXdrPreMasterKey);
        return in;
    }

    protected int getProcNumEncryptInfo() {
        return 97;
    }

    protected int getProcNumKeyExchangeBegin() {
        return 95;
    }

    protected int getProcNumKeyExchangeFinal() {
        return 96;
    }
}

