/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ApiProxyManagerTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(ApiProxyManagerTask.class);
    private String name = "ApiProxyManagerTaskTimer";
    private String last_time = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss").format(new Date());
    Timer cleanUpTimer = new Timer("proxyCleanUpTimer", true);
    static long cnt = 0L;

    ApiProxyManagerTask() {
    }

    @Override
    public void run() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        String current_time = format.format(date);
        if (ApiProxyManager.currentManager != null) {
            ((ApiProxyManager)ApiProxyManager.currentManager).loadBalanceForInactiveProxyInPool();
            ((ApiProxyManager)ApiProxyManager.currentManager).ageOutIdlePools();
            ((ApiProxyManager)ApiProxyManager.currentManager).recycleConnectionForInactiveARServerUser();
            if (!((ApiProxyManager)ApiProxyManager.currentManager).isCmtPoolEmpty()) {
                ((ApiProxyManager)ApiProxyManager.currentManager).cleanUpTimeoutCMTFromCMTPool();
            }
        }
        this.last_time = current_time;
    }

    static long caculateTimePeriod() {
        long initValue;
        long interval = initValue = 0L;
        if (ApiProxyManager.getConnectionTimeoutMilliSec() > 0L && ApiProxyManager.getConnectionLifespanMilliSec() > 0L) {
            interval = Math.min(ApiProxyManager.getConnectionTimeoutMilliSec(), ApiProxyManager.getConnectionLifespanMilliSec());
        } else if (ApiProxyManager.getConnectionTimeoutMilliSec() > 0L) {
            interval = ApiProxyManager.getConnectionTimeoutMilliSec();
        } else if (ApiProxyManager.getConnectionLifespanMilliSec() > 0L) {
            interval = ApiProxyManager.getConnectionLifespanMilliSec();
        }
        if (ApiProxyManager.getServerCmtTimeout() > 0) {
            long cmtTimeout = 60000L;
            if (interval == 0L || cmtTimeout < interval) {
                interval = cmtTimeout;
            }
        }
        return interval;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.cleanUpTimer != null) {
                this.cleanUpTimer.cancel();
                this.cleanUpTimer = null;
                this.cancel();
            }
        }
        finally {
            super.finalize();
        }
    }
}

