/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkReceiveProcessor;
import com.bmc.arsys.arrpc.ArGetSupportFile12Out;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ARChunkGetSupportFile
extends ARChunkReceiveProcessor {
    private static Logger logger = Logger.getLogger(ARChunkGetSupportFile.class);
    private String fileNamePath;
    private FileOutputStream outputStream = null;

    @Override
    public void init(Object input) {
        this.fileNamePath = (String)input;
        logger.debug("Support File output path is " + this.fileNamePath);
    }

    @Override
    public void retrieveChunkingData(ArRpcXdrOut out) throws ARException {
        super.retrieveChunkingData(out);
        byte[] outBytes = ((ArGetSupportFile12Out)out).getOutputBuf();
        if (outBytes == null || outBytes.length == 0) {
            return;
        }
        try {
            if (this.outputStream == null) {
                this.outputStream = new FileOutputStream(this.fileNamePath);
            }
            this.outputStream.write(outBytes);
        }
        catch (IOException e) {
            throw new ARException(2, 301, e.getLocalizedMessage());
        }
        finally {
            this.end();
        }
    }

    @Override
    public void end() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException e) {
                logger.info("Cannot close the input stream for the support file " + this.fileNamePath);
            }
        }
    }
}

