/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class QueryBase
implements Cloneable {
    private List<IQuerySource> sources;
    private List<QueryFormField> fromFields;
    private QualifierInfo qualifier;
    private List<QualifierInfo> having;
    private List<QueryFormField> groupBy;

    public List<IQuerySource> getFromSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<IQuerySource>();
        }
        return this.sources;
    }

    public void setFromSources(List<IQuerySource> sources) {
        this.sources = sources;
    }

    public List<QueryFormField> getFromFields() {
        if (this.fromFields == null) {
            this.fromFields = new ArrayList<QueryFormField>();
        }
        return this.fromFields;
    }

    public void setFromFields(List<QueryFormField> fromFields) {
        this.fromFields = fromFields;
    }

    public QualifierInfo getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(QualifierInfo qualifier) {
        this.qualifier = qualifier;
    }

    public boolean addFromSource(IQuerySource source) {
        return this.getFromSources().add(source);
    }

    public boolean addFromField(QueryFormField field) {
        return this.getFromFields().add(field);
    }

    public boolean addFromField(int fieldId, int funcId, IQuerySource sourceForm) {
        return this.getFromFields().add(new QueryFormField(fieldId, funcId, sourceForm));
    }

    public boolean addFromField(int fieldId, IQuerySource sourceForm) {
        return this.getFromFields().add(new QueryFormField(fieldId, sourceForm));
    }

    public void setHaving(List<QualifierInfo> having) {
        this.having = having;
    }

    public void setGroupBy(List<QueryFormField> groupBy) {
        this.groupBy = groupBy;
    }

    public List<QualifierInfo> getHavingList() {
        return this.having;
    }

    public QualifierInfo getHaving() {
        if (this.having == null) {
            return null;
        }
        return this.having.get(0);
    }

    public List<QueryFormField> getGroupBy() {
        return this.groupBy;
    }

    public boolean addHaving(QualifierInfo having) {
        if (having != null) {
            if (this.having == null) {
                this.having = new ArrayList<QualifierInfo>();
            }
            return this.having.add(having);
        }
        return false;
    }

    public boolean addGroupBy(QueryFormField groupBy) {
        if (groupBy != null) {
            if (this.groupBy == null) {
                this.groupBy = new ArrayList<QueryFormField>();
            }
            return this.groupBy.add(groupBy);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        QueryBase obj = (QueryBase)super.clone();
        if (this.fromFields != null) {
            ArrayList<QueryFormField> fromFieldsCloned = new ArrayList<QueryFormField>();
            for (i = 0; i < this.fromFields.size(); ++i) {
                QueryFormField field = this.fromFields.get(i);
                if (field != null) {
                    fromFieldsCloned.add((QueryFormField)field.clone());
                    continue;
                }
                fromFieldsCloned.add(null);
            }
            obj.fromFields = fromFieldsCloned;
        }
        if (this.sources != null) {
            ArrayList<IQuerySource> sourcesCloned = new ArrayList<IQuerySource>();
            for (i = 0; i < this.sources.size(); ++i) {
                IQuerySource source = this.sources.get(i);
                if (source != null) {
                    sourcesCloned.add((IQuerySource)source.clone());
                    continue;
                }
                sourcesCloned.add(null);
            }
            obj.sources = sourcesCloned;
        }
        if (this.qualifier != null) {
            obj.qualifier = (QualifierInfo)this.qualifier.clone();
        }
        if (this.having != null) {
            ArrayList<QualifierInfo> havingCloned = new ArrayList<QualifierInfo>();
            for (i = 0; i < this.having.size(); ++i) {
                QualifierInfo havingItem = this.having.get(i);
                if (havingItem != null) {
                    havingCloned.add((QualifierInfo)havingItem.clone());
                    continue;
                }
                havingCloned.add(null);
            }
            obj.having = havingCloned;
        }
        if (this.groupBy != null) {
            ArrayList<QueryFormField> groupByClones = new ArrayList<QueryFormField>();
            for (i = 0; i < this.groupBy.size(); ++i) {
                QueryFormField groupByItem = this.groupBy.get(i);
                if (groupByItem != null) {
                    groupByClones.add((QueryFormField)groupByItem.clone());
                    continue;
                }
                groupByClones.add(null);
            }
            obj.groupBy = groupByClones;
        }
        return obj;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Field List", this.fromFields).append("Sources", this.sources).append("Qualifier", this.qualifier);
        if (this.having != null || this.groupBy != null) {
            sb.append("Having", this.having).append("GroupBy", this.groupBy);
        }
        return sb.toString();
    }
}

