/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.AssociationsToFollow;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DisplayOnlyForm;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.RegularForm;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.ViewForm;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class Form
extends ObjectBase
implements Cloneable {
    private static final long serialVersionUID = 9129798825571752620L;
    private List<EntryListFieldInfo> m_getListFields = null;
    private List<Integer> m_adminGrpList;
    private List<SortInfo> m_sortInfo;
    private List<IndexInfo> m_indexInfo;
    private ArchiveInfo m_archiveInfo;
    private AuditInfo m_auditInfo;
    private int m_deleteOption;
    private ObjectPropertyMap m_objPropList;
    private String m_defaultVUI;
    private List<PermissionInfo> m_AssignedGroup;
    private AssociationsToFollow m_associationToFollowForArchive;

    public Form() {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.hashValues = new Integer[19];
    }

    public Form(String name) {
        this.setName(name);
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.hashValues = new Integer[19];
    }

    protected Form(String name, List<PermissionInfo> permissionList, String helpText, long lastUpdateTime, String owner, String lastChangedBy, String diaryStr) {
        super(name, null, helpText, lastUpdateTime, owner, lastChangedBy, diaryStr);
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        if (permissionList == null || permissionList.isEmpty()) {
            this.m_permissionList = permissionList;
        } else {
            this.setPermissions(permissionList);
        }
        this.hashValues = new Integer[19];
        this.calculateHashCode();
    }

    @Override
    protected void createChangeFlags() {
        this.m_changeFlags = new FormCriteria();
    }

    public void setAdminGrpList(List<Integer> adminList) {
        this.m_adminGrpList = adminList;
        if (this.m_adminGrpList != null) {
            this.m_adminGrpList = new ArrayList<Integer>(adminList.size());
            for (int i = 0; i < adminList.size(); ++i) {
                this.m_adminGrpList.add(new Integer(adminList.get(i)));
            }
        }
        this.m_changeFlags.setParameter(9L, true);
    }

    @Override
    public void setPermissions(List<PermissionInfo> permissionList) {
        if (permissionList == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new ArrayList(permissionList.size());
            this.m_AssignedGroup = new ArrayList<PermissionInfo>(permissionList.size());
            for (int i = 0; i < permissionList.size(); ++i) {
                int intVal = permissionList.get(i).getGroupID();
                this.m_permissionList.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
                this.m_AssignedGroup.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public List<Integer> getAdminGrpList() {
        return this.m_adminGrpList;
    }

    public List<SortInfo> getSortInfo() {
        return this.m_sortInfo;
    }

    public void setSortInfo(List<SortInfo> sortList) {
        this.m_sortInfo = sortList;
        this.m_changeFlags.setParameter(11L, true);
    }

    public void setIndexInfo(List<IndexInfo> indexList) {
        this.m_indexInfo = indexList;
        this.m_changeFlags.setParameter(12L, true);
    }

    public List<IndexInfo> getIndexInfo() {
        return this.m_indexInfo;
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.m_archiveInfo = archiveInfo;
        this.m_changeFlags.setParameter(14L, true);
    }

    public ArchiveInfo getArchiveInfo() {
        return this.m_archiveInfo;
    }

    public void setAuditInfo(AuditInfo auditInfo) {
        this.m_auditInfo = auditInfo;
        this.m_changeFlags.setParameter(15L, true);
    }

    public AuditInfo getAuditInfo() {
        return this.m_auditInfo;
    }

    public void setEntryListFieldInfo(List<EntryListFieldInfo> getListFields) {
        this.m_getListFields = getListFields;
        this.m_changeFlags.setParameter(10L, true);
    }

    public List<EntryListFieldInfo> getEntryListFieldInfo() {
        return this.m_getListFields;
    }

    public void setDeleteOption(int option) {
        this.m_deleteOption = option;
    }

    int getDeleteOption() {
        return this.m_deleteOption;
    }

    public int getFormType() {
        if (this instanceof RegularForm) {
            return 1;
        }
        if (this instanceof JoinForm) {
            return 2;
        }
        if (this instanceof DisplayOnlyForm) {
            return 4;
        }
        if (this instanceof ViewForm) {
            return 3;
        }
        if (this instanceof VendorForm) {
            return 5;
        }
        return 0;
    }

    public void setProperties(ObjectPropertyMap props) {
        this.m_objPropList = props;
        this.m_changeFlags.setParameter(7L, true);
    }

    public ObjectPropertyMap getProperties() {
        return this.m_objPropList;
    }

    public String getKey() {
        return this.getName();
    }

    public void setKey(String key) {
        this.setName(key);
    }

    public void setDefaultVUI(String defaultVUI) {
        this.m_defaultVUI = defaultVUI;
        this.m_changeFlags.setParameter(13L, true);
    }

    public String getDefaultVUI() {
        return this.m_defaultVUI;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        int nLen;
        Form obj = null;
        obj = (Form)super.clone();
        if (this.m_getListFields != null) {
            nLen = this.m_getListFields.size();
            obj.m_getListFields = new ArrayList<EntryListFieldInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_getListFields.add((EntryListFieldInfo)this.m_getListFields.get(i).clone());
            }
        }
        if (this.m_adminGrpList != null) {
            obj.m_adminGrpList = new ArrayList<Integer>(this.m_adminGrpList.size());
            for (i = 0; i < this.m_adminGrpList.size(); ++i) {
                obj.m_adminGrpList.add(new Integer(this.m_adminGrpList.get(i)));
            }
        }
        if (this.m_sortInfo != null) {
            nLen = this.m_sortInfo.size();
            obj.m_sortInfo = new ArrayList<SortInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_sortInfo.add((SortInfo)this.m_sortInfo.get(i).clone());
            }
        }
        if (this.m_indexInfo != null) {
            nLen = this.m_indexInfo.size();
            obj.m_indexInfo = new ArrayList<IndexInfo>(nLen);
            for (i = 0; i < nLen; ++i) {
                obj.m_indexInfo.add((IndexInfo)this.m_indexInfo.get(i).clone());
            }
        }
        if (this.m_archiveInfo != null) {
            obj.m_archiveInfo = (ArchiveInfo)this.m_archiveInfo.clone();
        }
        if (this.m_auditInfo != null) {
            obj.m_auditInfo = (AuditInfo)this.m_auditInfo.clone();
        }
        if (this.m_objPropList != null) {
            obj.m_objPropList = new ObjectPropertyMap();
            Set keys = this.m_objPropList.keySet();
            for (Integer key : keys) {
                obj.m_objPropList.put(key, (Value)((Value)this.m_objPropList.get(key)).clone());
            }
        }
        if (this.m_changeFlags != null) {
            obj.m_changeFlags = (FormCriteria)this.m_changeFlags.clone();
        }
        if (this.m_associationToFollowForArchive != null) {
            obj.m_associationToFollowForArchive = (AssociationsToFollow)this.m_associationToFollowForArchive.clone();
        }
        this.calculateHashCode();
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Form)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Form rhs = (Form)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_getListFields, rhs.m_getListFields).append(this.m_adminGrpList, rhs.m_adminGrpList).append(this.m_sortInfo, rhs.m_sortInfo).append(this.m_indexInfo, rhs.m_indexInfo).append(this.m_archiveInfo, rhs.m_archiveInfo).append(this.m_auditInfo, rhs.m_auditInfo).append(this.m_deleteOption, rhs.m_deleteOption).append(this.m_objPropList, rhs.m_objPropList).append(this.m_defaultVUI, rhs.m_defaultVUI).append(this.m_associationToFollowForArchive, rhs.m_associationToFollowForArchive).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_getListFields).append(this.m_adminGrpList).append(this.m_sortInfo).append(this.m_indexInfo).append(this.m_archiveInfo).append(this.m_auditInfo).append(this.m_deleteOption).append(this.m_objPropList).append(this.m_defaultVUI).append(this.m_associationToFollowForArchive).toHashCode();
    }

    private void fromVariantDuringGet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setPermissions(ARTypeMgr.getInstance().ObjectListFromVariant(PermissionInfo.class, ARTypeMgr.GetAt((Object)rawData, 6), ctx));
        this.setAdminGrpList(ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, 7), ctx));
        this.setEntryListFieldInfo(ARTypeMgr.getInstance().ObjectListFromVariant(EntryListFieldInfo.class, ARTypeMgr.GetAt((Object)rawData, 8), ctx));
        this.setSortInfo(ARTypeMgr.getInstance().ObjectListFromVariant(SortInfo.class, ARTypeMgr.GetAt((Object)rawData, 9), ctx));
        this.setIndexInfo(ARTypeMgr.getInstance().ObjectListFromVariant(IndexInfo.class, ARTypeMgr.GetAt((Object)rawData, 10), ctx));
        this.setArchiveInfo(ARTypeMgr.getInstance().ObjectFromVariant(ArchiveInfo.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
        this.setAuditInfo(ARTypeMgr.getInstance().ObjectFromVariant(AuditInfo.class, ARTypeMgr.GetAt((Object)rawData, 12), ctx));
        this.setDefaultVUI(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 13)));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 14)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 15)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 16)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 17)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 18)));
        this.setProperties(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, 19), ctx));
        this.setAssociationToFollowForArchive(ARTypeMgr.getInstance().ObjectFromVariant(AssociationsToFollow.class, ARTypeMgr.GetAt((Object)rawData, 20), ctx));
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        if (ctx == null || ctx.getCurrentOp().equals("ARGetSchema")) {
            this.fromVariantDuringGet(rawData, ctx);
        }
    }

    private Object toVariantDuringCreate(ARServerUser ctx) {
        Object[] var = new Object[17];
        var[0] = "ARCreateSchema";
        var[1] = ctx;
        var[2] = this.getName();
        var[3] = new Object[]{this.getFormType(), null};
        var[5] = ARTypeMgr.getInstance().ObjectToVariant(this.getPermissions(), ctx);
        var[6] = ARTypeMgr.getInstance().ObjectToVariant(this.getAdminGrpList(), ctx);
        var[7] = null;
        var[8] = null;
        var[9] = null;
        var[10] = ARTypeMgr.getInstance().ObjectToVariant(this.getArchiveInfo(), ctx);
        var[11] = ARTypeMgr.getInstance().ObjectToVariant(this.getAuditInfo(), ctx);
        var[12] = this.getDefaultVUI();
        var[13] = this.getHelpText();
        var[14] = this.getOwner();
        var[15] = this.getDiary().getAppendedText();
        var[16] = ARTypeMgr.getInstance().ObjectToVariant(this.getProperties(), ctx);
        return var;
    }

    private Object toVariantDuringSet(ARServerUser ctx) {
        Object[] var = new Object[19];
        var[0] = "ARSetSchema";
        var[1] = ctx;
        var[2] = this.getName();
        var[3] = this.getNewName();
        var[4] = new Object[]{this.getFormType(), null};
        var[6] = ARTypeMgr.getInstance().ObjectToVariant(this.getPermissions(), ctx);
        var[7] = ARTypeMgr.getInstance().ObjectToVariant(this.getAdminGrpList(), ctx);
        var[8] = ARTypeMgr.getInstance().ObjectToVariant(this.getEntryListFieldInfo(), ctx);
        var[9] = ARTypeMgr.getInstance().ObjectToVariant(this.getSortInfo(), ctx);
        var[10] = ARTypeMgr.getInstance().ObjectToVariant(this.getIndexInfo(), ctx);
        var[11] = ARTypeMgr.getInstance().ObjectToVariant(this.getArchiveInfo(), ctx);
        var[12] = ARTypeMgr.getInstance().ObjectToVariant(this.getAuditInfo(), ctx);
        var[13] = this.getDefaultVUI();
        var[14] = this.getHelpText();
        var[15] = this.getOwner();
        var[16] = this.getDiary().getAppendedText();
        var[17] = ARTypeMgr.getInstance().ObjectToVariant(this.getProperties(), ctx);
        var[18] = new Integer(0);
        return var;
    }

    Object toVariant(ARServerUser ctx) {
        if (ctx != null && ctx.getCurrentOp().equals("ARCreateSchema")) {
            return this.toVariantDuringCreate(ctx);
        }
        return this.toVariantDuringSet(ctx);
    }

    static Form createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        Form obj = null;
        int formType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, new int[]{4, 0}));
        switch (formType) {
            case 2: {
                obj = ARTypeMgr.getInstance().NewObject(JoinForm.class, ctx);
                break;
            }
            case 3: {
                obj = ARTypeMgr.getInstance().NewObject(ViewForm.class, ctx);
                break;
            }
            case 4: {
                obj = ARTypeMgr.getInstance().NewObject(DisplayOnlyForm.class, ctx);
                break;
            }
            case 5: {
                obj = ARTypeMgr.getInstance().NewObject(VendorForm.class, ctx);
                break;
            }
            default: {
                obj = ARTypeMgr.getInstance().NewObject(RegularForm.class, ctx);
            }
        }
        obj.fromVariant(rawData, ctx);
        return obj;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Get List Fields", this.m_getListFields).append("Admin Grp List", this.m_adminGrpList).append("Sort Info", this.m_sortInfo).append("Index Info", this.m_indexInfo).append("Archive Info", this.m_archiveInfo).append("Audit Info", this.m_auditInfo).append("Delete Option", this.m_deleteOption).append("Obj Prop List", this.m_objPropList).append("Default VUI", this.m_defaultVUI).append("associationToFollowForArchive", this.m_associationToFollowForArchive).toString();
    }

    @Override
    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[19];
        }
        super.calculateHashCode();
        this.hashValues[9] = this.m_adminGrpList != null ? Integer.valueOf(this.m_adminGrpList.hashCode()) : null;
        this.hashValues[10] = this.m_getListFields != null ? Integer.valueOf(this.m_getListFields.hashCode()) : null;
        this.hashValues[11] = this.m_sortInfo != null ? Integer.valueOf(this.m_sortInfo.hashCode()) : null;
        this.hashValues[12] = this.m_indexInfo != null ? Integer.valueOf(this.m_indexInfo.hashCode()) : null;
        this.hashValues[14] = this.m_archiveInfo != null ? Integer.valueOf(this.m_archiveInfo.hashCode()) : null;
        this.hashValues[15] = this.m_auditInfo != null ? Integer.valueOf(this.m_auditInfo.hashCode()) : null;
        this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(this.m_objPropList.hashCode()) : null;
        this.hashValues[18] = this.m_associationToFollowForArchive != null ? Integer.valueOf(this.m_associationToFollowForArchive.hashCode()) : null;
    }

    @Override
    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        super.calculateHashCodeOnGet(criteria == null ? new FormCriteria() : criteria);
    }

    @Override
    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            this.hashValues = new Integer[19];
        }
        super.calculateChangeFlagsOnSet();
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[9]) {
            if (this.m_adminGrpList != null) {
                hashCode = this.m_adminGrpList.hashCode();
                if (this.hashValues[9] == null || hashCode != this.hashValues[9]) {
                    this.m_changeFlags.setParameter(9L, true);
                }
                this.hashValues[9] = this.m_adminGrpList != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[9] != null) {
                this.m_changeFlags.setParameter(9L, true);
                this.hashValues[9] = null;
            }
        }
        if (!changeFlags[10]) {
            if (this.m_getListFields != null) {
                hashCode = this.m_getListFields.hashCode();
                if (this.hashValues[10] == null || hashCode != this.hashValues[10]) {
                    this.m_changeFlags.setParameter(10L, true);
                }
                this.hashValues[10] = this.m_getListFields != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[10] != null) {
                this.m_changeFlags.setParameter(10L, true);
                this.hashValues[10] = null;
            }
        }
        if (!changeFlags[11]) {
            if (this.m_sortInfo != null) {
                hashCode = this.m_sortInfo.hashCode();
                if (this.hashValues[11] == null || hashCode != this.hashValues[11]) {
                    this.m_changeFlags.setParameter(11L, true);
                }
                this.hashValues[11] = this.m_sortInfo != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[11] != null) {
                this.m_changeFlags.setParameter(11L, true);
                this.hashValues[11] = null;
            }
        }
        if (!changeFlags[12]) {
            if (this.m_indexInfo != null) {
                hashCode = this.m_indexInfo.hashCode();
                if (this.hashValues[12] == null || hashCode != this.hashValues[12]) {
                    this.m_changeFlags.setParameter(12L, true);
                }
                this.hashValues[12] = this.m_indexInfo != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[12] != null) {
                this.m_changeFlags.setParameter(12L, true);
                this.hashValues[12] = null;
            }
        }
        if (!changeFlags[14]) {
            if (this.m_archiveInfo != null) {
                hashCode = this.m_archiveInfo.hashCode();
                if (this.hashValues[14] == null || hashCode != this.hashValues[14]) {
                    this.m_changeFlags.setParameter(14L, true);
                }
                this.hashValues[14] = this.m_archiveInfo != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[14] != null) {
                this.m_changeFlags.setParameter(14L, true);
                this.hashValues[14] = null;
            }
        }
        if (!changeFlags[15]) {
            if (this.m_auditInfo != null) {
                hashCode = this.m_auditInfo.hashCode();
                if (this.hashValues[15] == null || hashCode != this.hashValues[15]) {
                    this.m_changeFlags.setParameter(15L, true);
                }
                this.hashValues[15] = this.m_auditInfo != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[15] != null) {
                this.m_changeFlags.setParameter(15L, true);
                this.hashValues[15] = null;
            }
        }
        if (!changeFlags[7]) {
            if (this.m_objPropList != null && !this.m_objPropList.isEmpty()) {
                hashCode = this.m_objPropList.hashCode();
                if (this.hashValues[7] == null || hashCode != this.hashValues[7]) {
                    this.m_changeFlags.setParameter(7L, true);
                }
                this.hashValues[7] = this.m_objPropList != null && !this.m_objPropList.isEmpty() ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[7] != null) {
                this.m_changeFlags.setParameter(7L, true);
                this.hashValues[7] = null;
            }
        }
        if (!changeFlags[18]) {
            if (this.m_associationToFollowForArchive != null) {
                hashCode = this.m_associationToFollowForArchive.hashCode();
                if (this.hashValues[18] == null || hashCode != this.hashValues[18]) {
                    this.m_changeFlags.setParameter(18L, true);
                }
                this.hashValues[18] = this.m_associationToFollowForArchive != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[18] != null) {
                this.m_changeFlags.setParameter(18L, true);
                this.hashValues[18] = null;
            }
        }
    }

    public List<PermissionInfo> getAssignedGroup() {
        return this.m_AssignedGroup;
    }

    void setAssignedGroup(List<PermissionInfo> list) {
        this.m_AssignedGroup = list;
    }

    public AssociationsToFollow getAssociationToFollowForArchive() {
        return this.m_associationToFollowForArchive;
    }

    public void setAssociationToFollowForArchive(AssociationsToFollow associationToFollowForArchive) {
        this.m_associationToFollowForArchive = associationToFollowForArchive;
        this.m_changeFlags.setParameter(18L, true);
    }
}

