/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.util.ARPluginDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ArrayCentralConfig {
    private static Logger logger = Logger.getLogger(ArrayCentralConfig.class);
    private static final String ARSERVER_COMPONENT_TYPE = "com.bmc.arsys.server";
    private static final String SERVER_PLUGIN_ALIAS = "Server-Plugin-Alias";
    private static final String PLUGIN_SVR_PATH = "path";
    private static final String PLUGIN_SVR_HOSTNAME = "hostname";
    private static final String PLUGIN_SERVER_COMPONENT_TYPE = "com.bmc.arsys.pluginServer";
    private static final int FIELD_STATUS_ACTIVE = 0;
    private static final int FIELD_STATUS_INACTIVE = 1;
    private final ARServerUser context;
    private final String componentFormName;
    private final String joinFormName;

    ArrayCentralConfig(ARServerUser context, String componentFormName, String joinFormName) {
        this.context = context;
        this.componentFormName = componentFormName;
        this.joinFormName = joinFormName;
    }

    public String createComponentAndSettings(String componentName, String componentType, String componentDescription, List<String[]> nameValuePair) throws ARException {
        Entry componentEntry = this.getActiveComponent(componentName, componentType);
        String existingComponentEntryId = null;
        List<Entry> existingSettingEntries = null;
        if (componentEntry != null) {
            existingComponentEntryId = componentEntry.getEntryId();
            existingSettingEntries = this.getConfigSettingsWithEntryIDs(componentName, componentType, null);
        }
        this.context.beginBulkEntryTransaction();
        if (existingComponentEntryId != null) {
            if (existingSettingEntries != null) {
                for (Entry entry : existingSettingEntries) {
                    String entryId = entry.getEntryId();
                    this.context.deleteEntry(this.joinFormName, entryId, 0);
                }
            }
            this.context.deleteEntry(this.componentFormName, existingComponentEntryId, 0);
        }
        this.createComponentEntry(componentName, componentType, componentDescription, true);
        this.createSettingEntries(null, componentName, componentType, nameValuePair);
        this.context.endBulkEntryTransaction(1);
        componentEntry = this.getActiveComponent(componentName, componentType);
        String componentGuid = ((Value)componentEntry.get((Object)179)).toString();
        return componentGuid;
    }

    private String createComponentEntry(String componentName, String componentType, String componentDescription, boolean status) throws ARException {
        Entry thisEntry = new Entry();
        String newEntryGUID = null;
        thisEntry.put(Integer.valueOf(3200), new Value(componentName));
        thisEntry.put(Integer.valueOf(3201), new Value(componentType));
        thisEntry.put(Integer.valueOf(3202), new Value(componentType));
        if (status) {
            thisEntry.put(Integer.valueOf(7), new Value(0));
        } else {
            thisEntry.put(Integer.valueOf(7), new Value(1));
        }
        String EntryID = this.context.createEntry(this.componentFormName, thisEntry);
        if (EntryID != null && !EntryID.isEmpty() && (thisEntry = this.context.getEntry(this.componentFormName, EntryID, new int[]{179})) != null) {
            newEntryGUID = ((Value)thisEntry.get((Object)179)).toString();
        }
        return newEntryGUID;
    }

    private void updateOlderComponents(String componentNamePrefix, String componentType, String description, boolean status) throws ARException {
        List<Entry> activeOlderComponents = this.getComponentWithPrefix(componentNamePrefix, componentType);
        if (activeOlderComponents != null && activeOlderComponents.size() > 0) {
            for (Entry entry : activeOlderComponents) {
                String componentGUID;
                if (entry.get((Object)179) == null || (componentGUID = ((Value)entry.get((Object)179)).toString()) == null) continue;
                this.updateComponent(componentGUID, null, componentType, description, status);
            }
        }
    }

    public List<Entry> getComponentWithPrefix(String componentNamePrefix, String componentType) throws ARException {
        QualifierInfo activeConfigQual = this.getQualifierForConfigSetting(componentNamePrefix + "%", componentType, null, 7);
        int[] fieldIds = new int[]{1, 179, 3200};
        OutputInteger numberReturned = new OutputInteger(-1);
        ArrayList<Entry> configComponentEntries = new ArrayList<Entry>();
        while (configComponentEntries == null || numberReturned.intValue() != configComponentEntries.size()) {
            List tempConfigSettingEntries = this.context.getListEntryObjects(this.componentFormName, activeConfigQual, configComponentEntries.size(), 0, null, fieldIds, false, numberReturned);
            configComponentEntries.addAll(tempConfigSettingEntries);
            if (configComponentEntries.size() != 0) continue;
            return null;
        }
        return configComponentEntries;
    }

    public Entry getActiveComponent(String componentName, String componentType) throws ARException {
        QualifierInfo qualifier = this.getQualifierForConfigSetting(componentName, componentType, null);
        ArithmeticOrRelationalOperand fieldOp = new ArithmeticOrRelationalOperand(7);
        ArithmeticOrRelationalOperand valueOp = new ArithmeticOrRelationalOperand(new Value(0));
        RelationalOperationInfo relQual = new RelationalOperationInfo(1, fieldOp, valueOp);
        QualifierInfo statusQual = new QualifierInfo(relQual);
        qualifier = new QualifierInfo(1, qualifier, statusQual);
        int[] fieldIds = new int[]{1, 179, 3210};
        Entry componentEntry = this.context.getOneEntryObject(this.componentFormName, qualifier, null, fieldIds, false, null);
        return componentEntry;
    }

    public int createSettingEntries(String componentGUID, String componentName, String componentType, List<String[]> nameValuePair) throws ARException {
        Iterator<String[]> configIter = nameValuePair.iterator();
        int count = 0;
        while (configIter.hasNext()) {
            String[] thisNameValue = configIter.next();
            Entry thisEntry = new Entry();
            thisEntry.put(Integer.valueOf(3200), new Value(componentName));
            thisEntry.put(Integer.valueOf(3201), new Value(componentType));
            thisEntry.put(Integer.valueOf(3207), new Value(componentGUID));
            thisEntry.put(Integer.valueOf(3204), new Value(thisNameValue[0]));
            thisEntry.put(Integer.valueOf(3205), new Value(thisNameValue[1]));
            this.context.createEntry(this.joinFormName, thisEntry);
            ++count;
        }
        return count;
    }

    public void setSettingEntries(String entryID, String componentGUID, String componentName, String componentType, String settingName, String settingValue) throws ARException {
        Entry thisEntry = new Entry();
        if (componentName != null) {
            thisEntry.put(Integer.valueOf(3200), new Value(componentName));
        }
        if (componentType != null) {
            thisEntry.put(Integer.valueOf(3201), new Value(componentType));
        }
        if (componentGUID != null) {
            thisEntry.put(Integer.valueOf(3207), new Value(componentGUID));
        }
        if (settingName != null) {
            thisEntry.put(Integer.valueOf(3204), new Value(settingName));
        }
        if (settingValue != null) {
            thisEntry.put(Integer.valueOf(3205), new Value(settingValue));
        }
        this.context.setEntry(this.joinFormName, entryID, thisEntry, null, 0);
    }

    private QualifierInfo getQualifierForConfigSetting(String activeConfigName, String componentType, String settingName, int relationForComponent) {
        QualifierInfo nameGUIDQualifier = new QualifierInfo();
        QualifierInfo activeSettingValueQualifier = new QualifierInfo();
        ArithmeticOrRelationalOperand nameQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3200);
        ArithmeticOrRelationalOperand nameQualifierRight = new ArithmeticOrRelationalOperand(new Value(activeConfigName));
        QualifierInfo nameQualifier = new QualifierInfo(new RelationalOperationInfo(relationForComponent, nameQualifierLeft, nameQualifierRight));
        ArithmeticOrRelationalOperand componentQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3201);
        ArithmeticOrRelationalOperand componentQualifierRight = new ArithmeticOrRelationalOperand(new Value(componentType));
        QualifierInfo componentQualifier = new QualifierInfo(new RelationalOperationInfo(1, componentQualifierLeft, componentQualifierRight));
        ArithmeticOrRelationalOperand statusQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 7);
        ArithmeticOrRelationalOperand statusQualifierRight = new ArithmeticOrRelationalOperand(new Value(0));
        QualifierInfo statusQualifier = new QualifierInfo(new RelationalOperationInfo(1, statusQualifierLeft, statusQualifierRight));
        nameGUIDQualifier.setOperation(1);
        nameGUIDQualifier.setLeftOperand(nameQualifier);
        nameGUIDQualifier.setRightOperand(statusQualifier);
        if (settingName == null) {
            activeSettingValueQualifier.setOperation(1);
            activeSettingValueQualifier.setLeftOperand(componentQualifier);
            activeSettingValueQualifier.setRightOperand(nameGUIDQualifier);
        } else {
            ArithmeticOrRelationalOperand settingQualifierLeft = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 3204);
            ArithmeticOrRelationalOperand settingQualifierRight = new ArithmeticOrRelationalOperand(new Value(settingName));
            QualifierInfo settingQualifier = new QualifierInfo(new RelationalOperationInfo(7, settingQualifierLeft, settingQualifierRight));
            QualifierInfo activeConfigQualifier = new QualifierInfo();
            activeConfigQualifier.setOperation(1);
            activeConfigQualifier.setLeftOperand(componentQualifier);
            activeConfigQualifier.setRightOperand(nameGUIDQualifier);
            activeSettingValueQualifier.setOperation(1);
            activeSettingValueQualifier.setLeftOperand(activeConfigQualifier);
            activeSettingValueQualifier.setRightOperand(settingQualifier);
        }
        return activeSettingValueQualifier;
    }

    public List<String[]> getConfigSettingsAsList(String configName, String configType, String settingName) throws ARException {
        QualifierInfo activeConfigQual = this.getQualifierForConfigSetting(configName, configType, settingName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3204, 3205};
        ArrayList<String[]> nameValuePair = new ArrayList<String[]>();
        OutputInteger numberReturned = new OutputInteger(-1);
        ArrayList configSettingEntries = new ArrayList();
        while (numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = this.context.getListEntryObjects(this.joinFormName, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        for (Entry thisEntry : configSettingEntries) {
            String[] thisNameValue = new String[2];
            Value thisSettingName = (Value)thisEntry.get((Object)3204);
            Value thisSettingValue = (Value)thisEntry.get((Object)3205);
            if (thisSettingName == null) continue;
            thisNameValue[0] = thisSettingName.toString();
            thisNameValue[1] = thisSettingValue.toString();
            nameValuePair.add(thisNameValue);
        }
        return nameValuePair;
    }

    private QualifierInfo getQualifierForConfigSetting(String configName, String configType, String settingName) {
        return this.getQualifierForConfigSetting(configName, configType, settingName, 1);
    }

    public String getEntryValue(Entry thisEntry) {
        Value thisValue = (Value)thisEntry.get((Object)3205);
        if (thisValue != null && thisValue.getDataType() == DataType.CHAR) {
            return thisValue.toString();
        }
        return null;
    }

    public List<Entry> getConfigSettingsWithEntryIDs(String configName, String configType, String settingName) throws ARException {
        return this.getConfigSettingsWithEntryIDs(configName, configType, settingName, 1);
    }

    public List<Entry> getConfigSettingsWithEntryIDs(String configName, String configType, String settingName, int relationOPForCompName) throws ARException {
        OutputInteger numberReturned = new OutputInteger(-1);
        QualifierInfo activeConfigQual = this.getQualifierForConfigSetting(configName, configType, settingName, relationOPForCompName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3207, 3204, 3205};
        ArrayList<Entry> configSettingEntries = new ArrayList<Entry>();
        while (configSettingEntries == null || numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = this.context.getListEntryObjects(this.joinFormName, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        return configSettingEntries;
    }

    public String getComponentGUIDFromEntry(Entry thisEntry) {
        Value thisValue = (Value)thisEntry.get((Object)179);
        if (thisValue != null && thisValue.getDataType() == DataType.CHAR) {
            return thisValue.toString();
        }
        return null;
    }

    public String getComponentNameFromEntry(Entry thisEntry) {
        Value thisValue = (Value)thisEntry.get((Object)3200);
        if (thisValue != null && thisValue.getDataType() == DataType.CHAR) {
            return thisValue.toString();
        }
        return null;
    }

    public Map<String, List<String>> getConfigSettingsAsMap(String configName, String configType, String settingName) throws ARException {
        OutputInteger numberReturned = new OutputInteger(-1);
        QualifierInfo activeConfigQual = this.getQualifierForConfigSetting(configName, configType, settingName);
        ArrayList sortList = new ArrayList(3204);
        int[] fieldIds = new int[]{1, 3204, 3205};
        ArrayList configSettingEntries = new ArrayList();
        while (numberReturned.intValue() != configSettingEntries.size()) {
            List tempConfigSettingEntries = this.context.getListEntryObjects(this.joinFormName, activeConfigQual, configSettingEntries.size(), 0, sortList, fieldIds, false, numberReturned);
            configSettingEntries.addAll(tempConfigSettingEntries);
            if (configSettingEntries.size() != 0) continue;
            return null;
        }
        HashMap<String, List<String>> hmSettings = new HashMap<String, List<String>>();
        for (Entry thisEntry : configSettingEntries) {
            Value thisSettingName = (Value)thisEntry.get((Object)3204);
            Value thisSettingValue = (Value)thisEntry.get((Object)3205);
            if (thisSettingName == null || thisSettingName.getValue() == null || thisSettingValue == null) continue;
            if (hmSettings.containsKey(thisSettingName.getValue())) {
                ((List)hmSettings.get(thisSettingName.getValue())).add(thisSettingValue.toString());
                continue;
            }
            ArrayList<String> settings = new ArrayList<String>();
            settings.add(thisSettingValue.toString());
            hmSettings.put(thisSettingName.toString(), settings);
        }
        return hmSettings;
    }

    private void changeComponentStatus(String componentGUID, boolean status) throws ARException {
        String entryId = this.getEntryIdFromGUID(componentGUID);
        if (entryId != null) {
            Entry entryToUpdate = new Entry();
            int updateStatus = status ? 0 : 1;
            entryToUpdate.put(Integer.valueOf(7), new Value(updateStatus));
            entryToUpdate.put(Integer.valueOf(179), new Value(componentGUID));
            this.context.setEntry(this.componentFormName, entryId, entryToUpdate, new Timestamp(), 0);
        }
    }

    private void updateComponent(String componentGUID, String componentName, String componentType, String componentDescription, boolean status) throws ARException {
        String entryId = this.getEntryIdFromGUID(componentGUID);
        if (entryId != null) {
            Entry entryToUpdate = new Entry();
            int updateStatus = status ? 0 : 1;
            entryToUpdate.put(Integer.valueOf(7), new Value(updateStatus));
            if (componentName != null) {
                entryToUpdate.put(Integer.valueOf(3200), new Value(componentName));
            }
            if (componentType != null) {
                entryToUpdate.put(Integer.valueOf(3201), new Value(componentType));
            }
            if (componentDescription != null) {
                entryToUpdate.put(Integer.valueOf(3202), new Value(componentDescription));
            }
            entryToUpdate.put(Integer.valueOf(179), new Value(componentGUID));
            this.context.setEntry(this.componentFormName, entryId, entryToUpdate, new Timestamp(), 0);
        }
    }

    public void updateComponentFileTimeStamp(String componentGUID, Timestamp expectedTimeStamp) throws ARException {
        String entryId = this.getEntryIdFromGUID(componentGUID);
        if (entryId != null) {
            Entry entryToUpdate = new Entry();
            entryToUpdate.put(Integer.valueOf(3210), new Value(expectedTimeStamp));
            entryToUpdate.put(Integer.valueOf(179), new Value(componentGUID));
            this.context.setEntry(this.componentFormName, entryId, entryToUpdate, new Timestamp(), 0);
        }
    }

    private String getEntryIdFromGUID(String componentGUID) throws ARException {
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(179);
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(componentGUID));
        RelationalOperationInfo rInfo = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo qInfo = new QualifierInfo(rInfo);
        int[] fieldComponents = new int[]{179, CoreFieldId.EntryId.getFieldId()};
        List componentEntries = this.context.getListEntryObjects(this.componentFormName, qInfo, 0, 2, new ArrayList(), fieldComponents, false, null);
        if (componentEntries != null && componentEntries.size() > 0) {
            Iterator itrEntry = componentEntries.iterator();
            Entry oEntry = null;
            Value avalue = null;
            if (itrEntry.hasNext() && (avalue = (Value)(oEntry = (Entry)itrEntry.next()).get((Object)CoreFieldId.EntryId.getFieldId())) != null) {
                return (String)avalue.getValue();
            }
        }
        return null;
    }

    public void updateConfigSetting(String settingEntryID, String settingName, String settingValue) throws ARException {
        this.setSettingEntries(settingEntryID, null, null, null, settingName, settingValue);
    }

    public void updateOrCreateSetting(String componentGUID, String componentName, String componentType, String settingName, String settingValue) throws ARException {
        Map<String, List<String>> configSettingsAsMap = this.getConfigSettingsAsMap(componentName, componentType, settingName);
        if (configSettingsAsMap == null || configSettingsAsMap.size() == 0) {
            String[] values = new String[]{settingName, settingValue};
            ArrayList<String[]> alSettings = new ArrayList<String[]>();
            alSettings.add(values);
            this.createSettingEntries(componentGUID, componentName, componentType, alSettings);
        } else {
            List<Entry> configSettingsWithEntryIDs = this.getConfigSettingsWithEntryIDs(componentName, componentType, settingName, 1);
            if (configSettingsWithEntryIDs != null) {
                for (Entry thisEntry : configSettingsWithEntryIDs) {
                    this.setSettingEntries(thisEntry.getEntryId(), componentGUID, componentName, componentType, settingName, settingValue);
                }
            }
        }
    }

    public boolean deleteSetting(String componentName, String componentType, String settingName, String settingValue) throws ARException {
        boolean deleted = false;
        List<Entry> entries = this.getConfigSettingsWithEntryIDs(componentName, componentType, settingName);
        if (entries != null) {
            for (Entry entry : entries) {
                String actualValue = this.getEntryValue(entry);
                if (!this.equals(settingValue, actualValue)) continue;
                this.context.deleteEntry(this.joinFormName, entry.getEntryId(), 0);
                deleted = true;
            }
        }
        return deleted;
    }

    private boolean equals(String obj1, String obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public void registerPlugin(ARPluginDefinition pluginDef, String pluginXmlPath, String pluginSetName) throws ARException {
        if (pluginDef == null || StringUtils.isBlank((String)pluginDef.getPluginName()) || StringUtils.isBlank((String)pluginDef.getFileName())) {
            throw new ARException();
        }
        String pluginServerName = null;
        String targetPath = null;
        if (!ArrayCentralConfig.isWindows() && pluginXmlPath != null) {
            logger.info("Unix OS");
            try {
                logger.info("Calling method to resolve symbolic link");
                targetPath = this.resolveSymbolicLink(pluginXmlPath);
            }
            catch (IOException e) {
                logger.info("IO Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.info("Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
        }
        if (targetPath != null && !StringUtils.isEmpty((String)targetPath.trim())) {
            logger.info("Passing symbolic link resolved path to plugin server lookup");
            pluginXmlPath = targetPath;
        }
        if ((pluginServerName = this.lookupPluginServer(pluginXmlPath)) == null) {
            return;
        }
        this.unregisterPlugin(pluginDef.getPluginName(), pluginXmlPath, pluginSetName, pluginServerName);
        String componentGUID = this.getComponentGUID(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE);
        if (componentGUID != null) {
            List<String[]> nameValuePair = this.populatePluginInformation(pluginDef, pluginSetName);
            this.createSettingEntries(componentGUID, pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, nameValuePair);
        }
        this.addServerPluginAlias(pluginServerName, pluginDef.getPluginName(), this.getPluginServerPort(pluginServerName));
    }

    private String getPluginServerPort(String pluginServerName) throws ARException {
        Map<String, List<String>> ports = this.getConfigSettingsAsMap(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, "port");
        if (ports != null && ports.get("port") != null) {
            return ports.get("port").get(0);
        }
        return null;
    }

    private void addServerPluginAlias(String pluginServerName, String pluginName, String pluginPort) throws ARException {
        if (pluginName == null || pluginPort == null) {
            return;
        }
        this.removeServerPluginAlias(pluginServerName, pluginName, pluginPort);
        Map<String, List<String>> valForHostName = this.getConfigSettingsAsMap(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, PLUGIN_SVR_HOSTNAME);
        if (valForHostName == null || valForHostName.get(PLUGIN_SVR_HOSTNAME) == null || valForHostName.get(PLUGIN_SVR_HOSTNAME).get(0) == null) {
            return;
        }
        String serverName = valForHostName.get(PLUGIN_SVR_HOSTNAME).get(0);
        List<Entry> componentWithPrefix = this.getComponentWithPrefix(serverName, ARSERVER_COMPONENT_TYPE);
        if (componentWithPrefix != null && componentWithPrefix.size() > 0) {
            for (Entry thisEntry : componentWithPrefix) {
                String componentGUID = this.getComponentGUIDFromEntry(thisEntry);
                String componentName = this.getComponentNameFromEntry(thisEntry);
                if (componentName == null || !componentName.equals(serverName)) continue;
                String serverPluginAliasValue = this.getServerPluginAliasValue(pluginName, componentName, pluginPort);
                String serverPluginAliasKey = SERVER_PLUGIN_ALIAS;
                String[] settings = new String[]{serverPluginAliasKey, serverPluginAliasValue};
                ArrayList<String[]> nameValuePair = new ArrayList<String[]>();
                nameValuePair.add(settings);
                this.createSettingEntries(componentGUID, componentName, PLUGIN_SERVER_COMPONENT_TYPE, nameValuePair);
            }
        }
    }

    private String getServerPluginAliasValue(String pluginName, String serverCompName, String pluginServerPort) {
        StringBuilder builder = new StringBuilder();
        builder.append(pluginName).append(" ").append(pluginName).append(" ").append(serverCompName).append(":").append(pluginServerPort);
        return builder.toString();
    }

    private List<String[]> populatePluginInformation(ARPluginDefinition pluginDef, String pluginSetName) {
        String pluginSetPrefix = pluginSetName != null ? pluginSetName + "." : "";
        ArrayList<String[]> nameValuePair = new ArrayList<String[]>();
        this.addToNameValuePair(pluginSetPrefix + "plugins", pluginDef.getPluginName(), nameValuePair);
        this.addToNameValuePair(pluginSetPrefix + pluginDef.getPluginName() + ".classname", pluginDef.getClassName(), nameValuePair);
        this.addToNameValuePair(pluginSetPrefix + pluginDef.getPluginName() + ".filename", pluginDef.getFileName(), nameValuePair);
        if (pluginDef.getClassPathFolders() != null && pluginDef.getClassPathFolders().size() > 0) {
            for (String folder : pluginDef.getClassPathFolders()) {
                this.addToNameValuePair(pluginSetPrefix + pluginDef.getPluginName() + ".pathelement.type.path", folder, nameValuePair);
            }
        }
        if (pluginDef.getClassPathJars() != null && pluginDef.getClassPathJars().size() > 0) {
            for (String jar : pluginDef.getClassPathJars()) {
                this.addToNameValuePair(pluginSetPrefix + pluginDef.getPluginName() + ".pathelement.type.location", jar, nameValuePair);
            }
        }
        if (pluginDef.getUserDefinedParams() != null && pluginDef.getUserDefinedParams().size() > 0) {
            Set<String> userDefinedKeys = pluginDef.getUserDefinedParams().keySet();
            for (String key : userDefinedKeys) {
                this.addToNameValuePair(pluginSetPrefix + pluginDef.getPluginName() + ".userDefined." + key, pluginDef.getUserDefinedParams().get(key), nameValuePair);
            }
        }
        return nameValuePair;
    }

    private void addToNameValuePair(String settingName, String settingValue, List<String[]> nameValuePair) {
        if (StringUtils.isBlank((String)settingName) || settingValue == null) {
            return;
        }
        String[] nameValue = new String[]{settingName, settingValue};
        nameValuePair.add(nameValue);
    }

    public void unregisterPlugin(String pluginDefName, String pluginXmlPath, String pluginSetName) throws ARException {
        String pluginServerName = null;
        String targetPath = null;
        if (!ArrayCentralConfig.isWindows() && pluginXmlPath != null) {
            logger.info("Unix OS");
            try {
                logger.info("Calling method to resolve symbolic link");
                targetPath = this.resolveSymbolicLink(pluginXmlPath);
            }
            catch (IOException e) {
                logger.info("IO Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.info("Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
        }
        if (targetPath != null && !StringUtils.isEmpty((String)targetPath.trim())) {
            logger.info("Passing symbolic link resolved path to plugin server lookup");
            pluginXmlPath = targetPath;
        }
        if ((pluginServerName = this.lookupPluginServer(pluginXmlPath)) == null || StringUtils.isBlank((String)pluginDefName)) {
            return;
        }
        this.unregisterPlugin(pluginDefName, pluginXmlPath, pluginSetName, pluginServerName);
    }

    private void unregisterPlugin(String pluginDefName, String pluginXmlPath, String pluginSetName, String pluginServerName) throws ARException {
        String pluginSetPrefix = pluginSetName != null ? pluginSetName + "." : "";
        String pluginClassName = pluginSetPrefix + pluginDefName + ".classname";
        String pluginFileName = pluginSetPrefix + pluginDefName + ".filename";
        String pluginTypeLocation = pluginSetPrefix + pluginDefName + ".pathelement.type.location";
        String pluginTypePath = pluginSetPrefix + pluginDefName + ".pathelement.type.path";
        String pluginUserDefined = pluginSetPrefix + pluginDefName + ".userDefined.";
        this.context.beginBulkEntryTransaction();
        List<Entry> configSettingsWithEntryIDs = this.getConfigSettingsWithEntryIDs(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, null);
        if (configSettingsWithEntryIDs != null) {
            for (Entry entry : configSettingsWithEntryIDs) {
                Value settingValue;
                Value settingName = (Value)entry.get((Object)3204);
                if (settingName.getValue().toString().equals(pluginClassName) || settingName.getValue().toString().equals(pluginFileName) || settingName.getValue().toString().equals(pluginTypeLocation) || settingName.getValue().toString().equals(pluginTypePath) || settingName.getValue().toString().startsWith(pluginUserDefined)) {
                    this.context.deleteEntry(this.joinFormName, entry.getEntryId(), 0);
                }
                if (!settingName.getValue().toString().equals(pluginSetPrefix + "plugins") || !(settingValue = (Value)entry.get((Object)3205)).getValue().toString().equals(pluginDefName)) continue;
                this.context.deleteEntry(this.joinFormName, entry.getEntryId(), 0);
            }
        }
        this.removeServerPluginAlias(pluginServerName, pluginDefName, this.getPluginServerPort(pluginServerName));
        this.context.endBulkEntryTransaction(1);
    }

    private void removeServerPluginAlias(String pluginServerName, String pluginDefName, String pluginServerPort) throws ARException {
        if (pluginDefName == null || pluginServerPort == null) {
            return;
        }
        Map<String, List<String>> valForHostName = this.getConfigSettingsAsMap(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, PLUGIN_SVR_HOSTNAME);
        if (valForHostName == null || valForHostName.get(PLUGIN_SVR_HOSTNAME) == null || valForHostName.get(PLUGIN_SVR_HOSTNAME).get(0) == null) {
            return;
        }
        String serverName = valForHostName.get(PLUGIN_SVR_HOSTNAME).get(0);
        List<Entry> componentWithPrefix = this.getComponentWithPrefix(serverName, ARSERVER_COMPONENT_TYPE);
        if (componentWithPrefix != null && componentWithPrefix.size() > 0) {
            for (Entry thisEntry : componentWithPrefix) {
                String componentName = this.getComponentNameFromEntry(thisEntry);
                if (componentName == null || !componentName.equals(serverName)) continue;
                String serverPluginAliasValue = this.getServerPluginAliasValue(pluginDefName, componentName, pluginServerPort);
                List<Entry> configSettingsWithEntryIDs = this.getConfigSettingsWithEntryIDs(componentName, ARSERVER_COMPONENT_TYPE, SERVER_PLUGIN_ALIAS);
                if (configSettingsWithEntryIDs == null) continue;
                for (Entry configSettingEntry : configSettingsWithEntryIDs) {
                    Value settingValue = (Value)configSettingEntry.get((Object)3205);
                    if (settingValue == null || settingValue.toString() == null || !settingValue.toString().equals(serverPluginAliasValue)) continue;
                    this.context.deleteEntry(this.joinFormName, configSettingEntry.getEntryId(), 0);
                }
            }
        }
    }

    public ARPluginDefinition getPlugin(String pluginDefName, String pluginXmlPath, String pluginSetName) throws ARException {
        ArrayList<String> listJars;
        ArrayList<String> listClassPath;
        String pluginServerName = null;
        String targetPath = null;
        if (!ArrayCentralConfig.isWindows() && pluginXmlPath != null) {
            logger.info("Unix OS");
            try {
                logger.info("Calling method to resolve symbolic link");
                targetPath = this.resolveSymbolicLink(pluginXmlPath);
            }
            catch (IOException e) {
                logger.info("IO Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.info("Exception Occured" + e.getMessage());
                e.printStackTrace();
            }
        }
        if (targetPath != null && !StringUtils.isEmpty((String)targetPath.trim())) {
            logger.info("Passing symbolic link resolved path to plugin server lookup");
            pluginXmlPath = targetPath;
        }
        if ((pluginServerName = this.lookupPluginServer(pluginXmlPath)) == null) {
            return null;
        }
        String pluginNameWithPrefix = StringUtils.isBlank((String)pluginSetName) ? pluginDefName + "." : pluginSetName + "." + pluginDefName + ".";
        Map<String, List<String>> configSettingsAsMap = this.getConfigSettingsAsMap(pluginServerName, PLUGIN_SERVER_COMPONENT_TYPE, null);
        if (configSettingsAsMap == null) {
            return null;
        }
        String fileName = null;
        List<String> listFileName = configSettingsAsMap.get(pluginNameWithPrefix + "filename");
        if (listFileName != null && listFileName.size() > 0) {
            fileName = listFileName.get(0);
        }
        String className = null;
        List<String> listClassName = configSettingsAsMap.get(pluginNameWithPrefix + "classname");
        if (listClassName != null && listClassName.size() > 0) {
            className = listClassName.get(0);
        }
        if ((listClassPath = (ArrayList<String>)configSettingsAsMap.get(pluginNameWithPrefix + "pathelement.type.path")) == null) {
            listClassPath = new ArrayList<String>();
        }
        if ((listJars = (ArrayList<String>)configSettingsAsMap.get(pluginNameWithPrefix + "pathelement.type.location")) == null) {
            listJars = new ArrayList<String>();
        }
        HashMap<String, String> userDefinedParams = new HashMap<String, String>();
        for (String key : configSettingsAsMap.keySet()) {
            String udValue;
            if (!key.startsWith(pluginNameWithPrefix + "userDefined")) continue;
            String udKey = key.substring(key.lastIndexOf("userDefined") + "userDefined".length() + 1, key.length());
            String string = udValue = configSettingsAsMap.get(key) != null ? configSettingsAsMap.get(key).get(0) : "";
            if (udValue == null) {
                udValue = "";
            }
            userDefinedParams.put(udKey, udValue);
        }
        if (fileName == null && className == null && userDefinedParams.size() == 0 && listClassPath.size() == 0 && listJars.size() == 0) {
            return null;
        }
        ARPluginDefinition def = new ARPluginDefinition(pluginDefName, fileName, className);
        def.setClassPathJars(listJars);
        def.setClassPathFolders(listClassPath);
        def.setUserDefinedParams(userDefinedParams);
        return def;
    }

    private String lookupPluginServer(String pathToXml) throws ARException {
        List<Entry> exisitingComponents;
        boolean useMatch = false;
        if (pathToXml == null) {
            pathToXml = ".*pluginsvr[/\\\\]pluginsvr_config.xml";
            useMatch = true;
        }
        if ((exisitingComponents = this.getComponentWithPrefix("PluginServer_", PLUGIN_SERVER_COMPONENT_TYPE)) != null && exisitingComponents.size() > 0) {
            for (Entry entry : exisitingComponents) {
                Map<String, List<String>> valForPath;
                String hostName;
                if (entry.get((Object)3200) == null) continue;
                String componentName = ((Value)entry.get((Object)3200)).toString();
                String serverName = this.context.getServer().substring(0, this.context.getServer().indexOf(46) != -1 && !this.context.getServer().matches("^[0-9]+$") ? this.context.getServer().indexOf(46) : this.context.getServer().length());
                Map<String, List<String>> valForHostName = this.getConfigSettingsAsMap(componentName, PLUGIN_SERVER_COMPONENT_TYPE, PLUGIN_SVR_HOSTNAME);
                if (valForHostName == null || valForHostName.get(PLUGIN_SVR_HOSTNAME) == null || (hostName = valForHostName.get(PLUGIN_SVR_HOSTNAME).get(0)) == null || !hostName.substring(0, hostName.indexOf(46) != -1 && !hostName.matches("^[0-9]+$") ? hostName.indexOf(46) : hostName.length()).equalsIgnoreCase(serverName) || (valForPath = this.getConfigSettingsAsMap(componentName, PLUGIN_SERVER_COMPONENT_TYPE, PLUGIN_SVR_PATH)) == null || valForPath.get(PLUGIN_SVR_PATH) == null) continue;
                String pathToPluginXml = valForPath.get(PLUGIN_SVR_PATH).get(0);
                if (!(useMatch ? pathToPluginXml != null && pathToPluginXml.matches(pathToXml) : pathToXml.equals(pathToPluginXml))) continue;
                return componentName;
            }
        }
        return null;
    }

    public String getComponentGUID(String componentName, String componentType) throws ARException {
        Entry activeComponent = this.getActiveComponent(componentName, componentType);
        return activeComponent.get((Object)179) == null ? null : ((Value)activeComponent.get((Object)179)).toString();
    }

    private static boolean isWindows() {
        String os = ArrayCentralConfig.getOSPlatform();
        return os.indexOf("win") >= 0;
    }

    private static String getOSPlatform() {
        return System.getProperty("os.name").toLowerCase();
    }

    private String resolveSymbolicLink(String path) throws IOException {
        int i = 0;
        ArrayList<String> myList = new ArrayList<String>();
        File f = new File(path);
        do {
            myList.add(f.getName());
        } while ((f = f.getParentFile()).getParentFile() != null);
        Collections.reverse(myList);
        int listSize = myList.size();
        StringBuffer buffer = new StringBuffer();
        StringBuffer actualPath = new StringBuffer();
        for (i = 0; i < listSize; ++i) {
            buffer.append("/");
            actualPath.append("/");
            buffer.append((String)myList.get(i));
            logger.info("Path is.." + buffer.toString());
            Path linkPath = Paths.get(buffer.toString(), new String[0]);
            boolean isSymLink = false;
            isSymLink = Files.isSymbolicLink(linkPath);
            if (isSymLink) {
                logger.info("Passed path is Symbolic Link : " + linkPath);
                Path realPath = Files.readSymbolicLink(linkPath);
                logger.info("Resolving Symbolic link, Target Link is : " + realPath.toString());
                actualPath.delete(0, actualPath.length());
                actualPath.append(realPath.toString());
                continue;
            }
            logger.info("Symboli link : false");
            actualPath.append((String)myList.get(i));
        }
        logger.info("The constructed path is : " + actualPath.toString());
        return actualPath.toString();
    }
}

