/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.ascii;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseImporter;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import com.bmc.arsys.apiext.data.ascii.ASCIIParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ASCIIImporter
extends BaseImporter {
    private boolean createSourceForm = true;

    public ASCIIImporter(ImportOptions options) throws ARImportException {
        super(options);
    }

    public ASCIIImporter(ImportOptions options, String targetFormName) throws ARImportException {
        super(options);
    }

    @Override
    protected void handleDataEvent(List<String> tokens, String line) throws ARImportException, ARException {
        FormInformation formInfo;
        if (this.createSourceForm && (formInfo = this.options.getFileForms().get("ARImport_Data_Holder")) == null) {
            formInfo = this.createSourceForm(tokens);
            this.options.addFileForm(formInfo);
            this.setSourceForm(formInfo);
            this.createSourceForm = false;
        }
        if (this.getParser().isAbort()) {
            if (this.getParser().isCopyToLog()) {
                Util.logEntry(line);
            }
        } else {
            this.createEntry(tokens, line);
        }
    }

    @Override
    protected void handleTitlesEvent(List<String> tokens) throws ARException, ARImportException {
        FormInformation formInfo = this.options.getFileForms().get("ARImport_Data_Holder");
        if (formInfo == null) {
            formInfo = this.createSourceForm(tokens);
            this.options.addFileForm(formInfo);
        }
        String targetForm = null;
        targetForm = this.getTargetForm() == null ? this.options.getFormMap().get("ARImport_Data_Holder") : this.getTargetForm().getName();
        MappingOptions maps = this.options.getMappingOptions("ARImport_Data_Holder", targetForm);
        if (maps == null || maps.getMappings().isEmpty()) {
            Map<Integer, Mapping> fallbbc = null;
            if (maps != null) {
                fallbbc = maps.getFallbacks();
            }
            maps = Util.generateMappingsForTextFiles(this.getTargetForm(), formInfo);
            if (fallbbc != null) {
                maps.setFallbacks(fallbbc);
            }
            this.options.addMappingOptions("ARImport_Data_Holder", this.getTargetForm().getName(), maps);
        } else {
            FormInformation targetSchema = this.getTargetForm();
            FormInformation sourceSchema = this.getSourceForm();
            if (this.options.getDataOptions() != null && this.options.getDataOptions().getDuplicateFields() != null) {
                for (Integer duplicateField : this.options.getDataOptions().getDuplicateFields()) {
                    FieldInformation field;
                    if (maps.getMappings().containsKey(duplicateField) || (field = targetSchema.getFields().get(duplicateField)) == null || !tokens.contains(field.getName())) continue;
                    Mapping duplicateFieldMapping = new Mapping();
                    duplicateFieldMapping.setType(Mapping.Type.FIELDID);
                    duplicateFieldMapping.setFieldId(tokens.indexOf(field.getName()));
                    duplicateFieldMapping.setTokenIndex(tokens.indexOf(field.getName()));
                    duplicateFieldMapping.setFieldName(field.getName());
                    maps.addMapping(duplicateField, duplicateFieldMapping);
                }
            }
            for (Mapping map : maps.getMappings().values()) {
                if (map.getType() == Mapping.Type.FIELDNAME) {
                    int index = tokens.indexOf(map.getFieldName());
                    if (index == -1) continue;
                    if (map.getTokenIndex() == -1) {
                        map.setTokenIndex(index);
                    }
                    if (map.getFieldId() != -1) continue;
                    map.setFieldId(index);
                    continue;
                }
                if (map.getType() != Mapping.Type.COMPOUND || sourceSchema == null) continue;
                String buffer = map.getCompound();
                for (FieldInformation fieldInfo : sourceSchema.getFields().values()) {
                    String replace = "$" + fieldInfo.getName() + "$";
                    String with = "$" + fieldInfo.getTokenIndex() + "$";
                    buffer = buffer.replace(replace, with);
                }
                map.setCompound(buffer);
            }
        }
        super.handleTitlesEvent(tokens);
    }

    private FormInformation createSourceForm(List<String> tokens) {
        FormInformation result = new FormInformation();
        result.setName("ARImport_Data_Holder");
        for (int index = 0; index < tokens.size(); ++index) {
            String token = tokens.get(index);
            FieldInformation field = new FieldInformation();
            field.setName(token);
            field.setFieldId(index);
            field.setTokenIndex(index);
            result.getFields().put(index, field);
        }
        return result;
    }

    private void processFile(String fileName, String charSet) throws ARImportException, IOException, ARException {
        ((ASCIIParser)this.getParser()).parseFile(fileName, charSet);
    }

    @Override
    public void startImport() throws ARImportException, IOException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        this.importStartTime = new Date();
        logger.info((Object)MessageFormat.format(ImportErrors.STARTING_IMPORT.toDefMsg(), this.options.getFileOptions().getDataFile()));
        this.processFile(this.options.getFileOptions().getDataFile(), this.options.getFileOptions().getCharSet());
    }

    @Override
    protected Parser createParser() {
        return new ASCIIParser(this.options.getFileOptions().getSeparator(), this.options.getFileOptions().isHasTitles());
    }

    @Override
    protected FormInformation getTargetForm() throws ARException {
        Iterator<String> iterator;
        Map<String, MappingOptions> maps;
        if (super.getTargetForm() != null) {
            return super.getTargetForm();
        }
        String targetName = null;
        if (this.getSourceForm() != null && (maps = this.options.getMappingOptions("ARImport_Data_Holder")) != null && (iterator = maps.keySet().iterator()).hasNext()) {
            String name;
            targetName = name = iterator.next();
        }
        if (targetName == null) {
            String destinationFormName = this.options.getFormMap().get("ARImport_Data_Holder");
            if (destinationFormName != null) {
                this.setTargetForm(Util.getServerForm(this.options, destinationFormName));
                this.options.addServerForm(super.getTargetForm());
            } else {
                this.setTargetForm(this.options.getFirstServerForm());
            }
        }
        if (super.getTargetForm() == null && targetName != null) {
            this.setTargetForm(Util.getServerForm(this.options, targetName));
        }
        return super.getTargetForm();
    }
}

