/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.ImportErrors;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FieldInformation
implements Cloneable {
    public static final String INTEGER = "INTEGER";
    public static final String REAL = "REAL";
    public static final String CHAR = "CHAR";
    public static final String DIARY = "DIARY";
    public static final String ATTACH = "ATTACH";
    public static final String ENUM = "ENUM";
    public static final String TIME = "TIME";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String TIMEOFDAY = "TIMEOFDAY";
    public static final String CURRENCY = "CURRENCY";
    public static final String UNKNOWN = "Unknown";
    private int fieldId = 0;
    private String name = "";
    private DataType dataType = null;
    private FieldLimit limit = null;
    private Value defaultValue = null;
    private int tokenIndex = -1;
    private int fieldOption = 2;

    public int getEnumValue(String strValue) {
        if (this.limit != null && this.limit instanceof SelectionFieldLimit) {
            SelectionFieldLimit selectionLimit = (SelectionFieldLimit)this.limit;
            for (EnumItem item : selectionLimit.getValues()) {
                if (!strValue.trim().equals(item.getEnumItemName())) continue;
                return item.getEnumItemNumber();
            }
        }
        return -1;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = Integer.parseInt(fieldId.trim());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FieldLimit getLimit() {
        return this.limit;
    }

    public void setLimit(FieldLimit limit) {
        this.limit = limit;
    }

    public void setDataType(String dataType) throws ARImportException {
        if ((dataType = dataType.trim()).equalsIgnoreCase(INTEGER)) {
            this.setDataType(DataType.INTEGER);
            return;
        }
        if (dataType.equalsIgnoreCase(REAL)) {
            this.setDataType(DataType.REAL);
            return;
        }
        if (dataType.equalsIgnoreCase(CHAR)) {
            this.setDataType(DataType.CHAR);
            return;
        }
        if (dataType.equalsIgnoreCase(DIARY)) {
            this.setDataType(DataType.DIARY);
            return;
        }
        if (dataType.equalsIgnoreCase(ATTACH)) {
            this.setDataType(DataType.ATTACHMENT);
            return;
        }
        if (dataType.equalsIgnoreCase(ENUM)) {
            this.setDataType(DataType.ENUM);
            return;
        }
        if (dataType.equalsIgnoreCase(TIME)) {
            this.setDataType(DataType.TIME);
            return;
        }
        if (dataType.equalsIgnoreCase(DATE)) {
            this.setDataType(DataType.DATE);
            return;
        }
        if (dataType.equalsIgnoreCase(DECIMAL)) {
            this.setDataType(DataType.DECIMAL);
            return;
        }
        if (dataType.equalsIgnoreCase(TIMEOFDAY)) {
            this.setDataType(DataType.TIME_OF_DAY);
            return;
        }
        if (dataType.equalsIgnoreCase(CURRENCY)) {
            this.setDataType(DataType.CURRENCY);
            return;
        }
        if (!dataType.equalsIgnoreCase(UNKNOWN)) {
            throw new ARImportException(ImportErrors.UNKNOWN_DATATYPE.toDefMsg());
        }
        this.dataType = null;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Value defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("ID", this.fieldId);
        builder.append("Name", this.name);
        builder.append("DataType", this.dataType);
        builder.append("Default", this.defaultValue);
        builder.append("Limit", this.limit);
        return builder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        FieldInformation result = (FieldInformation)super.clone();
        result.dataType = this.dataType;
        result.defaultValue = this.defaultValue != null ? (Value)this.defaultValue.clone() : null;
        return result;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public void setFieldOption(int fieldOption) {
        this.fieldOption = fieldOption;
    }

    public int getFieldOption() {
        return this.fieldOption;
    }
}

