/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.common.ARConnection;
import com.bmc.arsys.common.ARConnectionFactory;
import com.bmc.arsys.common.ConnectionRetryInfo;
import com.bmc.arsys.common.LoggerHelper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ARConnectionCollection {
    private ARConnectionFactory connectionFactory;
    private Map<String, ARConnection> connectionMap;
    public static final int AR_CONN_REMOVAL_SUCCESS = 1;
    public static final int AR_CONN_REMOVAL_FAILURE = 0;
    private int clientType;

    public ARConnectionCollection() {
        this.connectionFactory = new ARConnectionFactory();
        this.connectionMap = new ConcurrentHashMap<String, ARConnection>();
    }

    public ARConnectionCollection(int n) {
        this.clientType = n;
        this.connectionFactory = new ARConnectionFactory();
        this.connectionMap = new ConcurrentHashMap<String, ARConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARConnection createARConnection(String string, String string2, String string3, String string4, int n, int n2, boolean bl, boolean bl2, ConnectionRetryInfo connectionRetryInfo) throws ARException {
        ARConnection aRConnection = null;
        if (!bl2) {
            aRConnection = this.getARConnection(string);
        }
        if (aRConnection == null) {
            block15: {
                aRConnection = this.connectionFactory.createARConnection(string, string2, string3, string4, n, n2, this.clientType, bl);
                try {
                    aRConnection.login();
                }
                catch (ARException aRException) {
                    ARException aRException2 = aRException;
                    LoggerHelper loggerHelper = null;
                    Logger logger = null;
                    boolean bl3 = false;
                    int n3 = 1;
                    int n4 = 0;
                    if (connectionRetryInfo != null) {
                        loggerHelper = connectionRetryInfo.getLoggerHelper();
                        logger = connectionRetryInfo.getLogger();
                        bl3 = connectionRetryInfo.isDebugMode();
                        n4 = connectionRetryInfo.getRetryMessageThreshold();
                        while (n3 <= connectionRetryInfo.getMaxRetryTimes() && this.isConnectionError(aRException2)) {
                            aRException2 = null;
                            if (n3 == n4 && loggerHelper != null && logger != null) {
                                loggerHelper.logFormattedErrorMessage(bl3, logger, connectionRetryInfo.getMessageSet(), connectionRetryInfo.getErrorMessageId(), null, connectionRetryInfo.getDefaultErrorMessage(), Locale.getDefault());
                            }
                            try {
                                Thread.sleep(connectionRetryInfo.getRetryIntervalInSeconds() * 1000);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                aRConnection.login();
                            }
                            catch (ARException aRException3) {
                                aRException2 = aRException3;
                            }
                            finally {
                                ++n3;
                            }
                        }
                    }
                    if (aRException2 != null) {
                        throw aRException2;
                    }
                    if (n3 <= n4 || loggerHelper == null || logger == null) break block15;
                    loggerHelper.logFormattedErrorMessage(bl3, logger, connectionRetryInfo.getMessageSet(), connectionRetryInfo.getSuccessMessageId(), null, connectionRetryInfo.getDefaultSuccessMessage(), Locale.getDefault());
                }
            }
            this.connectionMap.put(string, aRConnection);
        }
        return aRConnection;
    }

    private boolean isConnectionError(ARException aRException) {
        if (aRException != null) {
            List list = aRException.getLastStatus();
            if (list != null && !list.isEmpty()) {
                StatusInfo statusInfo = (StatusInfo)list.get(0);
                return statusInfo == null || statusInfo.getMessageNum() == 90L || statusInfo.getMessageNum() == 91L || statusInfo.getMessageNum() == 92L || statusInfo.getMessageNum() == 93L || statusInfo.getMessageNum() == 94L;
            }
            return true;
        }
        return false;
    }

    public ARConnection createARConnection(String string, String string2, String string3, String string4, int n, int n2, boolean bl, ConnectionRetryInfo connectionRetryInfo) throws ARException {
        return this.createARConnection(string, string2, string3, string4, n, n2, bl, false, connectionRetryInfo);
    }

    public ARConnection createARConnection(String string, String string2, String string3, String string4, int n, int n2, boolean bl) throws ARException {
        return this.createARConnection(string, string2, string3, string4, n, n2, bl, null);
    }

    public ARConnection getARConnection(String string) {
        return this.connectionMap.get(string);
    }

    public int closeAndRemoveARConnection(String string) {
        if (this.connectionMap.containsKey(string)) {
            ARConnection aRConnection = this.connectionMap.get(string);
            aRConnection.logout();
            this.connectionMap.remove(string);
            return 1;
        }
        return 0;
    }
}

