/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Util {
    private static final String WINDOWS_DIR_PATTERN = ".*[*?|\"].*";
    private static final String OTHER_DIR_PATTERN = ".*[:*?|\"].*";
    public static final int VALID = 0;
    public static final int INVALID_DIR = 1;
    public static final int INVALID_NAME = 2;
    public static final int EMPTY = 3;
    public static final int NONAME = 4;
    public static final int DIR_NONEXIST = 5;
    public static final int NO_EXTENSION = 6;
    public static final String CHARSET_TAG = "char-set:";

    public static BufferedReader openFile(String fileName, String charSet) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        InputStreamReader streamReader = null;
        streamReader = charSet != null && charSet.length() > 0 ? new InputStreamReader((InputStream)inStream, charSet) : new InputStreamReader(inStream);
        BufferedReader fileReader = new BufferedReader(streamReader);
        if (charSet == null) {
            String line = fileReader.readLine();
            String localCharSet = null;
            if (line != null && line.startsWith(CHARSET_TAG)) {
                localCharSet = line.replaceFirst(CHARSET_TAG, "").trim();
                fileReader.close();
                return Util.openFile(fileName, localCharSet);
            }
            fileReader.close();
            return Util.openFile(fileName, "");
        }
        return fileReader;
    }

    public static int validateFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return 3;
        }
        File exists = new File(fileName);
        int dotPosition = fileName.lastIndexOf(".");
        if (dotPosition == -1 || dotPosition == fileName.length() - 1) {
            return 6;
        }
        if (exists.isDirectory()) {
            return 4;
        }
        if (exists.exists()) {
            return 0;
        }
        int index = fileName.lastIndexOf(System.getProperty("file.separator"));
        if (index == -1) {
            index = fileName.lastIndexOf("/");
        }
        if (index == fileName.length()) {
            return 4;
        }
        String name = null;
        String dir = null;
        if (index == -1) {
            name = fileName;
        } else {
            name = fileName.substring(index + 1);
            dir = fileName.substring(0, index);
        }
        if (dir != null) {
            if (Util.isWindows() ? dir.matches(WINDOWS_DIR_PATTERN) : dir.matches(OTHER_DIR_PATTERN)) {
                return 1;
            }
            File file = new File(dir);
            if (!file.exists()) {
                file = null;
                return 5;
            }
        }
        if (name.matches(".*[\\/:*?|\"].*")) {
            return 2;
        }
        return 0;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toUpperCase();
        return os != null && os.startsWith("WINDOWS");
    }
}

