/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.utils.ARFileHandler;
import com.bmc.arsys.utils.ReadRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class ARConfigPersistence {
    private static Logger logger = Logger.getLogger(ARConfigPersistence.class);
    static final String AR_UNIX_SOURCEID_FILE1 = "/tmp/.apiSource.txt";
    static final String AR_UNIX_SOURCEID_FILE2 = "/var/tmp/.apiSource.txt";

    private ARConfigPersistence() {
    }

    public static String retrieveStoredKey(String nodeName, String keyId, String defaultValue) {
        String storedValue = defaultValue;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.substring(0, 3).equalsIgnoreCase("Win")) {
                try {
                    storedValue = ReadRegistry.getUserValue(nodeName, keyId);
                }
                catch (Exception e) {
                    logger.debug((Object)e.getLocalizedMessage());
                }
                if (storedValue != null) {
                    return storedValue;
                }
            } else {
                storedValue = ARFileHandler.readFromFile(AR_UNIX_SOURCEID_FILE1);
                if (storedValue != null) {
                    return storedValue;
                }
                storedValue = ARFileHandler.readFromFile(AR_UNIX_SOURCEID_FILE2);
                if (storedValue != null) {
                    return storedValue;
                }
            }
        }
        return storedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean persistKeyValue(String nodeName, String keyId, String value) {
        boolean successFlag = true;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.substring(0, 3).equalsIgnoreCase("Win")) {
                File file = null;
                Process proc = null;
                try {
                    file = new File("RegKey.reg");
                    boolean success = file.createNewFile();
                    if (success) {
                        BufferedWriter out = new BufferedWriter(new FileWriter(file));
                        String entryInRegFile = "Windows Registry Editor Version 5.00\n[HKEY_LOCAL_MACHINE\\SOFTWARE\\Remedy\\ARServer]\n\"apisourceid\"=\"" + value + "\"";
                        out.write(entryInRegFile);
                        out.close();
                    }
                    proc = Runtime.getRuntime().exec("regedit /S " + file.getName());
                    proc.waitFor();
                }
                catch (Throwable e) {
                    logger.debug((Object)("Not able to create the registry entry on" + System.getProperty("os.name")), e);
                    successFlag = false;
                }
                finally {
                    proc.destroy();
                    file.delete();
                }
            } else {
                File fileAtTmp = new File(AR_UNIX_SOURCEID_FILE1);
                File fileAtVarTmp = new File(AR_UNIX_SOURCEID_FILE2);
                if (fileAtTmp.exists()) {
                    ARFileHandler.writeToFile(fileAtTmp, value);
                } else if (fileAtVarTmp.exists()) {
                    ARFileHandler.writeToFile(fileAtVarTmp, value);
                } else {
                    try {
                        fileAtTmp.createNewFile();
                        if (fileAtTmp.exists()) {
                            ARFileHandler.writeToFile(fileAtTmp, value);
                        }
                    }
                    catch (IOException e) {
                        try {
                            fileAtVarTmp.createNewFile();
                            if (fileAtVarTmp.exists()) {
                                ARFileHandler.writeToFile(fileAtVarTmp, value);
                            }
                        }
                        catch (IOException e1) {
                            logger.debug((Object)("Not able to create the file at /tmp & also at /var/tmp on" + System.getProperty("os.name")), (Throwable)e1);
                            successFlag = false;
                        }
                    }
                }
            }
        }
        return successFlag;
    }

    public static boolean removeNodeAndKey(String nodeBase, String nodeName) {
        boolean successFlag = true;
        Preferences p = Preferences.systemRoot();
        try {
            if (p.nodeExists(nodeBase) && p.node(nodeBase).nodeExists(nodeName)) {
                p.node(nodeBase).node(nodeName).removeNode();
                p.flush();
            } else {
                logger.debug((Object)(nodeName + " node does not exist in JavaSoft\\Pref on " + System.getProperty("os.name")));
            }
        }
        catch (BackingStoreException e) {
            logger.debug((Object)("removeNodeAndKey not able to access JavaSoft\\Pref on " + System.getProperty("os.name")), (Throwable)e);
            successFlag = false;
        }
        return successFlag;
    }

    public static boolean removeKey(String nodeName, String key) {
        boolean successFlag = true;
        Preferences p = Preferences.systemRoot();
        try {
            if (p.nodeExists(nodeName)) {
                p.node(nodeName).remove(key);
                p.flush();
            } else {
                logger.debug((Object)(nodeName + " node does not exist in JavaSoft\\Pref on " + System.getProperty("os.name")));
            }
        }
        catch (BackingStoreException e) {
            logger.debug((Object)("removeKey not able to access JavaSoft\\Pref on " + System.getProperty("os.name")), (Throwable)e);
            successFlag = false;
        }
        return successFlag;
    }
}

