/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.bridge;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.bridge.BridgeUtil;
import com.kaazing.gateway.client.html5.impl.bridge.Proxy;
import com.kaazing.gateway.client.html5.impl.bridge.ProxyListener;
import com.kaazing.gateway.client.html5.impl.bridge.XoaEvent;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeChannel;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketNativeBridgeHandler
implements WebSocketHandler,
ProxyListener {
    private static final String CLASS_NAME = WebSocketNativeBridgeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private WebSocketHandlerListener listener;

    public WebSocketNativeBridgeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "processConnect", new Object[]{uri, protocol});
        try {
            WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
            if (nativeChannel.getProxy() != null) {
                throw new IllegalStateException("Bridge proxy previously set");
            }
            Proxy proxy = BridgeUtil.createProxy(uri.getURI(), this);
            proxy.setPeer(channel);
            nativeChannel.setProxy(proxy);
            Object[] params = protocol != null ? new String[]{"WEBSOCKET", uri.toString(), protocol, ""} : new String[]{"WEBSOCKET", uri.toString()};
            proxy.processEvent(XoaEvent.XoaEventKind.CREATE, params);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "While initializing WebSocket proxy: " + e.getMessage(), e);
            this.listener.connectionFailed(channel);
        }
    }

    @Override
    public void processAuthorize(WebSocketChannel channel, String authorizeToken) {
        LOG.entering(CLASS_NAME, "processAuthorize");
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.AUTHORIZE, new String[]{authorizeToken});
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String text) {
        throw new Error("Not implemented: Use binary message for wire traffic");
    }

    @Override
    public void processBinaryMessage(WebSocketChannel channel, ByteBuffer message) {
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(message.remaining());
        buffer.put(message.array(), message.arrayOffset(), message.remaining());
        buffer.flip();
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.POSTMESSAGE, new Object[]{buffer});
    }

    @Override
    public synchronized void processClose(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "processDisconnect");
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.DISCONNECT, new String[0]);
    }

    @Override
    public final void eventReceived(Proxy proxy, XoaEvent.XoaEventKind eventKind, Object[] params) {
        LOG.entering(CLASS_NAME, "eventReceived", new Object[]{proxy.getHandlerId(), eventKind, params});
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "SOA <-- XOA:id = " + proxy + " name: " + (Object)((Object)eventKind));
        }
        WebSocketNativeChannel channel = (WebSocketNativeChannel)proxy.getPeer();
        switch (eventKind) {
            case OPEN: {
                String protocol = (String)params[0];
                this.listener.connectionOpened(channel, protocol);
                break;
            }
            case CLOSED: {
                channel.setProxy(null);
                this.listener.connectionClosed(channel);
                break;
            }
            case REDIRECT: {
                String redirectUrl = (String)params[0];
                this.listener.redirected(channel, redirectUrl);
                break;
            }
            case AUTHENTICATE: {
                String location = channel.getLocation().toString();
                String challenge = (String)params[0];
                this.listener.authenticationRequested(channel, location, challenge);
                break;
            }
            case MESSAGE: {
                ByteBuffer messageBuffer = ByteBuffer.wrap((java.nio.ByteBuffer)params[0]);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, messageBuffer.getHexDump());
                }
                this.listener.messageReceived(channel, messageBuffer);
                break;
            }
            case ERROR: {
                this.listener.connectionFailed(channel);
            }
        }
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }
}

