/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wsn;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.EncoderOutput;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketUtil;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeEncoder;
import com.kaazing.gateway.client.html5.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class WebSocketNativeEncoderImpl
implements WebSocketNativeEncoder {
    private static final String CLASS_NAME = WebSocketNativeEncoderImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final byte WS_TEXT_FRAME_START = 0;
    private static final byte WS_TEXT_FRAME_END = -1;
    private static final byte WS_BINARY_FRAME_START = -128;

    protected WebSocketNativeEncoderImpl() {
    }

    @Override
    public void encodeTextMessage(WebSocketChannel channel, String message, EncoderOutput<WebSocketChannel> out) {
        LOG.entering(CLASS_NAME, "processTextMessage", message);
        byte[] payload = StringUtils.getUtf8Bytes(message);
        ByteBuffer buffer = ByteBuffer.allocate(payload.length + 2);
        buffer.put((byte)0);
        buffer.putBytes(payload);
        buffer.put((byte)-1);
        buffer.flip();
        out.write(channel, buffer);
    }

    @Override
    public void encodeBinaryMessage(WebSocketChannel channel, ByteBuffer message, EncoderOutput<WebSocketChannel> out) {
        LOG.entering(CLASS_NAME, "processBinaryMessage", message);
        ByteBuffer buffer = ByteBuffer.allocate(message.remaining() + 6);
        buffer.put((byte)-128);
        ByteArrayOutputStream lengthBytes = new ByteArrayOutputStream();
        WebSocketUtil.encodeLength(lengthBytes, message.remaining());
        buffer.putBytes(lengthBytes.toByteArray());
        buffer.putBuffer(message);
        buffer.flip();
        out.write(channel, buffer);
    }
}

