/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading;

import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.instrument.classloading.SimpleInstrumentableClassLoader;
import com.bmc.thirdparty.org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class SimpleLoadTimeWeaver
implements LoadTimeWeaver {
    private final SimpleInstrumentableClassLoader classLoader;

    public SimpleLoadTimeWeaver() {
        this.classLoader = new SimpleInstrumentableClassLoader(ClassUtils.getDefaultClassLoader());
    }

    public SimpleLoadTimeWeaver(SimpleInstrumentableClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

