/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.format.support;

import com.bmc.thirdparty.org.springframework.core.convert.support.DefaultConversionService;
import com.bmc.thirdparty.org.springframework.format.FormatterRegistry;
import com.bmc.thirdparty.org.springframework.format.datetime.DateFormatterRegistrar;
import com.bmc.thirdparty.org.springframework.format.datetime.joda.JodaTimeFormatterRegistrar;
import com.bmc.thirdparty.org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import com.bmc.thirdparty.org.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import com.bmc.thirdparty.org.springframework.format.support.FormattingConversionService;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.StringValueResolver;

public class DefaultFormattingConversionService
extends FormattingConversionService {
    private static final boolean jsr310Present = ClassUtils.isPresent("java.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());
    private static final boolean jodaTimePresent = ClassUtils.isPresent("org.joda.time.LocalDate", DefaultFormattingConversionService.class.getClassLoader());

    public DefaultFormattingConversionService() {
        this(null, true);
    }

    public DefaultFormattingConversionService(boolean registerDefaultFormatters) {
        this(null, registerDefaultFormatters);
    }

    public DefaultFormattingConversionService(StringValueResolver embeddedValueResolver, boolean registerDefaultFormatters) {
        this.setEmbeddedValueResolver(embeddedValueResolver);
        DefaultConversionService.addDefaultConverters(this);
        if (registerDefaultFormatters) {
            DefaultFormattingConversionService.addDefaultFormatters(this);
        }
    }

    public static void addDefaultFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jsr310Present) {
            new DateTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        }
        if (jodaTimePresent) {
            new JodaTimeFormatterRegistrar().registerFormatters(formatterRegistry);
        } else {
            new DateFormatterRegistrar().registerFormatters(formatterRegistry);
        }
    }
}

