/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.expression.spel.ast;

import com.bmc.thirdparty.org.springframework.expression.AccessException;
import com.bmc.thirdparty.org.springframework.expression.BeanResolver;
import com.bmc.thirdparty.org.springframework.expression.EvaluationException;
import com.bmc.thirdparty.org.springframework.expression.TypedValue;
import com.bmc.thirdparty.org.springframework.expression.spel.ExpressionState;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelEvaluationException;
import com.bmc.thirdparty.org.springframework.expression.spel.SpelMessage;
import com.bmc.thirdparty.org.springframework.expression.spel.ast.SpelNodeImpl;

public class BeanReference
extends SpelNodeImpl {
    private final String beanName;

    public BeanReference(int pos, String beanName) {
        super(pos, new SpelNodeImpl[0]);
        this.beanName = beanName;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        BeanResolver beanResolver = state.getEvaluationContext().getBeanResolver();
        if (beanResolver == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NO_BEAN_RESOLVER_REGISTERED, this.beanName);
        }
        try {
            return new TypedValue(beanResolver.resolve(state.getEvaluationContext(), this.beanName));
        }
        catch (AccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_BEAN_RESOLUTION, this.beanName, ex.getMessage());
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("@");
        if (!this.beanName.contains(".")) {
            sb.append(this.beanName);
        } else {
            sb.append("'").append(this.beanName).append("'");
        }
        return sb.toString();
    }
}

