/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework.autoproxy;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanCreationException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanCurrentlyInCreationException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.LinkedList;
import java.util.List;

public class BeanFactoryAdvisorRetrievalHelper {
    private static final Log logger = LogFactory.getLog(BeanFactoryAdvisorRetrievalHelper.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private String[] cachedAdvisorBeanNames;

    public BeanFactoryAdvisorRetrievalHelper(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Advisor> findAdvisorBeans() {
        String[] advisorNames = null;
        BeanFactoryAdvisorRetrievalHelper beanFactoryAdvisorRetrievalHelper = this;
        synchronized (beanFactoryAdvisorRetrievalHelper) {
            advisorNames = this.cachedAdvisorBeanNames;
            if (advisorNames == null) {
                this.cachedAdvisorBeanNames = advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, Advisor.class, true, false);
            }
        }
        if (advisorNames.length == 0) {
            return new LinkedList<Advisor>();
        }
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String name : advisorNames) {
            if (!this.isEligibleBean(name)) continue;
            if (this.beanFactory.isCurrentlyInCreation(name)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping currently created advisor '" + name + "'");
                continue;
            }
            try {
                advisors.add(this.beanFactory.getBean(name, Advisor.class));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.beanFactory.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Skipping advisor '" + name + "' with dependency on currently created bean: " + ex.getMessage());
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

