/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.utils.LogBytes;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.apache.log4j.Logger;

public class ArXdrTcpDecodingStream
extends XdrTcpDecodingStream {
    private static Logger logger = Logger.getLogger(ArXdrTcpDecodingStream.class);
    private boolean arEncryptionOnFlag = true;
    private boolean arProcessOnFlag = true;
    private transient boolean xdrDecodeDone = false;
    private transient boolean arDataNotInXdrBuffer = false;
    private int orgBufferBeginIndex;
    private int bufferSize;
    private boolean debug = false;

    public ArXdrTcpDecodingStream(Socket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.setBufferSize(bufferSize);
    }

    public ArXdrTcpDecodingStream(ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.setBufferSize(bufferSize);
    }

    protected ArXdrTcpDecodingStream(Socket streamingSocket, byte[] buffer) throws IOException {
        super(streamingSocket, buffer);
        this.setBufferSize(buffer.length);
    }

    protected ArXdrTcpDecodingStream(ArNetworkSocket streamingSocket, byte[] buffer) throws IOException {
        super(streamingSocket, buffer);
        this.setBufferSize(buffer.length);
    }

    public void arExcBeforeUnXdrDecodeParams(XdrAble result) throws OncRpcException, IOException {
        this.setXdrDecodeDone(false);
        this.orgBufferBeginIndex = this.getBufferIndex();
        if (this.isArEncryptionOn()) {
            byte[] rst = this.arEncBeforeUnXdrDecoding(this.getDecodedBuffer());
            if (super.getBuffer().length > rst.length + this.orgBufferBeginIndex) {
                System.arraycopy(rst, 0, super.getBuffer(), this.orgBufferBeginIndex, rst.length);
            } else {
                byte[] newBuffer = new byte[this.orgBufferBeginIndex + rst.length];
                System.arraycopy(super.getBuffer(), 0, newBuffer, 0, this.orgBufferBeginIndex);
                System.arraycopy(rst, 0, newBuffer, this.orgBufferBeginIndex, rst.length);
                super.setBuffer(newBuffer);
            }
            this.setBufferIndex(this.orgBufferBeginIndex);
            this.setBufferHighmark(this.orgBufferBeginIndex + rst.length - 4);
        }
    }

    protected byte[] arEncBeforeUnXdrDecoding(byte[] arBuffer) throws OncRpcException, IOException {
        if (this.isArProcessOn()) {
            System.out.println("Need to overrid! ArXdrTcpDecodingStream.arEncBeforeUnXdrDecoding() to apply ArXdrEnc processes the data before unxdr the data.");
        }
        return arBuffer;
    }

    protected byte[] getDecodedBuffer() {
        byte[] rst = null;
        byte[] buffer = this.getBuffer();
        if (this.debug) {
            LogBytes.printByteArrayAsHex(buffer, "ArXdrTcpDecodingStream.getDecodedBuffer- unxdr buffer");
        }
        if (!this.isDataNotInXdrBuffer()) {
            int len = this.getBufferHighmark() + 4 - this.getBufferIndex();
            rst = new byte[len];
            System.arraycopy(buffer, this.orgBufferBeginIndex, rst, 0, len);
        } else {
            rst = buffer;
        }
        if (this.debug) {
            LogBytes.printByteArrayAsHex(rst, "ArXdrTcpDecodingStream.getDecodedBuffer- param arBuffer for decryption");
        }
        return rst;
    }

    @Override
    public byte[] getBuffer() {
        byte[] rst = null;
        if (this.isArEncryptionOn() && this.getBufferIndex() < this.getBufferHighmark() && !this.isLastFragment()) {
            rst = this.arHandleFragment();
            this.setDataNotInXdrBuffer(true);
        } else {
            rst = super.getBuffer();
        }
        return rst;
    }

    protected byte[] arHandleFragment() {
        byte[] rst = null;
        int capacity = StringByteUtil.getNewBufferCapacityForExpanding(this.bufferSize, 0);
        if (logger.isDebugEnabled() && capacity > 500000) {
            logger.debug("handle fragment sets capacity to " + capacity);
        }
        ByteBuffer arTotalBuf = ByteBuffer.allocate(capacity);
        int localOrgBufferBeginIndex = this.getBufferIndex();
        byte[] header = new byte[localOrgBufferBeginIndex];
        int offset = localOrgBufferBeginIndex;
        System.arraycopy(super.getBuffer(), 0, header, 0, localOrgBufferBeginIndex);
        boolean done = false;
        do {
            int len = this.getBufferHighmark() + 4 - offset;
            if (logger.isDebugEnabled() && len > 500000) {
                logger.debug("checkAndExpandByteBufferCapacity to " + len);
            }
            arTotalBuf = StringByteUtil.checkAndExpandByteBufferCapacity(arTotalBuf, len);
            arTotalBuf.put(super.getBuffer(), offset, len);
            try {
                this.fill();
                offset = this.getBufferIndex();
            }
            catch (Exception e) {
                int tmpNewBufSize;
                int dataLen = arTotalBuf.position();
                rst = new byte[dataLen];
                arTotalBuf.position(0);
                arTotalBuf.get(rst);
                if (this.bufferSize <= dataLen + this.orgBufferBeginIndex && (tmpNewBufSize = this.changeBufferIfNeeded(dataLen + localOrgBufferBeginIndex + 4, super.getBuffer())) > 0) {
                    this.bufferSize = tmpNewBufSize;
                }
                if (this.bufferSize > dataLen + this.orgBufferBeginIndex) {
                    this.setBufferIndex(localOrgBufferBeginIndex);
                    this.setBufferHighmark(localOrgBufferBeginIndex + dataLen - 4);
                    System.arraycopy(header, 0, super.getBuffer(), 0, localOrgBufferBeginIndex);
                    System.arraycopy(rst, 0, super.getBuffer(), localOrgBufferBeginIndex, dataLen);
                }
                done = true;
            }
        } while (!done);
        arTotalBuf = null;
        return rst;
    }

    int changeBufferIfNeeded(int dataLen, byte[] bs) {
        return 0;
    }

    public boolean isArProcessOn() {
        return this.arProcessOnFlag;
    }

    public void setArProcessOn(boolean turnOnArProcess) {
        this.arProcessOnFlag = turnOnArProcess;
    }

    protected boolean isDataNotInXdrBuffer() {
        return this.arDataNotInXdrBuffer;
    }

    protected void setDataNotInXdrBuffer(boolean isDataNotInXdrBuffer) {
        this.arDataNotInXdrBuffer = isDataNotInXdrBuffer;
    }

    protected boolean isXdrDecodeDone() {
        return this.xdrDecodeDone;
    }

    protected void setXdrDecodeDone(boolean xdrDecodeDone) {
        this.xdrDecodeDone = xdrDecodeDone;
    }

    protected void resetArFlags() {
        this.setXdrDecodeDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    @Override
    public String xdrDecodeString() throws OncRpcException, IOException {
        String value = super.xdrDecodeString();
        if ("EUC_JP".equals(this.getCharacterEncoding())) {
            value = new String(value.getBytes("SJIS"), "windows-31j");
        }
        return value;
    }

    public boolean isArEncryptionOn() {
        return this.arEncryptionOnFlag;
    }

    public void setArEncryptionOn(boolean arEncryptionOnFlag) {
        this.arEncryptionOnFlag = arEncryptionOnFlag;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void readInHeaderOfNextFragment() throws IOException, OncRpcException {
        super.readInHeaderOfNextFragment();
    }
}

