/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncKeyBase;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARKeyMask;
import com.bmc.arsys.arencrypt.ARMdCrypto;
import com.bmc.arsys.arencrypt.CharDataEncryption;
import com.bmc.arsys.utils.ARCommonConfig;
import com.bmc.arsys.utils.StringByteUtil;
import org.apache.log4j.Logger;

public class PaddedPasswordEncryption
extends CharDataEncryption {
    private static Logger logger = Logger.getLogger(PaddedPasswordEncryption.class);

    @Override
    protected boolean isDebugEnabled() {
        return ARCommonConfig.getInstance().getLogBytes() && logger.isDebugEnabled();
    }

    public PaddedPasswordEncryption(boolean CRCFlag, boolean debug) {
        super(CRCFlag, debug);
    }

    @Override
    public void setPasswordKeyForEncryption(byte[] passwordKeyForEncryption) throws AREncryptionException {
        byte[] internalPasswordKey = this.obfuscatePassword(passwordKeyForEncryption);
        this.prepareDataKey(internalPasswordKey);
    }

    protected byte[] obfuscatePassword(byte[] passwordBytes) throws AREncryptionException {
        int strLen = passwordBytes.length;
        byte[] pswdInternal = passwordBytes;
        if (strLen < 30) {
            byte[] pswdInternalSufix = StringByteUtil.getByteArrays(ARKeyMask.getMaskedKeyBytes(0, ARKeyMask.Idx.EDFC, false), strLen, 30 - strLen);
            pswdInternal = StringByteUtil.concatenateByteArrays(passwordBytes, pswdInternalSufix);
        } else {
            pswdInternal = StringByteUtil.getByteArrays(passwordBytes, 0, 30);
        }
        ARMdCrypto mdCrypto = new ARMdCrypto();
        byte[] md = mdCrypto.MD5(pswdInternal);
        return StringByteUtil.base64Encode(md);
    }

    @Override
    protected void setSaltDataKeySize(AREncKeyBase encKey) {
        encKey.setKeySize(8);
    }
}

