/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArStatusBuffer12OutEx;
import com.bmc.arsys.api.FieldFunc;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.Value;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QuerySourceValues
extends Hashtable<IQuerySource, Map<Integer, Value>> {
    private static final long serialVersionUID = 8282373175531172434L;
    private static Logger logger = Logger.getLogger(QuerySourceValues.class);
    private Map<IQuerySource, HashMap<FieldFunc, Value>> fieldFuncMap = new HashMap<IQuerySource, HashMap<FieldFunc, Value>>();

    static List<QuerySourceValues> buildGLEWMSFResponse(ARServerUser context, RegularQuery query, ArStatusBuffer12OutEx arg0, String serverCharSetName, OutputInteger nMatches) throws ARException {
        IQuerySource querySource;
        ArrayList<QuerySourceValues> QuerySourceValuesList = new ArrayList<QuerySourceValues>();
        logger.debug("buildGLEWMSFResponse:serverCharSetName:" + serverCharSetName);
        if (arg0.outputBuf == null) {
            return QuerySourceValuesList;
        }
        String bufStr = null;
        try {
            bufStr = new String(arg0.outputBuf, serverCharSetName);
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex);
            throw new ARException(2, 9061, ex.getLocalizedMessage());
        }
        logger.debug("buildGLEWMSFResponse: buffer len=" + bufStr.length());
        int numEntries = 0;
        int numFieldsPerEntry = 0;
        int bIndex = 0;
        int eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            try {
                numEntries = new Integer(bufStr.substring(bIndex, eIndex));
            }
            catch (NumberFormatException nfe) {
                logger.debug("NFE occurs at index [" + bIndex + "] for # of entries. ");
                QuerySourceValues.logBuffer(bufStr);
                throw nfe;
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWMSF result buffer for the # of entries. " + bufStr.substring(bIndex));
            return QuerySourceValuesList;
        }
        bIndex = eIndex + 1;
        eIndex = bufStr.indexOf("\n", bIndex);
        if (eIndex > 0) {
            if (nMatches != null) {
                try {
                    nMatches.setValue(new Integer(bufStr.substring(bIndex, eIndex)));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("NFE occurs at index [" + bIndex + "] for the # of matches. ");
                    QuerySourceValues.logBuffer(bufStr);
                    throw nfe;
                }
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWMSF result buffer for the # of matches. " + bufStr.substring(bIndex));
            return QuerySourceValuesList;
        }
        if ((eIndex = bufStr.indexOf("\n", bIndex = eIndex + 1)) > 0) {
            try {
                numFieldsPerEntry = new Integer(bufStr.substring(bIndex, eIndex));
            }
            catch (NumberFormatException nfe) {
                logger.debug("NFE occurs at index [" + bIndex + "] for the # of fields per entry. ");
                QuerySourceValues.logBuffer(bufStr);
                throw nfe;
            }
        } else {
            logger.error("ERROR: Unable to parse GLEWF result buffer for the # of fields per entry. " + bufStr.substring(bIndex));
            return QuerySourceValuesList;
        }
        logger.debug("buildGLEWMSFResponse: numEntries=" + numEntries + " nMatches=" + (nMatches != null ? nMatches : Integer.valueOf(0)) + " numFieldsPerEntry=" + numFieldsPerEntry);
        ArrayList<QueryFormField> retFields = new ArrayList<QueryFormField>();
        for (int i = 0; i < numFieldsPerEntry; ++i) {
            bIndex = eIndex + 1;
            if ((eIndex = bufStr.indexOf("\n", bIndex)) > 0) {
                int limit = arg0.isGLEWMSF17Compatible() ? 3 : 2;
                String[] tmpBuf = bufStr.substring(bIndex, eIndex).split("\\\\", limit);
                if (tmpBuf == null || tmpBuf.length != limit) {
                    logger.error("ERROR: Unable to parse GLEWMSF result buffer for schema idxs/field IDs. " + bufStr.substring(bIndex));
                    return QuerySourceValuesList;
                }
                int fieldId = new Integer(tmpBuf[0]);
                int fieldFunc = arg0.isGLEWMSF17Compatible() ? new Integer(tmpBuf[1]) : 0;
                String schemaAlias = tmpBuf[limit - 1];
                querySource = null;
                List<IQuerySource> sources = query.getFromSources();
                for (int j = 0; j < sources.size(); ++j) {
                    if (schemaAlias == "" || !sources.get(j).getAlias().equals(schemaAlias)) continue;
                    querySource = sources.get(j);
                    try {
                        retFields.add(new QueryFormField(fieldId, fieldFunc, querySource));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index [" + bIndex + "] for schemaAlias. ");
                        QuerySourceValues.logBuffer(bufStr);
                        throw nfe;
                    }
                }
                if (querySource != null) continue;
                logger.error("ERROR: Unable to parse GLEWMSF result buffer for schema indexes. " + bufStr.substring(bIndex));
                return QuerySourceValuesList;
            }
            logger.error("ERROR: Unable to parse GLEWMSF result buffer for schema indexes. " + bufStr.substring(bIndex));
            return QuerySourceValuesList;
        }
        int lenDiff = 0;
        OutputInteger len = new OutputInteger();
        for (int i = 0; i < numEntries; ++i) {
            QuerySourceValues querySourceValues = new QuerySourceValues();
            for (int j = 0; j < retFields.size(); ++j) {
                int valJavaLen;
                Value value;
                int valSvrLen;
                int dataType;
                HashMap<Object, Object> fentry;
                Map<Integer, Value> entry;
                querySource = ((QueryFormField)retFields.get(j)).getSource();
                if (!querySourceValues.containsKey(querySource)) {
                    entry = new HashMap();
                    fentry = new HashMap();
                    querySourceValues.put(querySource, entry);
                    querySourceValues.fieldFuncMap.put(querySource, fentry);
                } else {
                    entry = (Map)querySourceValues.get(querySource);
                    fentry = querySourceValues.fieldFuncMap.get(querySource);
                }
                bIndex = eIndex + 1;
                eIndex = bufStr.indexOf("\\", bIndex);
                if (eIndex > 0) {
                    try {
                        dataType = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("NFE occurs at index[" + bIndex + "] for the dataType. ");
                        QuerySourceValues.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse GLEWMSF result buffer for the dataType. " + bufStr.substring(bIndex));
                    return QuerySourceValuesList;
                }
                bIndex = eIndex + 1;
                eIndex = bufStr.indexOf("\\", bIndex);
                if (eIndex > 0) {
                    try {
                        valSvrLen = new Integer(bufStr.substring(bIndex, eIndex));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("NFE occurs at index[" + bIndex + "] for the value length. ");
                        QuerySourceValues.logBuffer(bufStr);
                        throw nfe;
                    }
                } else {
                    logger.error("ERROR: Unable to parse GLEWMSF result buffer for the value length. " + bufStr.substring(bIndex));
                    return QuerySourceValuesList;
                }
                bIndex = eIndex + 1;
                if (valSvrLen > 0) {
                    value = Value.deserializeFromBytesBuffer(arg0.outputBuf, bIndex + lenDiff, valSvrLen, dataType, serverCharSetName, len);
                    valJavaLen = len.intValue();
                    lenDiff += valSvrLen - valJavaLen;
                } else {
                    value = new Value();
                    valJavaLen = 0;
                }
                eIndex = bIndex + valJavaLen;
                fentry.put(new FieldFunc(((QueryFormField)retFields.get(j)).getFieldId(), ((QueryFormField)retFields.get(j)).getFuncId()), value);
                if (((QueryFormField)retFields.get(j)).getFuncId() != 0) continue;
                entry.put(((QueryFormField)retFields.get(j)).getFieldId(), value);
            }
            QuerySourceValuesList.add(querySourceValues);
        }
        return QuerySourceValuesList;
    }

    public Map<IQuerySource, HashMap<FieldFunc, Value>> getFuncMap() {
        return this.fieldFuncMap;
    }

    private static void logBuffer(String buff) {
        String log = buff.replace("\\", "\\\\");
        log = log.replace("\n", "\\n");
        logger.debug("The complete buffer contents=" + log);
    }
}

