/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARQualifierHelper;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import java.util.List;
import java.util.Map;

class QualifierProcessor {
    private static final long serialVersionUID = -8401970432903421131L;
    private static final int MAX_AR_COND_OP_CODE = 5;
    private static final int MIN_AR_COND_OP_CODE = 0;
    private QualifierInfo mQualInfo;

    public QualifierProcessor(QualifierInfo qualInfo, Entry keywordList, Entry parameterList) throws ARException {
        this.mQualInfo = qualInfo;
        this.substituteFields(keywordList);
        this.substituteFields(parameterList);
    }

    public QualifierProcessor(ARServerUser serveruser, QualifierInfo qualInfo) throws ARException {
        this.mQualInfo = qualInfo;
    }

    public QualifierProcessor(ARServerUser serveruser, QualifierInfo qualInfo, Entry items) throws ARException {
        this.mQualInfo = qualInfo;
        this.substituteFields(items);
    }

    public QualifierProcessor(ARServerUser serveruser, String qualification, ARQualifierHelper qualHelper) throws ARException {
        this.parseQualification(serveruser, qualification, qualHelper);
    }

    public static final boolean isEncodedQualStr(String qual) {
        int df;
        return qual != null && qual.length() > 2 && (df = qual.charAt(0) - 48) <= 5 && df >= 0 && qual.charAt(1) == '\\';
    }

    private void parseQualification(ARServerUser serveruser, String qualification, ARQualifierHelper qualHelper) throws ARException {
        this.mQualInfo = qualHelper.parseQualification(serveruser.getLocale(), qualification);
    }

    public QualifierInfo getQualInfo() {
        return this.mQualInfo;
    }

    public void substituteFields(Entry items) throws ARException {
        this.mQualInfo = QualifierProcessor.substituteQualification(this.mQualInfo, items, null);
    }

    public void substituteExternal(Map externs) throws ARException {
        this.mQualInfo = QualifierProcessor.substituteQualification(this.mQualInfo, null, externs);
    }

    private static QualifierInfo substituteQualification(QualifierInfo qualinfo, Map fieldvaluemap, Map externmap) throws ARException {
        if (qualinfo == null) {
            return qualinfo;
        }
        switch (qualinfo.getOperation()) {
            case 1: 
            case 2: {
                return new QualifierInfo(qualinfo.getOperation(), QualifierProcessor.substituteQualification(qualinfo.getLeftOperand(), fieldvaluemap, externmap), QualifierProcessor.substituteQualification(qualinfo.getRightOperand(), fieldvaluemap, externmap));
            }
            case 3: {
                return new QualifierInfo(qualinfo.getOperation(), QualifierProcessor.substituteQualification(qualinfo.getNotOperand(), fieldvaluemap, externmap), null);
            }
            case 5: {
                int fid;
                Object o;
                if (externmap != null && (o = externmap.get(fid = qualinfo.getFromFieldInfo().getValue())) != null) {
                    QualifierInfo q = ((QualifierProcessor)o).getQualInfo();
                    if (q == null) {
                        return new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(new Value(1)), new ArithmeticOrRelationalOperand(new Value(1))));
                    }
                    return q;
                }
                return qualinfo;
            }
            case 0: {
                return qualinfo;
            }
            case 4: {
                if (fieldvaluemap == null) {
                    return qualinfo;
                }
                RelationalOperationInfo relop = qualinfo.getRelationalOperationInfo();
                switch (relop.getOperation()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return new QualifierInfo(new RelationalOperationInfo(relop.getOperation(), QualifierProcessor.substituteOperand(relop.getLeftOperand(), fieldvaluemap), QualifierProcessor.substituteOperand(relop.getRightOperand(), fieldvaluemap)));
                    }
                }
                throw new ARException(2, 144, Integer.toString(relop.getOperation()));
            }
        }
        throw new ARException(2, 142, Integer.toString(qualinfo.getOperation()));
    }

    private static ArithmeticOrRelationalOperand substituteOperand(ArithmeticOrRelationalOperand operand, Map fieldvaluemap) throws ARException {
        CurrencyPartInfo info;
        int fid;
        Value v;
        OperandType type = operand.getType();
        if (OperandType.ARITHMETIC_OP.equals(type)) {
            return new ArithmeticOrRelationalOperand(QualifierProcessor.substituteArithmeticOperation((ArithmeticOperationInfo)operand.getValue(), fieldvaluemap));
        }
        if (OperandType.FIELDID_CURRENT.equals(type)) {
            Integer fid2 = (Integer)operand.getValue();
            Value v2 = (Value)fieldvaluemap.get(fid2);
            if (v2 != null) {
                return new ArithmeticOrRelationalOperand(v2);
            }
        } else if (OperandType.VALUE.equals(type)) {
            Value v3 = (Value)operand.getValue();
            if (v3.getDataType().equals(DataType.KEYWORD)) {
                Keyword kw = (Keyword)v3.getValue();
                if (kw.isTimeRelated()) {
                    return new ArithmeticOrRelationalOperand(v3);
                }
                v3 = (Value)fieldvaluemap.get(kw.toInt());
                if (v3 != null) {
                    return new ArithmeticOrRelationalOperand(v3);
                }
            }
        } else if (OperandType.CURRENCY_FLD_CURRENT.equals(type) && (v = (Value)fieldvaluemap.get(fid = (info = (CurrencyPartInfo)operand.getValue()).getFieldId())) != null) {
            if (v.getDataType().equals(DataType.CURRENCY)) {
                switch (info.getPartTag()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        v = new Value(((CurrencyValue)v.getValue()).getValue());
                        break;
                    }
                    case 2: {
                        v = new Value(((CurrencyValue)v.getValue()).getCurrencyCode());
                        break;
                    }
                    case 3: {
                        v = new Value(((CurrencyValue)v.getValue()).getConversionDate());
                        break;
                    }
                    case 4: {
                        List<FuncCurrencyInfo> fci = ((CurrencyValue)v.getValue()).getFuncCurrencyList();
                        for (FuncCurrencyInfo cinfo : fci) {
                            if (!cinfo.getCurrencyCode().equals(info.getCurrencyCode())) continue;
                            v = new Value(cinfo.getValue());
                        }
                        break;
                    }
                }
            }
            return new ArithmeticOrRelationalOperand(v);
        }
        return operand;
    }

    private static ArithmeticOperationInfo substituteArithmeticOperation(ArithmeticOperationInfo operand, Map fieldvaluemap) throws ARException {
        switch (operand.getOperation()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new ArithmeticOperationInfo(operand.getOperation(), QualifierProcessor.substituteOperand(operand.getLeftOperand(), fieldvaluemap), QualifierProcessor.substituteOperand(operand.getRightOperand(), fieldvaluemap));
            }
            case 6: {
                return new ArithmeticOperationInfo(operand.getOperation(), null, QualifierProcessor.substituteOperand(operand.getRightOperand(), fieldvaluemap));
            }
        }
        throw new ARException(2, 146, Integer.toString(operand.getOperation()));
    }
}

